/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DisplayShutter {
    public static final String RECTANGULAR = "RECTANGULAR";
    public static final String CIRCULAR = "CIRCULAR";
    public static final String POLYGONAL = "POLYGONAL";
    private final List mShutterShapes;
    private Integer mPresentationValue;
    private Rectangle mRectangularShutter;
    private Point mCircleCentre;
    private int mCircleRadius;
    private List mPolygonalShutterVertices;

    public DisplayShutter(Collection collection, Integer n2) {
        this.mShutterShapes = new ArrayList(collection);
        this.mPresentationValue = n2;
    }

    public DisplayShutter(DisplayShutter displayShutter) {
        this(displayShutter.getShutterShapes(), displayShutter.getPresentationValue());
        if (displayShutter.mRectangularShutter != null) {
            this.mRectangularShutter = new Rectangle(displayShutter.mRectangularShutter);
        }
        if (displayShutter.mCircleCentre != null) {
            this.mCircleCentre = new Point(displayShutter.mCircleCentre);
            this.mCircleRadius = displayShutter.mCircleRadius;
        }
        if (displayShutter.mPolygonalShutterVertices != null) {
            this.mPolygonalShutterVertices = new ArrayList(displayShutter.mPolygonalShutterVertices);
        }
    }

    public void setPresentationValue(int n2) {
        this.mPresentationValue = new Integer(n2);
    }

    public void setRectangularShutter(int n2, int n3, int n4, int n5) {
        this.mRectangularShutter = new Rectangle(n2, n4, Math.abs(n3 - n2), Math.abs(n5 - n4));
    }

    public void setCircularShutter(int n2, int n3, int n4) {
        this.mCircleCentre = new Point(n2, n3);
        this.mCircleRadius = n4;
    }

    public void setPolygonalShutter(List list) {
        this.mPolygonalShutterVertices = new ArrayList(list);
    }

    public Point getCircleCentre() {
        return this.mCircleCentre;
    }

    public int getCircleRadius() {
        return this.mCircleRadius;
    }

    public List getPolygonalShutterVertices() {
        if (this.mPolygonalShutterVertices == null) {
            return new ArrayList();
        }
        return new ArrayList(this.mPolygonalShutterVertices);
    }

    public Integer getPresentationValue() {
        return this.mPresentationValue;
    }

    public Rectangle getRectangularShutter() {
        return this.mRectangularShutter;
    }

    public List getShutterShapes() {
        return new ArrayList(this.mShutterShapes);
    }

    public int getLeftVerticalEdge() {
        return (int)this.mRectangularShutter.getX();
    }

    public int getRightVerticalEdge() {
        return (int)this.mRectangularShutter.getMaxX();
    }

    public int getUpperHorizontalEdge() {
        return (int)this.mRectangularShutter.getY();
    }

    public int getLowerHorizontalEdge() {
        return (int)this.mRectangularShutter.getMaxY();
    }

    public boolean hasRectangularShutter() {
        return this.mShutterShapes.contains(RECTANGULAR) && this.mRectangularShutter != null;
    }

    public boolean hasCircularShutter() {
        return this.mShutterShapes.contains(CIRCULAR) && this.mCircleCentre != null;
    }

    public boolean hasPolygonalShutter() {
        return this.mShutterShapes.contains(POLYGONAL) && this.mPolygonalShutterVertices != null && this.mPolygonalShutterVertices.size() > 1 && this.mPolygonalShutterVertices.size() % 2 == 0;
    }

    public static DisplayShutter createDisplayShutter(DicomObject dicomObject) {
        int n2;
        Serializable serializable;
        int n3 = dicomObject.getSize(352);
        if (n3 <= 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(dicomObject.get(352, i2));
        }
        Integer n4 = (Integer)dicomObject.get(1377);
        DisplayShutter displayShutter = new DisplayShutter(arrayList, n4);
        Integer n5 = (Integer)dicomObject.get(353);
        Integer n6 = (Integer)dicomObject.get(354);
        Integer n7 = (Integer)dicomObject.get(355);
        Integer n8 = (Integer)dicomObject.get(356);
        if (n5 != null && n6 != null && n7 != null && n8 != null) {
            displayShutter.setRectangularShutter(n5, n6, n7, n8);
        }
        if (dicomObject.getSize(357) == 2) {
            Integer n9 = (Integer)dicomObject.get(357, 1);
            serializable = (Integer)dicomObject.get(357, 0);
            Integer n10 = (Integer)dicomObject.get(358);
            if (n9 != null && serializable != null && n10 != null) {
                displayShutter.setCircularShutter(n9, (Integer)serializable, n10);
            }
        }
        if ((n2 = dicomObject.getSize(359)) > 0) {
            serializable = new ArrayList(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                serializable.add(dicomObject.get(359, i3));
            }
            displayShutter.setPolygonalShutter((List)((Object)serializable));
        }
        return displayShutter;
    }

    public void writeToDicom(DicomObject dicomObject) throws DicomException {
        int n2 = 0;
        if (this.hasRectangularShutter()) {
            dicomObject.set(352, (Object)RECTANGULAR, n2++);
            dicomObject.set(353, (Object)new Integer(this.getLeftVerticalEdge()));
            dicomObject.set(354, (Object)new Integer(this.getRightVerticalEdge()));
            dicomObject.set(355, (Object)new Integer(this.getUpperHorizontalEdge()));
            dicomObject.set(356, (Object)new Integer(this.getLowerHorizontalEdge()));
        }
        if (this.hasCircularShutter()) {
            dicomObject.set(352, (Object)CIRCULAR, n2++);
            dicomObject.set(357, (Object)new Integer(this.getCircleCentre().y), 0);
            dicomObject.set(357, (Object)new Integer(this.getCircleCentre().x), 1);
            dicomObject.set(358, (Object)new Integer(this.getCircleRadius()));
        }
        if (this.hasPolygonalShutter()) {
            dicomObject.set(352, (Object)POLYGONAL, n2++);
            for (int i2 = 0; i2 < this.mPolygonalShutterVertices.size(); ++i2) {
                dicomObject.set(359, this.mPolygonalShutterVertices.get(i2), i2);
            }
        }
        if (this.mPresentationValue != null) {
            dicomObject.set(1377, (Object)this.mPresentationValue);
        }
    }
}

