/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.ImageMessage;
import J2cProtocol.J2cProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class GenericImageMessage
extends ImageMessage {
    protected GenericImageMessage() {
    }

    protected abstract void addString(String var1);

    public abstract String getString(int var1);

    public abstract int getNumberOfStrings();

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        String string;
        this.setImageIndex(dataInputStream.readInt());
        while ((string = GenericImageMessage.readString(dataInputStream)).length() != 0) {
            try {
                this.addString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                J2cProtocolException j2cProtocolException = new J2cProtocolException(illegalArgumentException.toString());
                j2cProtocolException.setStackTrace(illegalArgumentException.getStackTrace());
                throw j2cProtocolException;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        dataOutputStream.writeInt(this.getImageIndex());
        int n2 = this.getNumberOfStrings();
        for (int i2 = 0; i2 < n2; ++i2) {
            GenericImageMessage.writeString(dataOutputStream, this.getString(i2));
        }
        GenericImageMessage.writeString(dataOutputStream, "");
    }

    public int getLength() {
        int n2 = 6;
        int n3 = this.getNumberOfStrings();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += GenericImageMessage.writeStringLength(this.getString(i2));
        }
        return n2;
    }

    public String toString() {
        int n2 = this.getNumberOfStrings();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" (image ");
        stringBuffer.append(this.getImageIndex());
        stringBuffer.append(", ");
        stringBuffer.append(n2);
        stringBuffer.append(" elements)");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("\n   " + this.getString(i2));
        }
        return stringBuffer.toString();
    }
}

