/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.ActiveImageRequestMessage;
import J2cProtocol.ConnectReplyMessage;
import J2cProtocol.ConnectRequestMessage;
import J2cProtocol.DicomReplyMessage;
import J2cProtocol.DicomRequestMessage;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.ImageCompleteMessage;
import J2cProtocol.ImageInfoMessage;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.KduHeaderCompleteMessage;
import J2cProtocol.KduHeaderMessage;
import J2cProtocol.KduIncrementMessage;
import J2cProtocol.Message;
import J2cProtocol.NoDataToSendMessage;
import J2cProtocol.PauseReplyMessage;
import J2cProtocol.PauseRequestMessage;
import J2cProtocol.ResumeRequestMessage;
import J2cProtocol.RoiCompleteMessage;
import J2cProtocol.RoiRequestMessage;
import J2cProtocol.SeriesHeaderMessage;
import J2cProtocol.SeriesReplyMessage;
import J2cProtocol.SeriesRequestMessage;
import J2cProtocol.SeriesSettingsMessage;
import J2cProtocol.UnknownGenericImageMessage;
import J2cProtocol.UnknownGenericMessage;

public abstract class MessageFactory {
    static final int CONNECT_REQUEST_MESSAGE_CODE = 28951;
    static final int CONNECT_REPLY_MESSAGE_CODE = 28952;
    static final int PROXY_REQUEST_MESSAGE_CODE = 28953;
    static final int PROXY_REPLY_MESSAGE_CODE = 28954;
    static final int SERIES_REQUEST_MESSAGE_CODE = 1;
    static final int SERIES_REPLY_MESSAGE_CODE = 2;
    static final int SERIES_HEADER_MESSAGE_CODE = 3;
    static final int KDU_HEADER_MESSAGE_CODE = 4;
    static final int KDU_HEADER_COMPLETE_MESSAGE_CODE = 5;
    static final int KDU_INCREMENT_MESSAGE_CODE = 6;
    static final int ROI_COMPLETE_MESSAGE_CODE = 7;
    static final int ROI_REQUEST_MESSAGE_CODE = 8;
    static final int IMAGE_COMPLETE_MESSAGE_CODE = 9;
    static final int DISCONNECT_MESSAGE_CODE = 10;
    static final int ACTIVE_IMAGE_REQUEST_MESSAGE_CODE = 11;
    static final int PAUSE_REQUEST_MESSAGE_CODE = 12;
    static final int PAUSE_REPLY_MESSAGE_CODE = 13;
    static final int RESUME_REQUEST_MESSAGE_CODE = 14;
    static final int NO_DATA_TO_SEND_MESSAGE_CODE = 15;
    static final int DICOM_REQUEST_MESSAGE_CODE = 16;
    static final int DICOM_REPLY_MESSAGE_CODE = 17;
    static final int SERIES_SETTINGS_MESSAGE_CODE = 1001;
    static final int GENERIC_MESSAGE_CODE_MINIMUM = 1000;
    static final int GENERIC_MESSAGE_CODE_MAXIMUM = 1999;
    static final int IMAGE_INFO_MESSAGE_CODE = 2001;
    static final int GENERIC_IMAGE_MESSAGE_CODE_MINIMUM = 2000;
    static final int GENERIC_IMAGE_MESSAGE_CODE_MAXIMUM = 2999;

    protected abstract ConnectRequestMessage createConnectRequestMessage();

    protected abstract ConnectReplyMessage createConnectReplyMessage();

    protected abstract SeriesRequestMessage createSeriesRequestMessage();

    protected abstract SeriesReplyMessage createSeriesReplyMessage();

    protected abstract SeriesHeaderMessage createSeriesHeaderMessage();

    protected abstract KduHeaderMessage createKduHeaderMessage(byte[] var1);

    protected abstract KduHeaderCompleteMessage createKduHeaderCompleteMessage();

    protected abstract KduIncrementMessage createKduIncrementMessage(byte[] var1);

    protected abstract RoiCompleteMessage createRoiCompleteMessage(byte[] var1);

    protected abstract RoiRequestMessage createRoiRequestMessage(byte[] var1);

    protected abstract ImageCompleteMessage createImageCompleteMessage();

    protected abstract DisconnectMessage createDisconnectMessage();

    protected abstract ActiveImageRequestMessage createActiveImageRequestMessage();

    protected abstract PauseRequestMessage createPauseRequestMessage();

    protected abstract PauseReplyMessage createPauseReplyMessage();

    protected abstract ResumeRequestMessage createResumeRequestMessage();

    protected abstract NoDataToSendMessage createNoDataToSendMessage();

    protected abstract DicomRequestMessage createDicomRequestMessage();

    protected abstract DicomReplyMessage createDicomReplyMessage();

    protected abstract SeriesSettingsMessage createSeriesSettingsMessage();

    protected abstract ImageInfoMessage createImageInfoMessage();

    protected abstract UnknownGenericMessage createUnknownGenericMessage(int var1);

    protected abstract UnknownGenericImageMessage createUnknownGenericImageMessage(int var1);

    public Message createMessage(int n2, byte[] byArray) throws J2cProtocolException {
        Message message = null;
        switch (n2) {
            case 28951: {
                message = this.createConnectRequestMessage();
                break;
            }
            case 28952: {
                message = this.createConnectReplyMessage();
                break;
            }
            case 1: {
                message = this.createSeriesRequestMessage();
                break;
            }
            case 2: {
                message = this.createSeriesReplyMessage();
                break;
            }
            case 3: {
                message = this.createSeriesHeaderMessage();
                break;
            }
            case 4: {
                message = this.createKduHeaderMessage(byArray);
                break;
            }
            case 5: {
                message = this.createKduHeaderCompleteMessage();
                break;
            }
            case 6: {
                message = this.createKduIncrementMessage(byArray);
                break;
            }
            case 8: {
                message = this.createRoiRequestMessage(byArray);
                break;
            }
            case 7: {
                message = this.createRoiCompleteMessage(byArray);
                break;
            }
            case 9: {
                message = this.createImageCompleteMessage();
                break;
            }
            case 10: {
                message = this.createDisconnectMessage();
                break;
            }
            case 11: {
                message = this.createActiveImageRequestMessage();
                break;
            }
            case 12: {
                message = this.createPauseRequestMessage();
                break;
            }
            case 13: {
                message = this.createPauseReplyMessage();
                break;
            }
            case 14: {
                message = this.createResumeRequestMessage();
                break;
            }
            case 15: {
                message = this.createNoDataToSendMessage();
                break;
            }
            case 16: {
                message = this.createDicomRequestMessage();
                break;
            }
            case 17: {
                message = this.createDicomReplyMessage();
                break;
            }
            case 1001: {
                message = this.createSeriesSettingsMessage();
                break;
            }
            case 2001: {
                message = this.createImageInfoMessage();
            }
        }
        if (message != null) {
            return message;
        }
        if (n2 >= 1000 && n2 <= 1999) {
            return this.createUnknownGenericMessage(n2);
        }
        if (n2 >= 2000 && n2 <= 2999) {
            return this.createUnknownGenericImageMessage(n2);
        }
        throw new J2cProtocolException("Unknown message code: [" + n2 + "]");
    }
}

