/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.J2cProtocolException;
import kdu_jni.Kds_client_roi;
import kdu_jni.KduException;
import kdu_jni.Kdu_coords;
import kdu_jni.Kdu_dims;

public class RegionOfInterest {
    private Kds_client_roi mKdsClientRoi = null;
    private int mFirstImageComponent = 0;
    private int mNumberOfImageComponents = 1;
    private int mDiscardedResolutionLevels = 0;
    private int mLeftCoordinate = 0;
    private int mUpperCoordinate = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private double mCompressionFraction = 0.0;

    public RegionOfInterest(int n2, int n3, int n4, int n5, int n6, int n7, int n8, double d2) {
        this.mFirstImageComponent = n2;
        this.mNumberOfImageComponents = n3;
        this.mDiscardedResolutionLevels = n4;
        this.mLeftCoordinate = n5;
        this.mUpperCoordinate = n6;
        this.mWidth = n7;
        this.mHeight = n8;
        this.mCompressionFraction = d2;
    }

    public RegionOfInterest(RegionOfInterest regionOfInterest) {
        this(regionOfInterest.getFirstImageComponent(), regionOfInterest.getNumberOfImageComponents(), regionOfInterest.getDiscardedResolutionLevels(), regionOfInterest.getLeftCoordinate(), regionOfInterest.getUpperCoordinate(), regionOfInterest.getWidth(), regionOfInterest.getHeight(), regionOfInterest.getCompressionFraction());
    }

    public RegionOfInterest(Kds_client_roi kds_client_roi) throws J2cProtocolException {
        this(kds_client_roi, 1.0);
    }

    public RegionOfInterest(Kds_client_roi kds_client_roi, double d2) throws J2cProtocolException {
        this.mKdsClientRoi = kds_client_roi;
        this.initialize(kds_client_roi, d2);
    }

    public RegionOfInterest(byte[] byArray) throws J2cProtocolException {
        int n2;
        this.mKdsClientRoi = new Kds_client_roi();
        try {
            n2 = this.mKdsClientRoi.Deserialize(byArray, byArray.length);
        }
        catch (KduException kduException) {
            throw new J2cProtocolException(kduException.toString());
        }
        double d2 = (double)this.deserializeInt(byArray, n2) / 2.147483647E9;
        this.initialize(this.mKdsClientRoi, d2);
    }

    private RegionOfInterest() {
    }

    private void initialize(Kds_client_roi kds_client_roi, double d2) throws J2cProtocolException {
        try {
            this.mFirstImageComponent = kds_client_roi.Get_min_component();
            this.mNumberOfImageComponents = kds_client_roi.Get_num_components();
            this.mDiscardedResolutionLevels = kds_client_roi.Get_discard_levels();
            Kdu_dims kdu_dims = new Kdu_dims();
            kds_client_roi.Get_region(kdu_dims);
            this.mLeftCoordinate = kdu_dims.Access_pos().Get_x();
            this.mUpperCoordinate = kdu_dims.Access_pos().Get_y();
            this.mWidth = kdu_dims.Access_size().Get_x();
            this.mHeight = kdu_dims.Access_size().Get_y();
            this.mCompressionFraction = d2;
        }
        catch (KduException kduException) {
            throw new J2cProtocolException(kduException.toString());
        }
    }

    public boolean contains(RegionOfInterest regionOfInterest) throws J2cProtocolException {
        try {
            if (!this.getKdsClientRoi().Contains(regionOfInterest.getKdsClientRoi())) {
                return false;
            }
            return this.mCompressionFraction >= regionOfInterest.mCompressionFraction;
        }
        catch (KduException kduException) {
            throw new J2cProtocolException(kduException.toString());
        }
    }

    public Kds_client_roi getKdsClientRoi() throws KduException {
        if (this.mKdsClientRoi == null) {
            Kdu_dims kdu_dims = new Kdu_dims();
            Kdu_coords kdu_coords = kdu_dims.Access_pos();
            kdu_coords.Set_x(this.getLeftCoordinate());
            kdu_coords.Set_y(this.getUpperCoordinate());
            Kdu_coords kdu_coords2 = kdu_dims.Access_size();
            kdu_coords2.Set_x(this.getWidth());
            kdu_coords2.Set_y(this.getHeight());
            this.mKdsClientRoi = new Kds_client_roi(this.getFirstImageComponent(), this.getNumberOfImageComponents(), this.getDiscardedResolutionLevels(), kdu_dims);
        }
        return this.mKdsClientRoi;
    }

    private void resetKdsClientRoi() {
        this.mKdsClientRoi = null;
    }

    public int serialize(byte[] byArray, int n2) throws J2cProtocolException {
        int n3;
        try {
            n3 = this.getKdsClientRoi().Serialize(byArray, n2);
        }
        catch (KduException kduException) {
            throw new J2cProtocolException(kduException.toString());
        }
        if (n3 == 0) {
            throw new ArrayIndexOutOfBoundsException("Error serializing region of interest");
        }
        int n4 = (int)Math.round(this.mCompressionFraction * 2.147483647E9);
        this.serializeInt(byArray, n2, n3, n4);
        return n3 + 4;
    }

    private void serializeInt(byte[] byArray, int n2, int n3, int n4) {
        if (n3 + 4 >= n2) {
            throw new ArrayIndexOutOfBoundsException("Error serializing region of interest");
        }
        byArray[n3 + 0] = (byte)(0xFF & n4 >> 24);
        byArray[n3 + 1] = (byte)(0xFF & n4 >> 16);
        byArray[n3 + 2] = (byte)(0xFF & n4 >> 8);
        byArray[n3 + 3] = (byte)(0xFF & n4);
    }

    private int deserializeInt(byte[] byArray, int n2) {
        return (byArray[n2 + 0] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public int getFirstImageComponent() {
        return this.mFirstImageComponent;
    }

    public void setFirstImageComponent(int n2) {
        this.resetKdsClientRoi();
        this.mFirstImageComponent = n2;
    }

    public int getNumberOfImageComponents() {
        return this.mNumberOfImageComponents;
    }

    public void setNumberOfImageComponents(int n2) {
        this.resetKdsClientRoi();
        this.mNumberOfImageComponents = n2;
    }

    public int getDiscardedResolutionLevels() {
        return this.mDiscardedResolutionLevels;
    }

    public void setDiscardedResolutionLevels(int n2) {
        this.resetKdsClientRoi();
        this.mDiscardedResolutionLevels = n2;
    }

    public int getUpperCoordinate() {
        return this.mUpperCoordinate;
    }

    public void setUpperCoordinate(int n2) {
        this.resetKdsClientRoi();
        this.mUpperCoordinate = n2;
    }

    public int getLeftCoordinate() {
        return this.mLeftCoordinate;
    }

    public void setLeftCoordinate(int n2) {
        this.resetKdsClientRoi();
        this.mLeftCoordinate = n2;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int n2) {
        this.resetKdsClientRoi();
        this.mHeight = n2;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int n2) {
        this.resetKdsClientRoi();
        this.mWidth = n2;
    }

    public double getCompressionFraction() {
        return this.mCompressionFraction;
    }

    public void setCompressionFraction(double d2) {
        this.mCompressionFraction = d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Region of Interest:");
        stringBuffer.append("\n  mFirstImageComponent       = ");
        stringBuffer.append(this.mFirstImageComponent);
        stringBuffer.append("\n  mNumberOfImageComponents   = ");
        stringBuffer.append(this.mNumberOfImageComponents);
        stringBuffer.append("\n  mDiscardedResolutionLevels = ");
        stringBuffer.append(this.mDiscardedResolutionLevels);
        stringBuffer.append("\n  mLeftCoordinate            = ");
        stringBuffer.append(this.mLeftCoordinate);
        stringBuffer.append("\n  mUpperCoordinate           = ");
        stringBuffer.append(this.mUpperCoordinate);
        stringBuffer.append("\n  mWidth                     = ");
        stringBuffer.append(this.mWidth);
        stringBuffer.append("\n  mHeight                    = ");
        stringBuffer.append(this.mHeight);
        stringBuffer.append("\n  mCompressionFraction       = ");
        stringBuffer.append(this.mCompressionFraction);
        return stringBuffer.toString();
    }
}

