/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.DisplayShutter;
import J2cProtocol.ImageAcquisitionMatrix;
import J2cProtocol.ImageId;
import J2cProtocol.J2cMissingValueException;
import StringUtilities.StringCheck;
import StringUtilities.StringJoin;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class SeriesHeader {
    public static final int ANY_FRAME = -1;
    public static final int UNSIGNED_PIXEL_REPRESENTATION = 0;
    public static final int SIGNED_PIXEL_REPRESENTATION = 1;
    public static final int dImsSourceAeTitle = -1;
    public static final int dImsInstitutionCode = -2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Multiplicity getTagMultiplicity(int n2) {
        switch (n2) {
            case 101: 
            case 102: 
            case 154: 
            case 185: 
            case 308: 
            case 330: 
            case 352: 
            case 357: 
            case 436: 
            case 440: 
            case 441: 
            case 470: 
            case 473: 
            case 1301: {
                return Multiplicity.MULTI;
            }
            case 582: 
            case 589: {
                return Multiplicity.SEQUENCE;
            }
        }
        return Multiplicity.SINGLE;
    }

    public static int getSequenceTag(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 582: 
            case 589: {
                return 1211;
            }
        }
        throw new IllegalArgumentException("Unknown sequence tag " + n2);
    }

    protected static boolean isArray(int n2) {
        return SeriesHeader.getTagMultiplicity(n2) != Multiplicity.SINGLE;
    }

    private static void checkArrayReturn(int n2, Object object) {
        if (object == null) {
            return;
        }
        if (SeriesHeader.isArray(n2)) {
            if (!$assertionsDisabled && !(object instanceof Object[])) {
                throw new AssertionError((Object)("Expected array but got scalar [" + object + "]"));
            }
        } else if (!$assertionsDisabled && object instanceof Object[]) {
            throw new AssertionError((Object)"Expected scalar but got array");
        }
    }

    public List addSopInstance(DicomObject dicomObject) {
        return Collections.EMPTY_LIST;
    }

    public void replaceSopInstance(DicomObject dicomObject) {
    }

    public final boolean hasElement(int n2) {
        return this.getElementValue(n2) != null;
    }

    public final boolean hasElement(ImageId imageId, int n2) {
        return this.getElementValue(imageId, n2) != null;
    }

    public final Object getElementValue(ImageId imageId, int n2) {
        return this.getElementValue(imageId.getSeriesHeaderIndex(), n2);
    }

    public abstract Object getElementValue(int var1, int var2);

    public final Object getElementValue(int n2) {
        Object object = this.getElementValue(-1, n2);
        SeriesHeader.checkArrayReturn(n2, object);
        return object;
    }

    public final Object getElementValue(ImageId imageId, int n2, Object object) {
        Object object2 = this.getElementValue(imageId, n2);
        SeriesHeader.checkArrayReturn(n2, object2);
        return object2 == null ? object : object2;
    }

    public final Object getElementValue(int n2, Object object) {
        Object object2 = this.getElementValue(n2);
        SeriesHeader.checkArrayReturn(n2, object2);
        return object2 == null ? object : object2;
    }

    public final String getElementValueString(int n2, String string) {
        String string2 = (String)this.getElementValue(n2);
        SeriesHeader.checkArrayReturn(n2, string2);
        return string2 == null ? string : string2;
    }

    public final String getElementValueString(ImageId imageId, int n2, String string) {
        String string2 = (String)this.getElementValue(imageId, n2);
        SeriesHeader.checkArrayReturn(n2, string2);
        return string2 == null ? string : string2;
    }

    public final double getElementValueDouble(ImageId imageId, int n2, double d2) {
        Number number = (Number)this.getElementValue(imageId, n2);
        SeriesHeader.checkArrayReturn(n2, number);
        return number == null ? d2 : number.doubleValue();
    }

    public final int getElementValueInt(int n2, int n3) {
        Number number = (Number)this.getElementValue(n2);
        SeriesHeader.checkArrayReturn(n2, number);
        return number == null ? n3 : number.intValue();
    }

    public final int getElementValueInt(ImageId imageId, int n2, int n3) {
        Number number = (Number)this.getElementValue(imageId, n2);
        SeriesHeader.checkArrayReturn(n2, number);
        return number == null ? n3 : number.intValue();
    }

    public final String getElementUiString(ImageId imageId, int n2) {
        Object object = this.getElementValue(imageId, n2);
        return SeriesHeader.getElementUiString(n2, object);
    }

    public final String getElementUiString(int n2) {
        Object object = this.getElementValue(n2);
        return SeriesHeader.getElementUiString(n2, object);
    }

    public final String getElementUiString(int n2, int n3) {
        Object object = this.getElementValue(n2, n3);
        return SeriesHeader.getElementUiString(n3, object);
    }

    private static String getElementUiString(int n2, Object object) {
        SeriesHeader.checkArrayReturn(n2, object);
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            switch (n2) {
                case 473: {
                    if (objectArray.length == 2) break;
                    return "";
                }
                case 102: 
                case 154: {
                    return StringJoin.arrayJoin(objectArray, ", ");
                }
            }
            return "[" + StringJoin.arrayJoin(objectArray, ", ") + "]";
        }
        if (object instanceof DDate) {
            return ((DDate)object).toDICOMString();
        }
        if (object instanceof Person) {
            return ((Person)object).toDICOMString();
        }
        return object.toString();
    }

    protected void checkIndex(int n2) {
        if (n2 < 0 || n2 >= this.getNumberOfImages()) {
            throw new IndexOutOfBoundsException("SeriesHeader index out of range: " + n2);
        }
    }

    public String getStudyInstanceUid() {
        return "";
    }

    public String getStudyId() {
        return "";
    }

    public String getStudyDate() {
        return "";
    }

    public String getStudyTime() {
        return "";
    }

    public String getStudyDescription() {
        return "";
    }

    public String getStudyAccessionNumber() {
        return "";
    }

    public String getStudyReferringPhysiciansName() {
        return "";
    }

    public String getRequestedProcedureId() {
        return "";
    }

    public String getSeriesInstanceUid() {
        return "";
    }

    public String getSeriesDate() {
        return "";
    }

    public String getSeriesTime() {
        return "";
    }

    public String getSeriesDescription() {
        return "";
    }

    public String getSeriesNumber() {
        return "";
    }

    public String getSeriesModality() {
        return "";
    }

    public String getSeriesInstitutionName() {
        return "";
    }

    public String getFrameOfReferenceUid() {
        return "";
    }

    public String getImageAcquisitionNumber(int n2) {
        return "";
    }

    public String getPatientName() {
        return "";
    }

    public String getPatientId() {
        return "";
    }

    public String getPatientBirthDate() {
        return "";
    }

    public String getPatientSex() {
        return "";
    }

    public String getPatientAge() {
        return "";
    }

    public int getNumberOfImages() {
        return 0;
    }

    public int getImagePixelValueShift(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public final int getImagePixelValueShift(ImageId imageId) throws J2cMissingValueException {
        return this.getImagePixelValueShift(imageId.getSeriesHeaderIndex());
    }

    public final String getImageSopInstanceUid(ImageId imageId) {
        return this.getImageSopInstanceUid(imageId.getSeriesHeaderIndex());
    }

    public String getImageSopInstanceUid(int n2) {
        this.checkIndex(n2);
        return "";
    }

    public final String getImageJ2cFileName(ImageId imageId) {
        return this.getImageJ2cFileName(imageId.getSeriesHeaderIndex());
    }

    public String getImageJ2cFileName(int n2) {
        this.checkIndex(n2);
        return "";
    }

    public int getImageInstanceNumber(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public int getImageEchoNumber(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public final int getImageFrameNumber(ImageId imageId) throws J2cMissingValueException {
        return this.getImageFrameNumber(imageId.getSeriesHeaderIndex());
    }

    public int getImageFrameNumber(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public int getImageNumberOfFrames(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public String getImagePhotometricInterpretation(int n2) {
        this.checkIndex(n2);
        return "";
    }

    public int getImageRows(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public int getImageColumns(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public final boolean hasImagePercentile(ImageId imageId, String string) {
        return this.hasImagePercentile(imageId.getSeriesHeaderIndex(), string);
    }

    public boolean hasImagePercentile(int n2, String string) {
        this.checkIndex(n2);
        return false;
    }

    public final double getImagePercentile(ImageId imageId, String string) throws J2cMissingValueException {
        return this.getImagePercentile(imageId.getSeriesHeaderIndex(), string);
    }

    public double getImagePercentile(int n2, String string) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public double getImageWindowLevelCentre(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public double getImageWindowLevelWidth(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public double getImageRescaleIntercept(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public double getImageRescaleSlope(int n2) throws J2cMissingValueException {
        this.checkIndex(n2);
        throw new J2cMissingValueException();
    }

    public final ImageAcquisitionMatrix getImageAcquisitionMatrix(ImageId imageId) {
        return this.getImageAcquisitionMatrix(imageId.getSeriesHeaderIndex());
    }

    public ImageAcquisitionMatrix getImageAcquisitionMatrix(int n2) {
        this.checkIndex(n2);
        return null;
    }

    public final DisplayShutter getImageDisplayShutter(ImageId imageId) {
        return this.getImageDisplayShutter(imageId.getSeriesHeaderIndex());
    }

    public DisplayShutter getImageDisplayShutter(int n2) {
        this.checkIndex(n2);
        return null;
    }

    public final ImageId getImageId(int n2) {
        if (n2 < 0 || n2 >= this.getNumberOfImages()) {
            throw new IndexOutOfBoundsException("image index " + n2 + " not in range [0," + (this.getNumberOfImages() - 1) + "]");
        }
        return new ImageId(n2);
    }

    public final ImageId findImageId(String string, int n2) {
        if (string == null) {
            throw new NullPointerException();
        }
        for (int i2 = 0; i2 < this.getNumberOfImages(); ++i2) {
            int n3 = 0;
            if (n2 < 0) {
                n3 = n2;
            } else {
                try {
                    n3 = this.getImageFrameNumber(i2);
                }
                catch (J2cMissingValueException j2cMissingValueException) {
                    // empty catch block
                }
            }
            if (!string.equals(this.getImageSopInstanceUid(i2)) || n3 != n2) continue;
            return this.getImageId(i2);
        }
        return null;
    }

    public final Set getImageIds() {
        HashSet<ImageId> hashSet = new HashSet<ImageId>();
        for (int i2 = 0; i2 < this.getNumberOfImages(); ++i2) {
            hashSet.add(this.getImageId(i2));
        }
        return hashSet;
    }

    public Set getSopInstances() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumberOfImages(); ++i2) {
            hashSet.add(this.getImageSopInstanceUid(i2));
        }
        return hashSet;
    }

    public static int[] getSupportedTags() {
        return new int[]{425, 427, 64, 70, 95, 77, 88, 1419, 589, 582, 1206, 426, 65, 71, 97, 428, 81, 84, 85, 195, 442, 429, 66, 72, 147, 148, 150, 152, 157, 177, 479, 480, 63, 62, 430, 219, 464, 462, 440, 441, 436, 466, 467, 478, 470, 487, 488, 489, 490, 214, 215, 332, 205, 221, 206, 299, 298, 300, 280, 224, 330, 473, 182, 380, 276, 451, 179, 459, 213, 320, 207, 321, 154, 159, 1207, 102, 239, 381, 122, 220, 277, 278, 346, 347, 1308, 341, 384, 323, 185, 216, 225, 226, 445, 444, 227, 173, 101, 443, 450, 1263, 1264, 1265, 1301, 187, 504, 134, 204, 229, 254, 541, -1, -2};
    }

    protected static DDate createDDate(String string) {
        if (StringCheck.isStringBlank(string)) {
            return null;
        }
        return new DDate(string);
    }

    protected static Person createPerson(String string) {
        if (StringCheck.isStringBlank(string)) {
            return null;
        }
        return new Person(string);
    }

    protected static Integer[] integerVectorToArray(Vector vector, int n2) {
        if (vector == null || vector.size() != n2) {
            return null;
        }
        Integer[] integerArray = new Integer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            integerArray[i2] = (Integer)vector.get(i2);
        }
        return integerArray;
    }

    protected static Object[] doubleVectorToArray(Vector vector, int n2) {
        if (vector == null || vector.size() != n2) {
            return null;
        }
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = new Float(((Double)vector.get(i2)).floatValue());
        }
        return objectArray;
    }

    protected Integer convertStringToInteger(String string) {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Float convertStringToFloat(String string) {
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Double convertStringToDouble(String string) {
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        $assertionsDisabled = !SeriesHeader.class.desiredAssertionStatus();
    }

    public static class Multiplicity {
        public static Multiplicity SINGLE = new Multiplicity("Single-valued");
        public static Multiplicity MULTI = new Multiplicity("Multi-valued");
        public static Multiplicity SEQUENCE = new Multiplicity("Sequence");
        private String mName;

        private Multiplicity(String string) {
            this.mName = string;
        }

        public String toString() {
            return this.mName;
        }
    }
}

