/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.State;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SeriesReplyMessage
extends Message {
    private int mNumberOfCodestreams = 0;
    private int[] mNumberOfTiles = null;

    public SeriesReplyMessage() {
    }

    public SeriesReplyMessage(int n2, int[] nArray) {
        this.setNumberOfCodestreams(n2);
        this.setNumberOfTiles(nArray);
    }

    public int getNumberOfCodestreams() {
        return this.mNumberOfCodestreams;
    }

    public void setNumberOfCodestreams(int n2) {
        this.mNumberOfCodestreams = n2;
    }

    public int[] getNumberOfTiles() {
        return this.mNumberOfTiles;
    }

    public void setNumberOfTiles(int[] nArray) {
        this.mNumberOfTiles = nArray;
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        int n2 = dataInputStream.readInt();
        this.setNumberOfCodestreams(n2);
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = dataInputStream.readInt();
        }
        this.setNumberOfTiles(nArray);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        int n2 = this.getNumberOfCodestreams();
        dataOutputStream.writeInt(n2);
        int[] nArray = this.getNumberOfTiles();
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutputStream.writeInt(nArray[i2]);
        }
    }

    public int getLength() {
        return 4 * (1 + this.getNumberOfCodestreams());
    }

    public int getCode() {
        return 2;
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.ESTABLISHING_REQUEST);
    }
}

