/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

class VariableBlockInputStream
extends BufferedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public VariableBlockInputStream(DataInputStream dataInputStream) throws IOException {
        super(new BlockedInputStream(dataInputStream), 4096);
    }

    public static class BlockedInputStream
    extends FilterInputStream {
        private int mLeftToRead = 0;
        private boolean mEndOfInput = false;

        public BlockedInputStream(DataInputStream dataInputStream) {
            super(dataInputStream);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n2 = this.read(byArray, 0, byArray.length);
            if (n2 <= 0) {
                return -1;
            }
            return byArray[0];
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.mEndOfInput) {
                return -1;
            }
            DataInputStream dataInputStream = (DataInputStream)this.in;
            int n4 = 0;
            int n5 = n3;
            int n6 = n2;
            while (n5 > 0) {
                int n7;
                if (this.mLeftToRead <= 0) {
                    this.mLeftToRead = dataInputStream.readUnsignedShort();
                    if (this.mLeftToRead == 0) {
                        this.mEndOfInput = true;
                        return n4 > 0 ? n4 : -1;
                    }
                }
                if (n5 < (n7 = this.mLeftToRead)) {
                    n7 = n5;
                }
                dataInputStream.readFully(byArray, n6, n7);
                n4 += n7;
                this.mLeftToRead -= n7;
                n5 -= n7;
                n6 += n7;
            }
            return n4;
        }

        public void close() throws IOException {
            if (this.mEndOfInput) {
                return;
            }
            byte[] byArray = new byte[4096];
            while (this.read(byArray) >= 0) {
            }
        }
    }
}

