/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import DateUtilities.DateUtilities;
import J2cProtocol.DisplayShutter;
import J2cProtocol.ImageAcquisitionMatrix;
import J2cProtocol.J2cMissingValueException;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.SeriesHeader;
import J2cProtocol.SeriesHeaderParser.ImageNode;
import J2cProtocol.SeriesHeaderParser.PatientNode;
import J2cProtocol.SeriesHeaderParser.SeriesHeaderHandler;
import J2cProtocol.SeriesHeaderParser.SeriesNode;
import J2cProtocol.SeriesHeaderParser.SimpleTagNode;
import J2cProtocol.SeriesHeaderParser.StudyNode;
import J2cProtocol.XmlSeriesHeaderKeys;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import com.archimed.dicom.DDict;
import com.archimed.dicom.Person;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSeriesHeader
extends SeriesHeader
implements XmlSeriesHeaderKeys {
    private static final String SERIES_HEADER_PREFIX = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>\n\n<SERIESHEADER>\n";
    private static final String SERIES_HEADER_SUFFIX = "\n</SERIESHEADER>\n";
    private static final String EMPTY_SERIES_HEADER = "<SERIESHEADER></SERIESHEADER>";
    protected SimpleTagNode mInteleradNode = null;
    protected PatientNode mPatientNode = null;
    protected StudyNode mStudyNode = null;
    protected SeriesNode mSeriesNode = null;
    protected SimpleTagNode mAcquisitionNode = null;
    protected SimpleTagNode mCommonImageNode = null;
    protected ArrayList mImageNodeList = new ArrayList();

    public XmlSeriesHeader() throws J2cProtocolException {
        this(EMPTY_SERIES_HEADER);
    }

    public XmlSeriesHeader(InputSource inputSource) throws J2cProtocolException {
        try {
            SeriesHeaderHandler seriesHeaderHandler = new SeriesHeaderHandler(this);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)seriesHeaderHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new J2cProtocolException(parserConfigurationException.toString());
        }
        catch (SAXParseException sAXParseException) {
            throw new J2cProtocolException(sAXParseException.toString() + ": line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber());
        }
        catch (SAXException sAXException) {
            throw new J2cProtocolException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new J2cProtocolException(iOException.toString());
        }
    }

    public XmlSeriesHeader(String string) throws J2cProtocolException {
        this(new InputSource(new StringReader(string)));
    }

    public XmlSeriesHeader(File file) throws IOException, J2cProtocolException {
        this(XmlSeriesHeader.readSeriesHeader(file));
    }

    public Object getElementValue(int n2, int n3) {
        try {
            Object object = this.getElementValueMayThrow(n2, n3);
            if (object instanceof String && StringCheck.isStringBlank((String)object)) {
                return null;
            }
            return object;
        }
        catch (J2cMissingValueException j2cMissingValueException) {
            return null;
        }
    }

    private Object getElementValueMayThrow(int n2, int n3) throws J2cMissingValueException {
        switch (n3) {
            case 425: {
                return this.getStudyInstanceUid();
            }
            case 427: {
                return this.getStudyId();
            }
            case 64: {
                return XmlSeriesHeader.createDDate(this.getStudyDate());
            }
            case 70: {
                return this.getStudyTime();
            }
            case 95: {
                return this.getStudyDescription();
            }
            case 88: {
                return XmlSeriesHeader.createPerson(this.getStudyReferringPhysiciansName());
            }
            case 1419: {
                return this.getNodeValue(this.getStudyNode(), "PLACERORDERNUMBER");
            }
            case 426: {
                return this.getSeriesInstanceUid();
            }
            case 65: {
                return XmlSeriesHeader.createDDate(this.getSeriesDate());
            }
            case 71: {
                return this.getSeriesTime();
            }
            case 97: {
                return this.getSeriesDescription();
            }
            case 428: {
                return this.convertStringToInteger(this.getSeriesNumber());
            }
            case 81: {
                return this.getSeriesModality();
            }
            case 84: {
                return this.getNodeValue(this.getSeriesNode(), "MANUFACTURER");
            }
            case 85: {
                return this.getSeriesInstitutionName();
            }
            case 442: {
                return this.getFrameOfReferenceUid();
            }
            case 77: {
                return this.getStudyAccessionNumber();
            }
            case 429: {
                return this.convertStringToInteger(this.getImageAcquisitionNumber(n2));
            }
            case 66: {
                return XmlSeriesHeader.createDDate(this.getImageAcquisitionDate(n2));
            }
            case 72: {
                return this.getImageAcquisitionTime(n2);
            }
            case 147: {
                return XmlSeriesHeader.createPerson(this.getPatientName());
            }
            case 148: {
                return this.getPatientId();
            }
            case 150: {
                return XmlSeriesHeader.createDDate(this.getPatientBirthDate());
            }
            case 152: {
                return this.getPatientSex();
            }
            case 157: {
                return this.getPatientAge();
            }
            case 177: {
                return this.getNodeValue(this.getPatientNode(), "PATIENTCOMMENTS");
            }
            case 479: {
                return new Integer(this.getImagePixelMinimum(n2));
            }
            case 480: {
                return new Integer(this.getImagePixelMaximum(n2));
            }
            case 63: {
                return this.getImageSopInstanceUid(n2);
            }
            case 62: {
                return this.getImageSopClassUid(n2);
            }
            case 430: {
                return new Integer(this.getImageInstanceNumber(n2));
            }
            case 182: {
                return this.getNodeValue(this.getSeriesNode(), "BODYPARTEXAMINED");
            }
            case 380: {
                return this.getNodeValue(this.getSeriesNode(), "PATIENTPOSITION");
            }
            case 195: {
                return this.getNodeValue(this.getSeriesNode(), "RADIOPHARMACEUTICAL");
            }
            case 589: {
                String string = this.getRequestedProcedureId();
                if (StringCheck.isStringBlank(string)) {
                    return null;
                }
                return new Object[]{string};
            }
            case 582: {
                String string = this.getNodeValue(this.getStudyNode(), "SCHEDULEDPROCEDURESTEPID");
                if (StringCheck.isStringBlank(string)) {
                    return null;
                }
                return new Object[]{string};
            }
            case 1206: {
                return this.getNodeValue(this.getStudyNode(), "PERFORMEDPROCEDURESTEPID");
            }
            case 219: {
                return new Integer(this.getImageEchoNumber(n2));
            }
            case 464: {
                return new Integer(this.getImageNumberOfFrames(n2));
            }
            case 462: {
                return this.getImagePhotometricInterpretation(n2);
            }
            case 440: {
                return XmlSeriesHeader.doubleVectorToArray(this.getImagePosition(n2), 3);
            }
            case 441: {
                Vector vector = this.getImageRowVector(n2);
                Vector vector2 = this.getImageColumnVector(n2);
                if (vector == null || vector2 == null) {
                    return null;
                }
                vector.addAll(vector2);
                return XmlSeriesHeader.doubleVectorToArray(vector, 6);
            }
            case 436: {
                String string = this.getImagePatientOrientationRow(n2);
                String string2 = this.getImagePatientOrientationColumn(n2);
                if (StringCheck.isStringBlank(string) || StringCheck.isStringBlank(string2)) {
                    return null;
                }
                return new String[]{string, string2};
            }
            case 466: {
                return new Integer(this.getImageRows(n2));
            }
            case 467: {
                return new Integer(this.getImageColumns(n2));
            }
            case 478: {
                return new Integer(this.getImagePixelValueShift(n2) > 0 ? 1 : 0);
            }
            case 470: {
                return new Float[]{new Float(this.getImageColumnSpacing(n2)), new Float(this.getImageRowSpacing(n2))};
            }
            case 487: {
                return new Float(this.getImageWindowLevelCentre(n2));
            }
            case 488: {
                return new Float(this.getImageWindowLevelWidth(n2));
            }
            case 489: {
                return new Float(this.getImageRescaleIntercept(n2));
            }
            case 490: {
                return new Float(this.getImageRescaleSlope(n2));
            }
            case 214: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "ECHOTIME"));
            }
            case 215: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "INVERSIONTIME"));
            }
            case 332: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "FLIPANGLE"));
            }
            case 205: {
                return this.convertStringToDouble(this.getNodeValue(this.getImageNode(n2), "SLICETHICKNESS"));
            }
            case 221: {
                return this.convertStringToDouble(this.getNodeValue(this.getImageNode(n2), "SPACINGBETWEENSLICES"));
            }
            case 206: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "KVP"));
            }
            case 299: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "XRAYTUBECURRENT"));
            }
            case 298: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "EXPOSURETIME"));
            }
            case 300: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "EXPOSURE"));
            }
            case 280: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "GANTRYDETECTORTILT"));
            }
            case 224: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "ECHOTRAINLENGTH"));
            }
            case 330: {
                ImageAcquisitionMatrix imageAcquisitionMatrix = this.getImageAcquisitionMatrix(n2);
                return imageAcquisitionMatrix == null ? null : imageAcquisitionMatrix.getMatrix();
            }
            case 276: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "RECONSTRUCTIONDIAMETER"));
            }
            case 451: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "SLICELOCATION"));
            }
            case 179: {
                return this.getNodeValue(this.getImageNode(n2), "CONTRASTBOLUSAGENT");
            }
            case 459: {
                return this.getNodeValue(this.getImageNode(n2), "IMAGECOMMENTS");
            }
            case 213: {
                return this.convertStringToFloat(this.getNodeValue(this.getImageNode(n2), "REPETITIONTIME"));
            }
            case 473: {
                return XmlSeriesHeader.integerVectorToArray(this.getImagePixelAspectRatio(n2), 2);
            }
            case 320: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "ACTUALFRAMEDURATION"));
            }
            case 207: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "COUNTSACCUMULATED"));
            }
            case 321: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "COUNTRATE"));
            }
            case 154: {
                Vector vector = this.getPatientNode().getOtherPatientIds();
                if (vector == null) {
                    return null;
                }
                return vector.toArray();
            }
            case 159: {
                String string = this.getNodeValue(this.getPatientNode(), "PATIENTSWEIGHT");
                return StringCheck.isStringBlank(string) ? null : new Float(string);
            }
            case 1207: {
                return this.getNodeValue(this.getStudyNode(), "PERFORMEDPROCEDURESTEPDESCRIPTION");
            }
            case 102: {
                Vector vector = this.getSeriesNode().getOperatorsName();
                if (vector == null) {
                    return null;
                }
                Person[] personArray = new Person[vector.size()];
                for (int i2 = 0; i2 < personArray.length; ++i2) {
                    personArray[i2] = XmlSeriesHeader.createPerson((String)vector.get(i2));
                }
                return personArray;
            }
            case 239: {
                return this.getNodeValue(this.getSeriesNode(), "PROTOCOLNAME");
            }
            case 381: {
                return this.getNodeValue(this.getImageNode(n2), "VIEWPOSITION");
            }
            case 122: {
                return this.getNodeValue(this.getImageNode(n2), "DERIVATIONDESCRIPTION");
            }
            case 220: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "MAGNETICFIELDSTRENGTH")));
            }
            case 277: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "DISTANCESOURCETODETECTOR")));
            }
            case 278: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "DISTANCESOURCETOPATIENT")));
            }
            case 346: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "POSITIONERPRIMARYANGLE")));
            }
            case 347: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "POSITIONERSECONDARYANGLE")));
            }
            case 1308: {
                return this.getNodeValue(this.getImageNode(n2), "IMAGELATERALITY");
            }
            case 341: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "RELATIVEXRAYEXPOSURE"));
            }
            case 384: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "SENSITIVITY")));
            }
            case 323: {
                return this.getNodeValue(this.getImageNode(n2), "RECEIVECOILNAME");
            }
            case 185: {
                Vector vector = this.getImageNode(n2).getScanOptions();
                if (vector == null) {
                    return null;
                }
                return vector.toArray();
            }
            case 216: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "NUMBEROFAVERAGES")));
            }
            case 225: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "PERCENTSAMPLING")));
            }
            case 226: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "PERCENTPHASEFIELDOFVIEW")));
            }
            case 445: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "NUMBEROFTEMPORALPOSITIONS"));
            }
            case 444: {
                return this.convertStringToInteger(this.getNodeValue(this.getImageNode(n2), "TEMPORALPOSITIONIDENTIFIER"));
            }
            case 227: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "PIXELBANDWIDTH")));
            }
            case -1: {
                return this.getNodeValue(this.getSeriesNode(), "IMSSOURCEAETITLE");
            }
            case -2: {
                return this.getNodeValue(this.getSeriesNode(), "IMSINSTITUTIONCODE");
            }
            case 173: {
                return this.getNodeValue(this.getPatientNode(), "ADDITIONALHISTORY");
            }
            case 101: {
                return this.getNamesOfPhysiciansReadingStudy();
            }
            case 443: {
                return this.getNodeValue(this.getSeriesNode(), "SERIESLATERALITY");
            }
            case 450: {
                return this.getNodeValue(this.getSeriesNode(), "POSITIONREFERENCEINDICATOR");
            }
            case 1263: {
                return this.getNodeValue(this.getImageNode(n2), "ANODETARGETMATERIAL");
            }
            case 1264: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "BODYPARTTHICKNESS")));
            }
            case 1265: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "COMPRESSIONFORCE")));
            }
            case 1301: {
                return this.getFilterMaterials(n2);
            }
            case 187: {
                return this.getNodeValue(this.getImageNode(n2), "SEQUENCENAME");
            }
            case 504: {
                return this.getNodeValue(this.getImageNode(n2), "LOSSYIMAGECOMPRESSION");
            }
            case 134: {
                return new Integer(XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "RECOMMENDEDDISPLAYFRAMERATE")));
            }
            case 204: {
                return new Integer(XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "CINERATE")));
            }
            case 229: {
                return this.getNodeValue(this.getImageNode(n2), "PLATEID");
            }
            case 254: {
                return new Double(XmlSeriesHeader.getDouble(this.getNodeValue(this.getImageNode(n2), "FRAMETIME")));
            }
            case 541: {
                return this.getNodeValue(this.getStudyNode(), "REQUESTINGSERVICE");
            }
            case 58: 
            case 308: 
            case 475: 
            case 476: 
            case 477: 
            case 1313: {
                return null;
            }
        }
        DebugManager.getDefault().printException("Unknown series header element: " + DDict.getDescription((int)n3), new Throwable());
        return null;
    }

    public Person[] getNamesOfPhysiciansReadingStudy() {
        Vector vector = this.getStudyNode().getNamesOfPhysiciansReadingStudy();
        if (vector == null) {
            return null;
        }
        Person[] personArray = new Person[vector.size()];
        for (int i2 = 0; i2 < personArray.length; ++i2) {
            personArray[i2] = XmlSeriesHeader.createPerson((String)vector.get(i2));
        }
        return personArray;
    }

    public String[] getFilterMaterials(int n2) {
        Vector vector = this.getImageNode(n2).getFilterMaterials();
        return vector == null ? null : vector.toArray(new String[vector.size()]);
    }

    public SimpleTagNode getInteleradNode() {
        if (this.mInteleradNode == null) {
            this.mInteleradNode = new SimpleTagNode();
        }
        return this.mInteleradNode;
    }

    public PatientNode getPatientNode() {
        if (this.mPatientNode == null) {
            this.mPatientNode = new PatientNode();
        }
        return this.mPatientNode;
    }

    public StudyNode getStudyNode() {
        if (this.mStudyNode == null) {
            this.mStudyNode = new StudyNode();
        }
        return this.mStudyNode;
    }

    public SeriesNode getSeriesNode() {
        if (this.mSeriesNode == null) {
            this.mSeriesNode = new SeriesNode();
        }
        return this.mSeriesNode;
    }

    private SimpleTagNode getAcquisitionNode(int n2) {
        SimpleTagNode simpleTagNode = this.getImageNode(n2).getAcquisitionNode();
        return simpleTagNode != null ? simpleTagNode : new SimpleTagNode();
    }

    public SimpleTagNode getAcquisitionNode() {
        if (this.mAcquisitionNode == null) {
            this.mAcquisitionNode = new SimpleTagNode();
        }
        return this.mAcquisitionNode;
    }

    public SimpleTagNode getCommonImageNode() {
        if (this.mCommonImageNode == null) {
            this.mCommonImageNode = new SimpleTagNode();
        }
        return this.mCommonImageNode;
    }

    public ImageNode addImageNode() {
        ImageNode imageNode = new ImageNode();
        this.mImageNodeList.add(imageNode);
        return imageNode;
    }

    public ImageNode getImageNode(int n2) {
        return (ImageNode)this.mImageNodeList.get(n2);
    }

    private String getNodeValue(SimpleTagNode simpleTagNode, String string) {
        String string2 = simpleTagNode.getSimpleTag(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private Vector getVector(String[] stringArray) {
        if (stringArray == null || stringArray[0] == null || stringArray[1] == null || stringArray[2] == null) {
            return null;
        }
        try {
            Vector<Double> vector = new Vector<Double>();
            vector.add(new Double(stringArray[0]));
            vector.add(new Double(stringArray[1]));
            vector.add(new Double(stringArray[2]));
            return vector;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int getInt(String string) throws J2cMissingValueException {
        if (string == null) {
            throw new J2cMissingValueException("Cannot parse a null string");
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new J2cMissingValueException(numberFormatException.toString());
        }
    }

    public static double getDouble(String string) throws J2cMissingValueException {
        if (string == null) {
            throw new J2cMissingValueException("Cannot parse a null string");
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new J2cMissingValueException(numberFormatException.toString());
        }
    }

    public static Vector getIntVector(Collection collection) throws J2cMissingValueException {
        if (collection == null) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            vector.add(new Integer(XmlSeriesHeader.getInt(string)));
        }
        return vector;
    }

    public String getInteleradHeaderVersion() {
        return this.getNodeValue(this.getInteleradNode(), "HEADERVERSION");
    }

    public String getInteleradCompanyName() {
        return this.getNodeValue(this.getInteleradNode(), "COMPANYNAME");
    }

    public String getInteleradPacsVersion() {
        return this.getNodeValue(this.getInteleradNode(), "PACSVERSION");
    }

    public String getInteleradApplicationVersion() {
        return this.getNodeValue(this.getInteleradNode(), "APPLICATIONVERSION");
    }

    public String getStudyInstanceUid() {
        return this.getNodeValue(this.getStudyNode(), "INSTANCEUID");
    }

    public String getStudyId() {
        return this.getNodeValue(this.getStudyNode(), "ID");
    }

    public String getStudyDate() {
        return this.getNodeValue(this.getStudyNode(), "DATE");
    }

    public String getStudyTime() {
        return this.getNodeValue(this.getStudyNode(), "TIME");
    }

    public String getStudyDescription() {
        return this.getNodeValue(this.getStudyNode(), "DESCRIPTION");
    }

    public String getStudyAccessionNumber() {
        return this.getNodeValue(this.getStudyNode(), "ACCESSIONNUMBER");
    }

    public String getStudyReferringPhysiciansName() {
        return this.getNodeValue(this.getStudyNode(), "REFERRINGPHYSICIANSNAME");
    }

    public String getRequestedProcedureId() {
        return this.getNodeValue(this.getStudyNode(), "REQUESTEDPROCEDUREID");
    }

    public String getSeriesInstanceUid() {
        return this.getNodeValue(this.getSeriesNode(), "INSTANCEUID");
    }

    public String getSeriesDate() {
        return this.getNodeValue(this.getSeriesNode(), "DATE");
    }

    public String getSeriesTime() {
        return this.getNodeValue(this.getSeriesNode(), "TIME");
    }

    public String getSeriesDescription() {
        return this.getNodeValue(this.getSeriesNode(), "DESCRIPTION");
    }

    public String getSeriesNumber() {
        return this.getNodeValue(this.getSeriesNode(), "NUMBER");
    }

    public String getSeriesModality() {
        return this.getNodeValue(this.getSeriesNode(), "MODALITY");
    }

    public String getSeriesInstitutionName() {
        return this.getNodeValue(this.getSeriesNode(), "INSTITUTIONNAME");
    }

    public String getFrameOfReferenceUid() {
        String string = this.getNodeValue(this.getSeriesNode(), "FRAMEOFREFERENCEUID");
        if (string.length() == 0 && this.getCommonImageNode() != null) {
            string = this.getNodeValue(this.getCommonImageNode(), "FRAMEOFREFERENCEUID");
        }
        return string;
    }

    public String getImageAcquisitionNumber(int n2) {
        return this.getNodeValue(this.getAcquisitionNode(n2), "NUMBER");
    }

    public String getImageAcquisitionDate(int n2) {
        return this.getNodeValue(this.getAcquisitionNode(n2), "DATE");
    }

    public String getImageAcquisitionTime(int n2) {
        return this.getNodeValue(this.getAcquisitionNode(n2), "TIME");
    }

    public String getPatientName() {
        return this.getNodeValue(this.getPatientNode(), "NAME");
    }

    public String getPatientId() {
        return this.getNodeValue(this.getPatientNode(), "ID");
    }

    public String getPatientBirthDate() {
        return this.getNodeValue(this.getPatientNode(), "BIRTHDATE");
    }

    public String getPatientSex() {
        return this.getNodeValue(this.getPatientNode(), "SEX");
    }

    public String getPatientAge() {
        if (StringCheck.isStringBlank(this.getPatientBirthDate()) || StringCheck.isStringBlank(this.getStudyDate())) {
            return this.getNodeValue(this.getPatientNode(), "AGE");
        }
        return DateUtilities.getDicomAge(this.getPatientBirthDate(), this.getStudyDate());
    }

    public int getNumberOfImages() {
        return this.mImageNodeList.size();
    }

    public int getImagePixelMinimum(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "PIXELMINIMUM"));
    }

    private Vector getImagePosition(int n2) {
        return this.getVector(this.getImageNode(n2).getPosition());
    }

    public int getImagePixelMaximum(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "PIXELMAXIMUM"));
    }

    public int getImagePixelValueShift(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "PIXELVALUESHIFT"));
    }

    public String getImageSopInstanceUid(int n2) {
        return this.getNodeValue(this.getImageNode(n2), "INSTANCEUID");
    }

    public String getImageSopClassUid(int n2) {
        return this.getNodeValue(this.getImageNode(n2), "SOPCLASSUID");
    }

    public String getImageJ2cFileName(int n2) {
        return this.getNodeValue(this.getImageNode(n2), "J2CFILENAME");
    }

    public int getImageInstanceNumber(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "INSTANCENUMBER"));
    }

    public int getImageEchoNumber(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "ECHONUMBER"));
    }

    public int getImageFrameNumber(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "FRAMENUMBER"));
    }

    public int getImageNumberOfFrames(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "NUMBEROFFRAMES"));
    }

    public String getImagePhotometricInterpretation(int n2) {
        String string = this.getNodeValue(this.getImageNode(n2), "PHOTOMETRICINTERPRETATION");
        if (string.length() == 0 && this.getCommonImageNode() != null) {
            string = this.getNodeValue(this.getCommonImageNode(), "PHOTOMETRICINTERPRETATION");
        }
        return string;
    }

    private Vector getImageRowVector(int n2) {
        return this.getVector(this.getImageNode(n2).getRowVector());
    }

    private Vector getImageColumnVector(int n2) {
        return this.getVector(this.getImageNode(n2).getColumnVector());
    }

    private String getImagePatientOrientationRow(int n2) {
        String string = this.getImageNode(n2).getPatientOrientationRow();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String getImagePatientOrientationColumn(int n2) {
        String string = this.getImageNode(n2).getPatientOrientationColumn();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int getImageRows(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "ROWS"));
    }

    public int getImageColumns(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getNodeValue(this.getImageNode(n2), "COLUMNS"));
    }

    private double getImageRowSpacing(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getRowSpacing());
    }

    private double getImageColumnSpacing(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getColumnSpacing());
    }

    public double getImagePercentile(int n2, String string) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getPercentile(string));
    }

    public boolean hasImagePercentile(int n2, String string) {
        return this.getImageNode(n2).getPercentile(string) != null;
    }

    public double getImageWindowLevelCentre(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getWindowLevelCentre());
    }

    public double getImageWindowLevelWidth(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getWindowLevelWidth());
    }

    public double getImageRescaleIntercept(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getRescaleIntercept());
    }

    public double getImageRescaleSlope(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getDouble(this.getImageNode(n2).getRescaleSlope());
    }

    public ImageAcquisitionMatrix getImageAcquisitionMatrix(int n2) {
        return this.getImageNode(n2).getAcquisitionMatrix();
    }

    private final Vector getImagePixelAspectRatio(int n2) {
        try {
            Vector<Integer> vector = new Vector<Integer>(2);
            vector.add(new Integer(this.getImagePixelAspectRatioVertical(n2)));
            vector.add(new Integer(this.getImagePixelAspectRatioHorizontal(n2)));
            return vector;
        }
        catch (J2cMissingValueException j2cMissingValueException) {
            return null;
        }
    }

    private int getImagePixelAspectRatioVertical(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getImageNode(n2).getPixelAspectRatioVertical());
    }

    private int getImagePixelAspectRatioHorizontal(int n2) throws J2cMissingValueException {
        return XmlSeriesHeader.getInt(this.getImageNode(n2).getPixelAspectRatioHorizontal());
    }

    public DisplayShutter getImageDisplayShutter(int n2) {
        return this.getImageNode(n2).getImageShutter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSeriesHeader(File file) throws IOException {
        byte[] byArray = SERIES_HEADER_PREFIX.getBytes();
        byte[] byArray2 = SERIES_HEADER_SUFFIX.getBytes();
        int n2 = (int)file.length();
        int n3 = byArray.length + byArray2.length + n2;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n4 = fileInputStream.read(byArray3, byArray.length, n2);
            if (n4 != n2) {
                throw new IOException("Error reading series header: got " + n4 + " bytes, expected " + n2);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        System.arraycopy(byArray2, 0, byArray3, byArray.length + n2, byArray2.length);
        return new String(byArray3);
    }
}

