/*
 * Decompiled with CFR 0.152.
 */
package NetLibrary;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class LocalHost {
    public static String getAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)("Error getting IP address of local host: " + unknownHostException));
        }
    }

    public static String getLongName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)("Error getting long name of local host: " + unknownHostException));
        }
    }

    public static String getShortName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                return string;
            }
            return string.substring(0, n2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)("Error getting short name of local host: " + unknownHostException));
        }
    }

    private static void println(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        LocalHost.println("IP address: " + LocalHost.getAddress());
        LocalHost.println("long name : " + LocalHost.getLongName());
        LocalHost.println("short name: " + LocalHost.getShortName());
    }
}

