/*
 * Decompiled with CFR 0.152.
 */
package Notification;

import DataStructures.WorkQueue;
import NetLibrary.LocalHost;
import Notification.LocalNotificationSender;
import Notification.Notification;
import Notification.NotificationSender;
import Notification.NotificationSeverity;
import Notification.NotificationType;
import Notification.NullNotificationSender;
import Notification.RemoteNotificationSender;
import Notification.RemoteNotificationWorker;
import Notification.TracerNotification;
import Notification.TransferMode;
import java.net.URL;
import java.util.Hashtable;

public class Notifier {
    static final String UNKNOWN_APPLICATION_VERSION = "UNKNOWN_APPLICATION_VERSION";
    static final String UNKNOWN_PACS_VERSION = "UNKNOWN_PACS_VERSION";
    private static final int NOTIFICATION_QUEUE_SIZE = 10;
    private static Notifier mInstance = null;
    private Hashtable mUniqueKeys = new Hashtable();
    private String mSubsystem;
    private String mPacsVersion;
    private String mAppVersion;
    private String mHostname;
    private NotificationSender mSender;

    public static synchronized Notifier getInstance(String string, String string2, String string3) {
        if (mInstance == null) {
            mInstance = Notifier.createLocalNotifier(string, string2, string3);
        }
        return mInstance;
    }

    public static synchronized Notifier getInstance() {
        return Notifier.getInstance("UNKNOWN_SUBSYSTEM", UNKNOWN_PACS_VERSION, UNKNOWN_APPLICATION_VERSION);
    }

    static Notifier createLocalNotifier(String string, String string2, String string3) {
        Notifier notifier = new Notifier(LocalHost.getLongName(), string, string2, string3);
        notifier.setNotificationSender(new LocalNotificationSender());
        return notifier;
    }

    public static Notifier createRemoteNotifier(String string, String string2, String string3, URL uRL) {
        Notifier notifier = new Notifier("localhost", string, string2, string3);
        WorkQueue workQueue = new WorkQueue(10);
        RemoteNotificationWorker remoteNotificationWorker = new RemoteNotificationWorker(uRL, workQueue);
        RemoteNotificationSender remoteNotificationSender = new RemoteNotificationSender(workQueue);
        notifier.setNotificationSender(remoteNotificationSender);
        remoteNotificationWorker.start();
        return notifier;
    }

    public static Notifier createNotifier(String string, String string2, String string3, NotificationSender notificationSender) {
        Notifier notifier = new Notifier(LocalHost.getLongName(), string, string2, string3);
        notifier.setNotificationSender(notificationSender);
        return notifier;
    }

    public static Notifier createNullNotifier() {
        Notifier notifier = new Notifier(null, null, null, null);
        notifier.setNotificationSender(new NullNotificationSender());
        return notifier;
    }

    Notifier(String string, String string2, String string3, String string4) {
        this.mHostname = string;
        this.mSubsystem = string2;
        this.mPacsVersion = string3;
        this.mAppVersion = string4;
    }

    public Notifier() {
    }

    public void close() {
        this.mSender.close();
    }

    void setNotificationSender(NotificationSender notificationSender) {
        this.mSender = notificationSender;
    }

    String getSubsystem() {
        return this.mSubsystem;
    }

    String getAppVersion() {
        return this.mAppVersion;
    }

    String getPacsVersion() {
        return this.mPacsVersion;
    }

    String getHostname() {
        return this.mHostname;
    }

    void setHostname(String string) {
        this.mHostname = string;
    }

    public void registerShutdown() {
        Thread thread = new Thread(){

            public void run() {
                Notifier.this.notifyMessage("Application exiting.", NotificationType.INFORMATION, "DEFAULT_NOTIFICATION_ID");
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public void notifyMessage(String string, NotificationType notificationType, String string2) {
        this.notify(NotificationSeverity.MESSAGE, string, notificationType, string2);
    }

    public void notifyMinor(String string, NotificationType notificationType, String string2) {
        this.notify(NotificationSeverity.MINOR, string, notificationType, string2);
    }

    public void notifyMajor(String string, NotificationType notificationType, String string2) {
        this.notify(NotificationSeverity.MAJOR, string, notificationType, string2);
    }

    public void notifyCritical(String string, NotificationType notificationType, String string2) {
        this.notify(NotificationSeverity.CRITICAL, string, notificationType, string2);
    }

    public void notifyMessageOnlyOnce(String string, String string2, NotificationType notificationType, String string3) {
        this.notifyOnlyOnce(NotificationSeverity.MESSAGE, string, string2, notificationType, string3);
    }

    public void notifyMinorOnlyOnce(String string, String string2, NotificationType notificationType, String string3) {
        this.notifyOnlyOnce(NotificationSeverity.MINOR, string, string2, notificationType, string3);
    }

    public void notifyMajorOnlyOnce(String string, String string2, NotificationType notificationType, String string3) {
        this.notifyOnlyOnce(NotificationSeverity.MAJOR, string, string2, notificationType, string3);
    }

    public void notifyCriticalOnlyOnce(String string, String string2, NotificationType notificationType, String string3) {
        this.notifyOnlyOnce(NotificationSeverity.CRITICAL, string, string2, notificationType, string3);
    }

    public void notifyTracer(String string, boolean bl2, String string2, String string3, String string4, String string5, String string6) {
        this.notify(new TracerNotification(this, this.mSubsystem, string, string6, bl2, string2, string3, string4, string5));
    }

    public void notifyStatistics(String string, boolean bl2, String string2, String string3, String string4, String string5, float f2, String string6) {
    }

    public void notifyApplicationData(String string, String string2) {
        Notification notification = new Notification(this, this.mSubsystem, NotificationSeverity.APPLICATION_DATA, string, NotificationType.APPLICATION_DATA, string2, TransferMode.PROTECTED);
        this.mSender.send(notification);
    }

    public void notify(NotificationSeverity notificationSeverity, String string, NotificationType notificationType, String string2) {
        this.mSender.send(this.createNotification(notificationSeverity, string, notificationType, string2));
    }

    public void notify(Notification notification) {
        this.mSender.send(notification);
    }

    public Notification createNotification(NotificationSeverity notificationSeverity, String string, NotificationType notificationType, String string2) {
        return new Notification(this, this.mSubsystem, notificationSeverity, string, notificationType, string2, TransferMode.NORMAL);
    }

    public synchronized void notifyOnlyOnce(NotificationSeverity notificationSeverity, String string, String string2, NotificationType notificationType, String string3) {
        if (this.mUniqueKeys.containsKey(string)) {
            return;
        }
        this.mUniqueKeys.put(string, new Integer(1));
        this.notify(notificationSeverity, this.getUniqueDescription(string2, string), notificationType, string3);
    }

    private String getUniqueDescription(String string, String string2) {
        String string3 = " ";
        if (string.endsWith("\n")) {
            string3 = "";
        }
        return "[UNIQUE] " + string + string3 + "[key: " + string2 + "]";
    }

    public static String getMessage(String string, String string2, Throwable throwable) {
        return string + "\n" + Notifier.getContext(string2, throwable);
    }

    public static String getContext(String string, Throwable throwable) {
        return "(user:" + string + ") " + throwable.getMessage() + "\n" + Notifier.getContext(throwable);
    }

    public static String getContext(Throwable throwable) {
        int n2;
        String string;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length == 0) {
            return "(no stack trace)\n";
        }
        for (n3 = 0; n3 < Math.min(3, stackTraceElementArray.length); ++n3) {
            stringBuffer.append(stackTraceElementArray[n3]).append('\n');
        }
        if (stackTraceElementArray[0].isNativeMethod()) {
            stringBuffer.append(stackTraceElementArray[n3++]).append('\n');
        }
        int n4 = 0;
        while (n3 < stackTraceElementArray.length - 1 && ((string = stackTraceElementArray[n3].getClassName()).startsWith("java.") || string.startsWith("javax.") || string.startsWith("com.sun.") || string.startsWith("sun."))) {
            ++n4;
            ++n3;
        }
        int n5 = 7;
        if (n4 > 2) {
            stringBuffer.append("[... skipped " + n4 + " stack frames of java/sun code ...]\n");
        } else {
            n3 -= n4;
            n5 += n4;
        }
        for (n2 = 0; n3 < stackTraceElementArray.length && n2 < n5; ++n3, ++n2) {
            stringBuffer.append(stackTraceElementArray[n3]).append("\n");
        }
        n2 = stackTraceElementArray.length - n3;
        if (n2 > 0) {
            stringBuffer.append("[... skipped " + n2 + " remaining stack frames ...]\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing...!");
        Notifier notifier = Notifier.getInstance("TEST_JAVA", "PACS-3-4-1-P107", "NOTIFIER-VER-3-3-6-P1-B1");
        notifier.registerShutdown();
        notifier.notifyMessage("Description; This is a long hints message.\n\tPlease be sure to follow <<here>> these steps:\n\t1. Here\n\t2. There", NotificationType.SECURITY, "DEFAULT_NOTIFICATION_ID");
        Notifier.getInstance("JJ", "PACS-3-4-1-P107", "NOTIFIER-VER-3-3-6-P1-B1").notifyMajor("New Description for Major", NotificationType.INFORMATION, "NOTIFIER_TEST_1");
        Notifier.getInstance("KK", "PACS-3-4-1-P107", "NOTIFIER-VER-3-3-6-P1-B1").notifyMajor("Another Description for Major", NotificationType.INFORMATION, "NOTIFIER_TEST_1");
        notifier.notifyMessage("New notification system without hints", NotificationType.SECURITY, "NOTIFIER_TEST_1");
        notifier.notifyTracer("deleted study", true, "1.2.3.4.5.66666.7777", "SerInsUID", "devmod1", "devmod2", "NOTIFIER_TEST_2");
        notifier.notifyMessageOnlyOnce("UNIQUE_KEY_AE_TITLE", "This is the only one that will show up", NotificationType.SECURITY, "NOTIFIER_TEST_1");
        notifier.notifyMinorOnlyOnce("UNIQUE_KEY_AE_TITLE", "2222 This won't show since it's been reported already", NotificationType.SECURITY, "NOTIFIER_TEST_1");
        notifier.notifyMajorOnlyOnce("UNIQUE_KEY_AE_TITLE", "3333 This won't show since it's been reported already", NotificationType.SECURITY, "NOTIFIER_TEST_1");
        notifier.notifyMessageOnlyOnce("UNIQUE_KEY_AE_TITLE", "4444 This won't show since it's been reported already", NotificationType.SECURITY, "NOTIFIER_TEST_1");
        notifier.notifyMessage("Hello this is a test with no hints and prepend PREPEND", NotificationType.SECURITY, "NOTIFIER_TEST_1");
        notifier.notifyMessage("Hello this is another test with no hints and prepend PREPEND", NotificationType.SECURITY, "NOTIFIER_TEST_1");
    }
}

