/*
 * Decompiled with CFR 0.152.
 */
package Notification;

import DataStructures.WorkQueue;
import HttpUtilities.HttpClient;
import HttpUtilities.UriBuilder;
import Notification.Notification;
import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

class RemoteNotificationWorker
extends Thread {
    private static final String SERVLET_PATH = "/Notification/Notification.NotifierServlet";
    private static volatile int mThreadCount = 0;
    private URL mUrl;
    private WorkQueue mQueue;

    public RemoteNotificationWorker(URL uRL, WorkQueue workQueue) {
        super("RemoteNotifier-" + mThreadCount++ + ":" + uRL);
        this.setDaemon(true);
        String string = uRL.getProtocol();
        if (!"http".equals(string) && !"https".equals(string)) {
            throw new IllegalArgumentException("invalid URL: must be http or https: " + uRL);
        }
        try {
            this.mUrl = new URL(uRL, SERVLET_PATH);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException.toString());
        }
        this.mQueue = workQueue;
    }

    public void run() {
        Object object;
        while ((object = this.mQueue.getWork()) != WorkQueue.SHUTDOWN_CONSUMER) {
            try {
                this.postNotificationHttp((Notification)object);
            }
            catch (Exception exception) {
                DebugManager.getDefault().printException("Error sending notification to " + this.mUrl, exception);
            }
        }
    }

    private void postNotificationHttp(Notification notification) {
        UriBuilder uriBuilder = new UriBuilder();
        uriBuilder.addParameter("description", notification.getDescription());
        uriBuilder.addParameter("subsystem", notification.getSubsystem());
        uriBuilder.addParameter("severity", notification.getSeverity().getName());
        uriBuilder.addParameter("type", notification.getNotificationType().getName());
        uriBuilder.addParameter("notificationid", notification.getNotificationId());
        uriBuilder.addParameter("identifier", notification.getSubsystem());
        uriBuilder.addParameter("pacsversion", notification.getPacsVersion());
        uriBuilder.addParameter("applicationversion", notification.getAppVersion());
        this.postHttp(uriBuilder);
    }

    private void postHttp(UriBuilder uriBuilder) {
        Debug debug = DebugManager.getDefault();
        String string = uriBuilder.getQuery();
        try {
            String string2 = HttpClient.sendPostRequest(this.mUrl, string);
            if (string2.equals("OK")) {
                debug.printTrace("Notification successfully sent");
            } else {
                debug.printWarning("Notification failed: server response = " + string2);
            }
        }
        catch (IOException iOException) {
            debug.printException("Error sending remote notification to " + this.mUrl, iOException);
        }
    }
}

