/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class BasicData {
    private static final SimpleDateFormat DATE_TIME_FORMAT_NO_SECONDS = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final SimpleDateFormat DATE_TIME_FORMAT_WITH_SECONDS = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected Hashtable mData = new Hashtable();

    public Object getValue(String string) {
        return this.mData.get(string);
    }

    public Hashtable getData() {
        return this.mData;
    }

    public abstract String getUidKey();

    protected void checkMap(Map map, Map map2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            Object v2 = map.get(k2);
            if (!map2.containsKey(k2)) {
                throw new IllegalArgumentException("invalid series key: " + k2);
            }
            Class clazz = (Class)map2.get(k2);
            if (clazz.isInstance(v2)) continue;
            throw new IllegalArgumentException("invalid value for key " + k2 + ": " + v2 + ": " + "must be instance of " + clazz);
        }
    }

    public static synchronized Date parseDateTime(String string) throws ParseException {
        try {
            return DATE_TIME_FORMAT_WITH_SECONDS.parse(string);
        }
        catch (ParseException parseException) {
            return DATE_TIME_FORMAT_NO_SECONDS.parse(string);
        }
    }

    public static synchronized String formatDateTime(Date date) {
        return DATE_TIME_FORMAT_WITH_SECONDS.format(date);
    }
}

