/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Data;

import PatientSearchLibrary.Data.BasicData;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.Predicate;

public class Study
extends BasicData {
    private static Map mAllowedKeys = new IdentityHashMap();
    private Map mSeriesMap = new LinkedHashMap();

    public Study(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        String string8 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        this.mData.put("PatID", string2);
        this.mData.put("StuInsUID", string3);
        this.mData.put("Ser%", string4);
        this.mData.put("PName", string5);
        this.mData.put("AccNum", string6);
        this.mData.put("StuDate", string7);
        this.mData.put("Mod", string8);
        this.mData.put("StuDes", string9);
        this.mData.put("Status", Status.UNKNOWN);
    }

    public Study(Map map) {
        this.checkMap(map, mAllowedKeys);
        this.mData.putAll(map);
    }

    public void setDate(Date date) {
        this.mData.put("StuDate", BasicData.formatDateTime(date));
    }

    public void addSeries(Series series) {
        this.mSeriesMap.put(series.getValue("SerInsUID"), series);
    }

    public List getSeriesList() {
        return new ArrayList(this.mSeriesMap.values());
    }

    public Map getSeriesMap() {
        return this.mSeriesMap;
    }

    public Series getSeries(String string) {
        return (Series)this.mSeriesMap.get(string);
    }

    public Set getSeriesUids() {
        return new HashSet(this.mSeriesMap.keySet());
    }

    public void sortSeries(Comparator comparator) {
        Object[] objectArray = this.mSeriesMap.values().toArray();
        Arrays.sort(objectArray, comparator);
        this.mSeriesMap.clear();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Series series = (Series)objectArray[i2];
            this.mSeriesMap.put(series.getValue("SerInsUID"), series);
        }
    }

    public synchronized void updateStatus() {
        Object object;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        Iterator iterator = this.mSeriesMap.values().iterator();
        while (iterator.hasNext()) {
            object = (Series)iterator.next();
            Status status = ((Series)object).getStatus();
            if (Status.OFFLINE == status) {
                bl3 = false;
                bl4 = false;
                continue;
            }
            if (Status.ONLINE == status) {
                bl4 = false;
                continue;
            }
            if (Status.UNAVAILABLE == status) {
                bl3 = false;
                continue;
            }
            if (Status.UNKNOWN != status) continue;
            bl2 = true;
            break;
        }
        object = bl2 ? Status.UNKNOWN : (bl3 ? Status.ONLINE : (bl4 ? Status.UNAVAILABLE : Status.OFFLINE));
        this.mData.put("Status", object);
    }

    public String getUidKey() {
        return "StuInsUID";
    }

    public String getPatientId() {
        return (String)this.getValue("PatID");
    }

    public String getStudyUid() {
        return (String)this.getValue("StuInsUID");
    }

    public String getPatientName() {
        return (String)this.getValue("PName");
    }

    public Status getStatus() {
        return (Status)this.getValue("Status");
    }

    public boolean equals(Object object) {
        if (!(object instanceof Study)) {
            return false;
        }
        return this.getStudyUid().equals(((Study)object).getStudyUid());
    }

    public int hashCode() {
        return this.getStudyUid().hashCode();
    }

    public static void updateStudyStatus(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            study.updateStatus();
        }
    }

    public static List getSeries(Collection collection, List list) {
        Map map = Study.getSeriesMap(collection);
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(map.get(string));
        }
        return arrayList;
    }

    public static Map getSeriesMap(Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            hashMap.putAll(study.getSeriesMap());
        }
        return hashMap;
    }

    public boolean removeSeries(Predicate predicate) {
        Iterator iterator = this.mSeriesMap.values().iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            if (!predicate.evaluate((Object)series)) continue;
            iterator.remove();
        }
        int n2 = this.mSeriesMap.size();
        this.mData.put("Ser%", Integer.toString(n2));
        return n2 > 0;
    }

    static {
        mAllowedKeys.put("PatID", String.class);
        mAllowedKeys.put("StuInsUID", String.class);
        mAllowedKeys.put("Ser%", String.class);
        mAllowedKeys.put("PName", String.class);
        mAllowedKeys.put("AccNum", String.class);
        mAllowedKeys.put("StuDate", String.class);
        mAllowedKeys.put("Mod", String.class);
        mAllowedKeys.put("StuDes", String.class);
        mAllowedKeys.put("Status", Status.class);
    }

    public static class Key {
        public static final String PATIENT_ID = "PatID";
        public static final String STUDY_INSTANCE_UID = "StuInsUID";
        public static final String NUMBER_OF_SERIES = "Ser%";
        public static final String DISPLAYED_PATIENT_NAME = "PName";
        public static final String ACCESSION_NUMBER = "AccNum";
        public static final String STUDY_DATE_TIME = "StuDate";
        public static final String MODALITIES_IN_STUDY = "Mod";
        public static final String STUDY_DESCRIPTION = "StuDes";
        public static final String STATUS = "Status";
    }
}

