/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Layouts.ParagraphLayout;
import GuiUtilities.Util.CalendarPicker;
import GuiUtilities.Util.GuiUtilities;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchPane;
import PatientSearchLibrary.Gui.SearchView;
import PatientSearchLibrary.Search.SearchSpecification;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class AdvancedSearchView
extends SearchView
implements ActionListener {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    protected JButton mCalendarFromButton;
    protected JButton mCalendarToButton;
    protected JLabel mFromLabel;
    protected JLabel mToLabel;
    protected JFormattedTextField mFromTextField;
    protected JFormattedTextField mToTextField;
    protected JLabel mFormatLabel;
    protected static LinkedHashMap mAdvancedDateFilterOptions = new LinkedHashMap();

    public AdvancedSearchView(JFrame jFrame, PatientSearchPane patientSearchPane) {
        super(jFrame, patientSearchPane);
        this.mDateFilterComboBox.addActionListener(this);
    }

    protected void initUsedSearchFields() {
        this.mUsedSearchFields.addAll(this.getAvailableSearchFields());
    }

    protected boolean isComparatorUsed() {
        return true;
    }

    protected void createDateFilterPanel() {
        Serializable serializable;
        this.mDateFilterPanel = new JPanel();
        this.mDateFilterPanel.setLayout(new ParagraphLayout());
        if (this.mSiteConfig.isDicomSearchAvailable()) {
            serializable = new JLabel("     ");
            this.mSearchExternalPacs = new JCheckBox("Search " + this.mSiteConfig.getDicomSourceName());
            this.mDateFilterPanel.add((Component)serializable, ParagraphLayout.NEW_PARAGRAPH);
            this.mDateFilterPanel.add(this.mSearchExternalPacs);
        }
        if (this.mPatientSearchPane.getSession().useSiteCodes()) {
            this.mSiteFilterLabel = new JLabel("Site :");
            serializable = new Vector();
            ((Vector)serializable).addAll(this.mPatientSearchPane.getSession().getSiteCodes());
            ((Vector)serializable).add(0, "All");
            this.mSiteFilterComboBox = new JComboBox(serializable);
            this.mDateFilterPanel.add((Component)this.mSiteFilterLabel, ParagraphLayout.NEW_PARAGRAPH);
            this.mDateFilterPanel.add(this.mSiteFilterComboBox);
        }
        this.mDateFilterLabel = new JLabel("Date :");
        this.mDateFilterComboBox = new JComboBox<String>(mAdvancedDateFilterOptions.keySet().toArray(new String[0]));
        this.mDateFilterPanel.add((Component)this.mDateFilterLabel, ParagraphLayout.NEW_PARAGRAPH);
        this.mDateFilterPanel.add(this.mDateFilterComboBox);
        this.add(this.mDateFilterPanel);
        this.mFromLabel = new JLabel("From :");
        this.mCalendarFromButton = new JButton(GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/date_small.png", 12, 12));
        this.mFromTextField = new JFormattedTextField(DATE_FORMAT);
        this.mFromTextField.setValue(new Date());
        this.mFromTextField.setPreferredSize(new Dimension(81, 20));
        this.mFromTextField.addKeyListener(new DateFieldChangeListener());
        this.mCalendarFromButton.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(2, 2, 2, 2)));
        this.mCalendarFromButton.addActionListener(this);
        this.mCalendarFromButton.setCursor(new Cursor(12));
        this.mToLabel = new JLabel("To :");
        this.mCalendarToButton = new JButton(GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/date_small.png", 12, 12));
        this.mToTextField = new JFormattedTextField(DATE_FORMAT);
        this.mToTextField.setValue(new Date());
        this.mToTextField.setPreferredSize(new Dimension(81, 20));
        this.mToTextField.addKeyListener(new DateFieldChangeListener());
        this.mCalendarToButton.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(2, 2, 2, 2)));
        this.mCalendarToButton.addActionListener(this);
        this.mCalendarToButton.setCursor(new Cursor(12));
        this.mFormatLabel = new JLabel("YYYYMMDD");
        this.mFormatLabel.setFont(new Font("Helvetica", 2, 12));
        this.mDateFilterPanel.add((Component)this.mFromLabel, ParagraphLayout.NEW_PARAGRAPH);
        this.mDateFilterPanel.add(this.mFromTextField);
        this.mDateFilterPanel.add(this.mCalendarFromButton);
        this.mDateFilterPanel.add((Component)this.mToLabel, ParagraphLayout.NEW_PARAGRAPH);
        this.mDateFilterPanel.add(this.mToTextField);
        this.mDateFilterPanel.add(this.mCalendarToButton);
        this.mDateFilterPanel.add((Component)this.mFormatLabel, ParagraphLayout.NEW_LINE);
        this.updateFromToDateFilters();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mDateFilterComboBox) {
            this.updateFromToDateFilters();
        }
        if (actionEvent.getSource() == this.mCalendarFromButton) {
            this.updateDateField(this.mCalendarFromButton, this.mFromTextField);
        }
        if (actionEvent.getSource() == this.mCalendarToButton) {
            this.updateDateField(this.mCalendarToButton, this.mToTextField);
        }
    }

    private Date getDate(String string) {
        if (StringCheck.isStringBlank(string)) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            DebugManager.getDefault().printException("unexpected exception", parseException);
            return null;
        }
    }

    private void updateDateField(JButton jButton, JFormattedTextField jFormattedTextField) {
        String string = jFormattedTextField.getText();
        Date date = this.getDate(jFormattedTextField.getText());
        if (date == null) {
            date = new Date();
        }
        CalendarPicker calendarPicker = new CalendarPicker((Frame)this.mFrame, jFormattedTextField, date);
        Point point = jButton.getLocation();
        SwingUtilities.convertPointToScreen(point, jButton);
        calendarPicker.setLocation(new Point((int)point.getX() - 100, (int)point.getY() - 125));
        calendarPicker.setVisible(true);
        String string2 = jFormattedTextField.getText();
        if (!string.equals(string2)) {
            this.changeToCustomDate();
        }
    }

    private void updateFromToDateFilters() {
        int n2 = this.getDateFilterCode(this.mDateFilterComboBox.getSelectedItem());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        switch (n2) {
            case -1: {
                this.mFromTextField.setValue(null);
                this.mToTextField.setValue(gregorianCalendar2.getTime());
                break;
            }
            case 0: {
                this.mFromTextField.setValue(gregorianCalendar.getTime());
                this.mToTextField.setValue(gregorianCalendar2.getTime());
                break;
            }
            case 1: {
                gregorianCalendar.add(6, -1);
                this.mFromTextField.setValue(gregorianCalendar.getTime());
                gregorianCalendar2.add(6, -1);
                this.mToTextField.setValue(gregorianCalendar2.getTime());
                break;
            }
            case 2: {
                gregorianCalendar.add(6, -1);
                this.mFromTextField.setValue(gregorianCalendar.getTime());
                this.mToTextField.setValue(gregorianCalendar2.getTime());
                break;
            }
            case 7: {
                gregorianCalendar.add(6, -6);
                this.mFromTextField.setValue(gregorianCalendar.getTime());
                this.mToTextField.setValue(gregorianCalendar2.getTime());
                break;
            }
            case 31: {
                gregorianCalendar.add(6, -30);
                this.mFromTextField.setValue(gregorianCalendar.getTime());
                this.mToTextField.setValue(gregorianCalendar2.getTime());
                break;
            }
        }
    }

    protected boolean verifySearchOptions() {
        int n2 = this.getDateFilterCode((String)this.mDateFilterComboBox.getSelectedItem());
        if (n2 != -2) {
            return true;
        }
        try {
            this.mToTextField.commitEdit();
            this.mFromTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date date = (Date)this.mFromTextField.getValue();
        Date date2 = (Date)this.mToTextField.getValue();
        if (date == null) {
            MultiMonitorOptionDialog.showMessageDialog(this.mFrame, "Please enter the From: date for custom searches.", "Patient Search", 0);
            return false;
        }
        if (date2 != null && date2.compareTo(date) < 0) {
            MultiMonitorOptionDialog.showMessageDialog(this.mFrame, "The From: date cannot be after the To: date.", "Patient Search", 0);
            return false;
        }
        return true;
    }

    private int getDateFilterCode(Object object) {
        if (!mAdvancedDateFilterOptions.containsKey(object)) {
            throw new IllegalArgumentException(object + " is not part of date filter code");
        }
        return (Integer)mAdvancedDateFilterOptions.get(object);
    }

    public SearchSpecification getSearchSpecification() {
        Serializable serializable;
        int n2;
        SearchSpecification searchSpecification = new SearchSpecification();
        List list = this.mModalityPanel.getCheckBoxes();
        for (n2 = 0; n2 < list.size(); ++n2) {
            serializable = (JCheckBox)list.get(n2);
            if (!serializable.isSelected()) continue;
            searchSpecification.addModality(serializable.getText());
        }
        searchSpecification = this.updateSearchSpecificationWithSearchFields(searchSpecification);
        if (this.mPatientSearchPane.getSession().getSiteConfiguration().isDicomSearchAvailable() && this.mSearchExternalPacs != null) {
            searchSpecification.setSearchDicomSource(this.mSearchExternalPacs.isSelected());
        }
        if (this.mPatientSearchPane.getSession().useSiteCodes()) {
            String string = (String)this.mSiteFilterComboBox.getSelectedItem();
            if (string.equals("All")) {
                string = "";
            }
            searchSpecification.setSiteCode(string);
        }
        if ((n2 = this.getDateFilterCode((String)this.mDateFilterComboBox.getSelectedItem())) == -2) {
            searchSpecification.setDateSelection(-2);
            serializable = (Date)this.mFromTextField.getValue();
            Date date = (Date)this.mToTextField.getValue();
            if (date == null) {
                searchSpecification.setFromDate((Date)serializable);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                this.mToTextField.setValue(gregorianCalendar.getTime());
                searchSpecification.setToDate(gregorianCalendar.getTime());
            } else {
                searchSpecification.setFromDate((Date)serializable);
                searchSpecification.setToDate(date);
            }
        } else {
            searchSpecification.setDateSelection(n2);
        }
        return searchSpecification;
    }

    private void changeToCustomDate() {
        int n2 = this.mDateFilterComboBox.getItemCount() - 1;
        if (this.mDateFilterComboBox.getSelectedIndex() == n2) {
            return;
        }
        this.mDateFilterComboBox.setSelectedIndex(n2);
    }

    static {
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("All dates", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(-1));
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("Today", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(0));
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("Yesterday", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(1));
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("Last 2 days", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(2));
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("Last 7 days", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(7));
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("Last 31 days", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(31));
        mAdvancedDateFilterOptions.put(GuiUtilities.getHtmlLabel("Custom", "/PatientSearchLibrary/Gui/Icons/date.png"), new Integer(-2));
    }

    private class DateFieldChangeListener
    implements KeyListener {
        private DateFieldChangeListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            AdvancedSearchView.this.changeToCustomDate();
        }
    }
}

