/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Util.MinimalJPopupMenuAdaptor;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchExtender;
import PatientSearchLibrary.Gui.ResultTable;
import PatientSearchLibrary.Gui.ResultTableModel;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.ViewSet;
import com.intelerad.table.lib.TableColumnProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class GenericResultPane
extends JPanel
implements ActionListener {
    public static final String STUDY_MENU_TITLE = "Study menu";
    public static final String SERIES_MENU_TITLE = "Series menu";
    public static final String VIEW_SELECTED_STUDIES = "View selected studies";
    public static final String VIEW_SELECTED_STUDIES_IN_NEW_WINDOW = "View selected studies in new window";
    public static final String ADD_SELECTED_STUDIES = "Add selected studies";
    public static final String VIEW_SELECTED_SERIES = "View selected series";
    public static final String VIEW_SELECTED_SERIES_IN_NEW_WINDOW = "View selected series in new window";
    public static final String ADD_SELECTED_SERIES = "Add selected series";
    public static final Icon NULL_ICON = GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/null.png", 16, 16);
    public static final ImageIcon PATIENT_ICON = GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/patient.gif", 16, 16);
    public static final ImageIcon VIEW_ICON = GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/view.png", 16, 16);
    protected JSplitPane mSplitPane;
    protected ResultTable mStudyTable;
    private ResultTable mSeriesTable;
    private JScrollPane mSeriesScroller;
    private JScrollPane mStudyScroller;
    private TitledBorder mSeriesTitleBorder;
    private TitledBorder mStudyTitleBorder;
    private final PatientSearchExtender mPatientSearchExtender;
    private final SearchSession mSession;

    public GenericResultPane(SearchSession searchSession, PatientSearchExtender patientSearchExtender) {
        this.mSession = searchSession;
        this.mPatientSearchExtender = patientSearchExtender;
    }

    protected SearchSession getSession() {
        return this.mSession;
    }

    protected abstract void viewData(ViewSet var1, LoadRequestType var2);

    protected void initSplitPane() {
        this.mSplitPane = new JSplitPane(0, true, this.mStudyScroller, this.mSeriesScroller);
        this.mSplitPane.setOneTouchExpandable(true);
        int n2 = this.mSplitPane.getDividerLocation();
        n2 = (int)((this.mSplitPane.getBounds().getHeight() - (double)this.mSplitPane.getDividerSize()) / 2.0);
        this.mSplitPane.setDividerLocation(n2);
        double d2 = 0.5;
        this.mSplitPane.setDividerLocation(d2);
        double d3 = 0.5;
        this.mSplitPane.setResizeWeight(d3);
    }

    public void updateData(List list, Map map, Map map2) {
        SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
        List list2 = seriesTableModel.getSelectedRows(this.mSeriesTable.getSelectedRows());
        this.updateStudyTable(list, GenericResultPane.getStudyColumns(map));
        seriesTableModel.updateData(Collections.EMPTY_LIST, GenericResultPane.getSeriesColumns(map2));
        this.mSeriesTable.updateTableHeader();
        this.updateSelectedSeries();
        seriesTableModel.selectData(this.mSeriesTable.getSelectionModel(), list2);
    }

    public void clearAllData() {
        StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
        studyTableModel.clearData();
        studyTableModel.fireTableDataChanged();
        SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
        seriesTableModel.clearData();
        seriesTableModel.fireTableDataChanged();
        this.updateTableTitles();
    }

    protected void initStudyTable(List list, Map map) {
        StudyTableModel studyTableModel = new StudyTableModel(list, map);
        this.createStudyTable(studyTableModel);
        this.mStudyScroller = new JScrollPane(this.mStudyTable);
        this.mStudyScroller.setPreferredSize(new Dimension(0, 500));
        this.mStudyScroller.getViewport().setBackground(Color.LIGHT_GRAY);
        this.mStudyTitleBorder = new TitledBorder(new EtchedBorder(Color.ORANGE, Color.BLACK), " Studies ");
        this.mStudyTitleBorder.setTitleFont(new Font("Helvetica", 1, 14));
        this.mStudyTitleBorder.setTitleColor(Color.BLUE);
        this.mStudyScroller.setBorder(this.mStudyTitleBorder);
    }

    private void updateTableTitles() {
        int n2 = this.mStudyTable.getRowCount();
        int n3 = this.mSeriesTable.getRowCount();
        this.mStudyTitleBorder.setTitle(n2 > 0 ? " " + n2 + " Studies " : " Studies ");
        this.mSeriesTitleBorder.setTitle(n3 > 0 ? " " + n3 + " Series " : " Series ");
        this.mStudyScroller.repaint();
        this.mSeriesScroller.repaint();
    }

    private void updateStudyTable(List list, Map map) {
        StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
        List list2 = studyTableModel.getSelectedRows(this.mStudyTable.getSelectedRows());
        studyTableModel.updateData(list, map);
        studyTableModel.fireTableDataChanged();
        studyTableModel.selectData(this.mStudyTable.getSelectionModel(), list2);
        this.mStudyTable.updateTableHeader();
        this.updateTableTitles();
    }

    protected void initSeriesTable(Map map) {
        SeriesTableModel seriesTableModel = new SeriesTableModel(map);
        this.createSeriesTable(seriesTableModel);
        this.mSeriesScroller = new JScrollPane(this.mSeriesTable);
        this.mSeriesScroller.setPreferredSize(new Dimension(0, 500));
        this.mSeriesScroller.getViewport().setBackground(Color.LIGHT_GRAY);
        this.mSeriesTitleBorder = new TitledBorder(new EtchedBorder(Color.ORANGE, Color.BLACK), " Series ");
        this.mSeriesTitleBorder.setTitleFont(new Font("Helvetica", 1, 14));
        this.mSeriesTitleBorder.setTitleColor(Color.BLUE);
        this.mSeriesScroller.setBorder(this.mSeriesTitleBorder);
    }

    public static Map getStudyColumns(Map map) {
        LinkedHashMap<String, TableColumnProperties> linkedHashMap = new LinkedHashMap<String, TableColumnProperties>();
        TableColumnProperties tableColumnProperties = new TableColumnProperties("Online", 50, "Status");
        linkedHashMap.put("Status", tableColumnProperties);
        linkedHashMap.putAll(map);
        return linkedHashMap;
    }

    public static Map getSeriesColumns(Map map) {
        LinkedHashMap<String, TableColumnProperties> linkedHashMap = new LinkedHashMap<String, TableColumnProperties>();
        TableColumnProperties tableColumnProperties = new TableColumnProperties("Online", 50, "Status");
        linkedHashMap.put("Status", tableColumnProperties);
        linkedHashMap.putAll(map);
        return linkedHashMap;
    }

    private void createStudyTable(StudyTableModel studyTableModel) {
        this.mStudyTable = new ResultTable(studyTableModel, this.createStudyMenu());
        this.mStudyTable.addMouseListener(new StudyTableMouseAdapter(this.mStudyTable));
        this.mStudyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!GenericResultPane.this.mStudyTable.isSortingData() && GenericResultPane.this.mStudyTable.getRowCount() > 0) {
                    GenericResultPane.this.updateSelectedSeries();
                }
            }
        });
    }

    protected void extendMenu(PatientSearchExtender.PatientMenuType patientMenuType, JPopupMenu jPopupMenu) {
        this.mPatientSearchExtender.extendMenu(patientMenuType, new MinimalJPopupMenuAdaptor(jPopupMenu));
    }

    protected JPopupMenu createStudyMenu() {
        return GenericResultPane.createDefaultStudyMenu(this);
    }

    public static JPopupMenu createDefaultStudyMenu(ActionListener actionListener) {
        JPopupMenu jPopupMenu = new JPopupMenu(STUDY_MENU_TITLE);
        JMenuItem jMenuItem = new JMenuItem(VIEW_SELECTED_STUDIES, VIEW_ICON);
        jMenuItem.setActionCommand("VIEW_STUDIES");
        jMenuItem.addActionListener(actionListener);
        JMenuItem jMenuItem2 = new JMenuItem(VIEW_SELECTED_STUDIES_IN_NEW_WINDOW, NULL_ICON);
        jMenuItem2.setActionCommand("VIEW_STUDIES_IN_NEW_WINDOW");
        jMenuItem2.addActionListener(actionListener);
        JMenuItem jMenuItem3 = new JMenuItem(ADD_SELECTED_STUDIES, NULL_ICON);
        jMenuItem3.setActionCommand("ADD_STUDIES");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((JMenuItem)actionEvent.getSource()).getActionCommand();
        if ("VIEW_STUDIES".equals(string)) {
            StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
            this.viewData(new ViewSet(studyTableModel.getSelectedRows(this.mStudyTable.getSelectedRows())), LoadRequestType.LOAD_IN_CURRENT);
        } else if ("VIEW_STUDIES_IN_NEW_WINDOW".equals(string)) {
            StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
            this.viewData(new ViewSet(studyTableModel.getSelectedRows(this.mStudyTable.getSelectedRows())), LoadRequestType.LOAD_IN_NEW);
        } else if ("ADD_STUDIES".equals(string)) {
            StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
            this.viewData(new ViewSet(studyTableModel.getSelectedRows(this.mStudyTable.getSelectedRows())), LoadRequestType.ADD_TO_CURRENT);
        } else if ("VIEW_SERIES".equals(string)) {
            SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
            this.viewData(new ViewSet(seriesTableModel.getSelectedRows(this.mSeriesTable.getSelectedRows())), LoadRequestType.LOAD_IN_CURRENT);
        } else if ("VIEW_SERIES_IN_NEW_WINDOW".equals(string)) {
            SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
            this.viewData(new ViewSet(seriesTableModel.getSelectedRows(this.mSeriesTable.getSelectedRows())), LoadRequestType.LOAD_IN_NEW);
        } else if ("ADD_SERIES".equals(string)) {
            SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
            this.viewData(new ViewSet(seriesTableModel.getSelectedRows(this.mSeriesTable.getSelectedRows())), LoadRequestType.ADD_TO_CURRENT);
        }
    }

    private void createSeriesTable(SeriesTableModel seriesTableModel) {
        this.mSeriesTable = new ResultTable(seriesTableModel, this.createSeriesMenu(this));
        this.mSeriesTable.addMouseListener(new SeriesTableMouseAdapter(this.mSeriesTable));
    }

    private void updateSelectedSeries() {
        StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
        SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
        seriesTableModel.clearData();
        int[] nArray = this.mStudyTable.getSelectedRows();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Study study = studyTableModel.getStudy(nArray[i2]);
            seriesTableModel.addSeriesFromStudy(study);
        }
        seriesTableModel.reSort();
        seriesTableModel.fireTableDataChanged();
        this.updateTableTitles();
    }

    protected JPopupMenu createSeriesMenu(ActionListener actionListener) {
        return GenericResultPane.createDefaultSeriesMenu(actionListener);
    }

    public static JPopupMenu createDefaultSeriesMenu(ActionListener actionListener) {
        JPopupMenu jPopupMenu = new JPopupMenu(SERIES_MENU_TITLE);
        JMenuItem jMenuItem = new JMenuItem(VIEW_SELECTED_SERIES, VIEW_ICON);
        jMenuItem.setActionCommand("VIEW_SERIES");
        jMenuItem.addActionListener(actionListener);
        JMenuItem jMenuItem2 = new JMenuItem(VIEW_SELECTED_SERIES_IN_NEW_WINDOW, NULL_ICON);
        jMenuItem2.setActionCommand("VIEW_SERIES_IN_NEW_WINDOW");
        jMenuItem2.addActionListener(actionListener);
        JMenuItem jMenuItem3 = new JMenuItem(ADD_SELECTED_SERIES, NULL_ICON);
        jMenuItem3.setActionCommand("ADD_SERIES");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    public void updateStatus() {
        StudyTableModel studyTableModel = (StudyTableModel)this.mStudyTable.getModel();
        SeriesTableModel seriesTableModel = (SeriesTableModel)this.mSeriesTable.getModel();
        seriesTableModel.fireTableColumnUpdated(seriesTableModel.getColumnIndexByKey("Status"));
        studyTableModel.fireTableColumnUpdated(studyTableModel.getColumnIndexByKey("Status"));
    }

    public void updateRetrievalStatus() {
        Runnable runnable = new Runnable(){

            public void run() {
                GenericResultPane.this.updateStatus();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    class SeriesTableMouseAdapter
    extends ResultTable.MouseAdapter {
        SeriesTableMouseAdapter(ResultTable resultTable) {
            super(resultTable);
        }

        protected void mouseDoubleClicked() {
            SeriesTableModel seriesTableModel = (SeriesTableModel)this.mTable.getModel();
            GenericResultPane.this.viewData(new ViewSet(seriesTableModel.getSelectedRows(this.mTable.getSelectedRows())), LoadRequestType.LOAD_IN_CURRENT);
        }
    }

    class StudyTableMouseAdapter
    extends ResultTable.MouseAdapter {
        StudyTableMouseAdapter(ResultTable resultTable) {
            super(resultTable);
        }

        protected void mouseDoubleClicked() {
            ResultTableModel resultTableModel = (ResultTableModel)this.mTable.getModel();
            GenericResultPane.this.viewData(new ViewSet(resultTableModel.getSelectedRows(this.mTable.getSelectedRows())), LoadRequestType.LOAD_IN_CURRENT);
        }
    }

    class SeriesTableModel
    extends ResultTableModel {
        SeriesTableModel(Map map) {
            super(new ArrayList(), map);
        }

        public Series getSeries(int n2) {
            return (Series)this.mData.get(n2);
        }

        public void addSeriesFromStudy(Study study) {
            this.mData.addAll(study.getSeriesMap().values());
        }

        protected void setInitialSortingOrder() {
            this.mPrimarySortColumn = "PName";
            this.mPrimarySortAscending = true;
            this.mSecondarySortColumn = "SerDate";
            this.mSecondarySortAscending = false;
            this.mTertiarySortColumn = "SerNum";
            this.mTertiarySortAscending = true;
        }
    }

    class StudyTableModel
    extends ResultTableModel {
        StudyTableModel(List list, Map map) {
            super(list, map);
        }

        public Study getStudy(int n2) {
            return (Study)this.mData.get(n2);
        }

        public List getAllStudies() {
            return new ArrayList(this.mData);
        }

        protected void setInitialSortingOrder() {
            this.mPrimarySortColumn = "PName";
            this.mPrimarySortAscending = true;
            this.mSecondarySortColumn = "StuDate";
            this.mSecondarySortAscending = false;
            this.mTertiarySortColumn = null;
            this.mTertiarySortAscending = true;
        }
    }
}

