/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Util.DefaultButtonProvider;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchExtender;
import PatientSearchLibrary.Gui.PatientSearchStatus;
import PatientSearchLibrary.Gui.ResultPane;
import PatientSearchLibrary.Gui.SearchController;
import PatientSearchLibrary.Gui.SearchPane;
import PatientSearchLibrary.Gui.SearchPerformer;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Preferences.PatientSearchPreferenceProvider;
import PatientSearchLibrary.Retrieve.Retriever;
import PatientSearchLibrary.View.SeriesViewer;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PatientSearchPane
extends JPanel
implements DefaultButtonProvider {
    private SearchPane mSearchPane;
    private ResultPane mResultPane;
    private SearchSession mSession;
    private SearchController mSearchController;

    public PatientSearchPane(JFrame jFrame, PatientSearchExtender patientSearchExtender, SearchSession searchSession, SeriesViewer seriesViewer, Retriever retriever) {
        GlobalState.trace("Starting Intelerad Patient Search Tool...");
        this.mSession = searchSession;
        this.mSearchController = new SearchController(this);
        this.guiInit(jFrame, patientSearchExtender, seriesViewer, retriever);
    }

    private void guiInit(JFrame jFrame, PatientSearchExtender patientSearchExtender, SeriesViewer seriesViewer, Retriever retriever) {
        this.setLayout(new BorderLayout());
        this.mSearchPane = new SearchPane(jFrame, this);
        this.mResultPane = new ResultPane(jFrame, patientSearchExtender, this.mSession, new ArrayList(), this.mSession.getSiteConfiguration().getStudyDisplayFieldMap(), this.mSession.getSiteConfiguration().getSeriesDisplayFieldMap(), seriesViewer, this, retriever);
        this.add("North", this.mSearchPane);
        this.add("Center", this.mResultPane);
        AncestorListener ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                PatientSearchPane.this.mSearchController.setFrozen(false);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                PatientSearchPane.this.mSearchController.setFrozen(true);
            }
        };
        this.addAncestorListener(ancestorListener);
    }

    public void setSearchRefreshStatus(PatientSearchStatus patientSearchStatus) {
        this.mSearchPane.setSearchRefreshStatus(patientSearchStatus);
    }

    public void search(SearchPerformer searchPerformer, boolean bl2) {
        this.mSearchController.search(searchPerformer, bl2);
    }

    public SearchSession getSession() {
        return this.mSession;
    }

    public void setSearchSession(SearchSession searchSession) {
        this.mSession = searchSession;
    }

    public void updateSearchData(List list, Map map, Map map2) {
        this.mResultPane.updateData(list, map, map2);
    }

    public void clearSearchData() {
        this.mResultPane.clearAllData();
    }

    public PatientSearchPreferenceProvider getUserPreferences() {
        return this.mSession.getPreferenceProvider();
    }

    public JButton getDefaultButton() {
        return this.mSearchPane.getDefaultButton();
    }
}

