/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import DataModels.UserModels.SessionException;
import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Worker.WorkerController;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchPane;
import PatientSearchLibrary.Gui.PatientSearchStatus;
import PatientSearchLibrary.Gui.PeriodicSearcher;
import PatientSearchLibrary.Gui.SearchListener;
import PatientSearchLibrary.Gui.SearchPerformer;
import PatientSearchLibrary.Gui.SearchWorker;
import PatientSearchLibrary.Preferences.SiteConfiguration;
import PatientSearchLibrary.Search.SearchClient;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class SearchController {
    private static int DEFAULT_SEARCH_DELAY = 600000;
    private PatientSearchPane mPatientSearchPane;
    private SiteConfiguration mSiteConfig;
    private PeriodicSearcher mPeriodicSearcher;
    private SearchPerformer mLastSearchPerformer;
    private long mLastSearchTime;
    private boolean mIsFrozen = false;

    public SearchController(PatientSearchPane patientSearchPane) {
        this.mPatientSearchPane = patientSearchPane;
        this.mSiteConfig = this.mPatientSearchPane.getSession().getSiteConfiguration();
    }

    public void search(SearchPerformer searchPerformer, boolean bl2) {
        this.stopPeriodicSearch();
        UserSearchHandler userSearchHandler = new UserSearchHandler(bl2);
        WorkerController workerController = SearchWorker.createProgressSearcher(this.getParentWindow(), searchPerformer, userSearchHandler);
        this.mLastSearchPerformer = searchPerformer;
        workerController.start();
    }

    private Window getParentWindow() {
        return SwingUtilities.getWindowAncestor(this.mPatientSearchPane);
    }

    private void enablePeriodicSearch(boolean bl2) {
        this.enablePeriodicSearch(bl2, false);
    }

    private void enablePeriodicSearch(boolean bl2, boolean bl3) {
        this.stopPeriodicSearch();
        if (!bl2) {
            return;
        }
        if (this.mLastSearchPerformer == null) {
            return;
        }
        this.mPeriodicSearcher = new PeriodicSearcher(this.mLastSearchPerformer, new PeriodicSearchRequester(), this.getSearchDelay());
        this.mPeriodicSearcher.start(bl3);
    }

    public boolean isPeriodicSearchEnabled() {
        return this.mLastSearchPerformer != null && this.mPeriodicSearcher != null;
    }

    private int getSearchDelay() {
        try {
            return 1000 * this.mPatientSearchPane.getSession().getControlFile().GetIntValue("PATIENT_SEARCH", "periodicSearchInterval");
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_SEARCH_DELAY;
        }
    }

    private void stopPeriodicSearch() {
        if (this.mPeriodicSearcher == null) {
            return;
        }
        this.mPeriodicSearcher.cancel();
        this.mPeriodicSearcher = null;
        this.mPatientSearchPane.setSearchRefreshStatus(PatientSearchStatus.NULL_STATUS);
    }

    public void close() {
        this.stopPeriodicSearch();
    }

    public void logSearchResult(SearchClient searchClient) {
        switch (searchClient.getResultCode()) {
            case 0: {
                GlobalState.trace("Search finished with result code OK");
                break;
            }
            case 1: {
                this.logSearchError("ERROR", searchClient);
                break;
            }
            case 2: {
                this.logSearchError("NO_RESULTS", searchClient);
                break;
            }
            case 3: {
                this.logSearchError("TOO_MANY_RESULTS", searchClient);
                break;
            }
            case 4: {
                this.logSearchError("CANCELLED", searchClient);
                break;
            }
            case -1: {
                GlobalState.trace("Search was never started, probably due to an invalid search specification");
                break;
            }
            default: {
                GlobalState.trace("Search finished with unknown result code (" + searchClient.getResultCode() + "). This should not occur!");
            }
        }
    }

    public void logSearchError(String string, SearchClient searchClient) {
        GlobalState.trace("Search finished with result code " + string + " (" + searchClient.getErrorDetails() + ")");
    }

    private boolean isSessionExpired(SearchClient searchClient) {
        String string;
        return searchClient.getResultCode() == 2 && ((string = searchClient.getErrorDetails()) != null && string.equals(SessionException.BAD_SESSION_ID.toString()) || string.equals(SessionException.SESSION_EXPIRED.toString()));
    }

    private void setLastSearchTime(SearchClient searchClient) {
        if (searchClient == null) {
            this.mPatientSearchPane.setSearchRefreshStatus(new PatientSearchStatus(this.mLastSearchTime, System.currentTimeMillis() + (long)this.mPeriodicSearcher.getSearchDelay()));
        }
        if (this.isSessionExpired(searchClient)) {
            this.enablePeriodicSearch(false);
            this.mPatientSearchPane.setSearchRefreshStatus(new PatientSearchStatus("Session Expired"));
        } else if (this.mPeriodicSearcher == null) {
            this.mPatientSearchPane.setSearchRefreshStatus(PatientSearchStatus.NULL_STATUS);
        } else if (searchClient.getResultCode() == 0 || searchClient.getResultCode() == 2) {
            this.mPatientSearchPane.setSearchRefreshStatus(new PatientSearchStatus(System.currentTimeMillis(), System.currentTimeMillis() + (long)this.mPeriodicSearcher.getSearchDelay()));
            this.mLastSearchTime = System.currentTimeMillis();
        } else {
            this.mPatientSearchPane.setSearchRefreshStatus(new PatientSearchStatus(this.mLastSearchTime, System.currentTimeMillis() + (long)this.mPeriodicSearcher.getSearchDelay()));
        }
    }

    public void setFrozen(boolean bl2) {
        if (bl2 && !this.mIsFrozen && this.isPeriodicSearchEnabled()) {
            this.enablePeriodicSearch(false);
            this.mIsFrozen = bl2;
        } else if (!bl2 && this.mIsFrozen && !this.isPeriodicSearchEnabled()) {
            this.enablePeriodicSearch(true, true);
            this.mIsFrozen = bl2;
        }
    }

    private class UserSearchHandler
    implements SearchListener {
        private final boolean mClearOnError;

        public UserSearchHandler(boolean bl2) {
            this.mClearOnError = bl2;
        }

        public void handleSearchResults(SearchClient searchClient) {
            SearchController.this.logSearchResult(searchClient);
            switch (searchClient.getResultCode()) {
                case 0: {
                    SearchController.this.mPatientSearchPane.clearSearchData();
                    SearchController.this.mPatientSearchPane.updateSearchData(searchClient.getSearchResults(), SearchController.this.mSiteConfig.getStudyDisplayFieldMap(), SearchController.this.mSiteConfig.getSeriesDisplayFieldMap());
                    SearchController.this.enablePeriodicSearch(true);
                    SearchController.this.setLastSearchTime(searchClient);
                    break;
                }
                case 1: {
                    if (this.mClearOnError) {
                        SearchController.this.mPatientSearchPane.clearSearchData();
                    }
                    MultiMonitorOptionDialog.showMessageDialog(SearchController.this.getParentWindow(), "Search error:\n", "Patient Search", 0);
                    break;
                }
                case 2: {
                    if (!SearchController.this.isSessionExpired(searchClient) || this.mClearOnError) {
                        SearchController.this.mPatientSearchPane.clearSearchData();
                    }
                    MultiMonitorOptionDialog.showMessageDialog(SearchController.this.getParentWindow(), searchClient.getErrorDetails(), "Patient Search", 1);
                    SearchController.this.enablePeriodicSearch(!SearchController.this.isSessionExpired(searchClient));
                    SearchController.this.setLastSearchTime(searchClient);
                    break;
                }
                case 3: {
                    if (this.mClearOnError) {
                        SearchController.this.mPatientSearchPane.clearSearchData();
                    }
                    MultiMonitorOptionDialog.showMessageDialog(SearchController.this.getParentWindow(), searchClient.getErrorDetails(), "Patient Search", 2);
                    break;
                }
            }
        }

        public void handleCancel() {
            SearchController.this.enablePeriodicSearch(false);
        }

        public void handleException(Exception exception) {
            SearchController.this.setLastSearchTime(null);
        }
    }

    private class PeriodicSearchRequester
    implements SearchListener {
        private PeriodicSearchRequester() {
        }

        public void handleSearchResults(SearchClient searchClient) {
            if (searchClient.getResultCode() == 0) {
                SearchController.this.mPatientSearchPane.updateSearchData(searchClient.getSearchResults(), SearchController.this.mSiteConfig.getStudyDisplayFieldMap(), SearchController.this.mSiteConfig.getSeriesDisplayFieldMap());
            } else if (SearchController.this.isSessionExpired(searchClient)) {
                SearchController.this.enablePeriodicSearch(false);
            } else if (searchClient.getResultCode() == 2) {
                SearchController.this.mPatientSearchPane.clearSearchData();
            }
            SearchController.this.setLastSearchTime(searchClient);
        }

        public void handleCancel() {
        }

        public void handleException(Exception exception) {
            SearchController.this.setLastSearchTime(null);
        }
    }
}

