/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import PatientSearchLibrary.Gui.AdvancedSearchView;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchPane;
import PatientSearchLibrary.Gui.PatientSearchStatus;
import PatientSearchLibrary.Gui.SearchView;
import PatientSearchLibrary.Gui.SimpleSearchView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SearchPane
extends JPanel
implements ActionListener {
    private JFrame mFrame;
    private PatientSearchPane mPatientSearch;
    private JPanel mSearchModePane;
    private JButton mAdvancedSearchButton;
    private JButton mSimpleSearchButton;
    private SimpleSearchView mSimpleSearchView;
    private AdvancedSearchView mAdvancedSearchView;
    private boolean mIsAdvancedMode = false;
    private JLabel mLastSearchTimeLabel;
    private PatientSearchStatus mPatientSearchStatus;
    private Timer mTimer;

    public SearchPane(JFrame jFrame, PatientSearchPane patientSearchPane) {
        Color color = new Color(43, 84, 112);
        this.mFrame = jFrame;
        this.mPatientSearch = patientSearchPane;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 4, 8));
        this.mSearchModePane = new JPanel(new BorderLayout());
        this.mSearchModePane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.mSimpleSearchButton = new JButton("Basic search options...", GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/expand.png"));
        this.mSimpleSearchButton.addActionListener(this);
        this.mSimpleSearchButton.setFont(new Font("Default", 1, 11));
        this.mSimpleSearchButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mSimpleSearchButton.setForeground(color);
        this.mSimpleSearchButton.setCursor(new Cursor(12));
        this.mAdvancedSearchButton = new JButton("Advanced search options...", GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/expand.png"));
        this.mAdvancedSearchButton.addActionListener(this);
        this.mAdvancedSearchButton.setFont(new Font("Default", 1, 11));
        this.mAdvancedSearchButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mAdvancedSearchButton.setForeground(color);
        this.mAdvancedSearchButton.setCursor(new Cursor(12));
        if (this.mPatientSearch.getSession().getPreferenceProvider().isAdvancedSearchMode()) {
            this.advancedSearchView();
        } else {
            this.simpleSearchView();
        }
        this.mLastSearchTimeLabel = new JLabel("");
        this.mLastSearchTimeLabel.setPreferredSize(new Dimension(1000, 22));
        this.add((Component)this.mLastSearchTimeLabel, "South");
        this.add((Component)this.mSearchModePane, "North");
        this.mPatientSearchStatus = PatientSearchStatus.NULL_STATUS;
        AncestorListener ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                SearchPane.this.setTimerEnable(true);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                SearchPane.this.setTimerEnable(false);
            }
        };
        this.addAncestorListener(ancestorListener);
    }

    void setSearchRefreshStatus(PatientSearchStatus patientSearchStatus) {
        this.mPatientSearchStatus = patientSearchStatus;
        this.setTimerEnable(patientSearchStatus != PatientSearchStatus.NULL_STATUS);
        this.displayLastSearchTime();
    }

    private void displayLastSearchTime() {
        this.mLastSearchTimeLabel.setText(this.mPatientSearchStatus.getUiString());
        if (this.mPatientSearchStatus == PatientSearchStatus.NULL_STATUS) {
            this.mLastSearchTimeLabel.setIcon(null);
        } else {
            this.mLastSearchTimeLabel.setIcon(GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/last_search_time.png", 22, 22));
        }
    }

    private void setTimerEnable(boolean bl2) {
        if (this.mTimer != null) {
            this.mTimer.stop();
        }
        if (this.mPatientSearchStatus == PatientSearchStatus.NULL_STATUS) {
            return;
        }
        if (bl2) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPane.this.displayLastSearchTime();
                }
            };
            this.mTimer = new Timer(10000, actionListener);
            this.mTimer.start();
        }
    }

    public void simpleSearchView() {
        this.setAdvancedMode(false);
        if (this.mAdvancedSearchView != null) {
            this.remove(this.mAdvancedSearchView);
            this.mAdvancedSearchView.removeAll();
            this.mAdvancedSearchView = null;
        }
        this.mSimpleSearchView = new SimpleSearchView(this.mFrame, this.mPatientSearch);
        this.add((Component)this.mSimpleSearchView, "Center");
        this.mSearchModePane.remove(this.mSimpleSearchButton);
        this.mSearchModePane.add((Component)this.mAdvancedSearchButton, "East");
        this.mPatientSearch.revalidate();
    }

    public void advancedSearchView() {
        this.setAdvancedMode(true);
        if (this.mSimpleSearchView != null) {
            this.remove(this.mSimpleSearchView);
            this.mSimpleSearchView.removeAll();
            this.mSimpleSearchView = null;
        }
        this.mAdvancedSearchView = new AdvancedSearchView(this.mFrame, this.mPatientSearch);
        this.add((Component)this.mAdvancedSearchView, "Center");
        this.mSearchModePane.remove(this.mAdvancedSearchButton);
        this.mSearchModePane.add((Component)this.mSimpleSearchButton, "East");
        this.mPatientSearch.revalidate();
    }

    public boolean isAdvancedMode() {
        return this.mIsAdvancedMode;
    }

    public void setAdvancedMode(boolean bl2) {
        this.mIsAdvancedMode = bl2;
        this.mPatientSearch.getSession().getPreferenceProvider().setAdvancedSearchMode(bl2);
    }

    protected SearchView getSearchView() {
        if (this.isAdvancedMode()) {
            return this.mAdvancedSearchView;
        }
        return this.mSimpleSearchView;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mAdvancedSearchButton) {
            this.advancedSearchView();
        } else if (actionEvent.getSource() == this.mSimpleSearchButton) {
            this.simpleSearchView();
        } else {
            return;
        }
    }

    public JButton getDefaultButton() {
        return this.mIsAdvancedMode ? this.mAdvancedSearchView.getDefaultButton() : this.mSimpleSearchView.getDefaultButton();
    }
}

