/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Layouts.GridLayoutPlus;
import GuiUtilities.Layouts.ParagraphLayout;
import GuiUtilities.Util.CheckBoxGroupPanel;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PatientSearchPane;
import PatientSearchLibrary.Gui.PatientSearchStatus;
import PatientSearchLibrary.Gui.SearchFieldUi;
import PatientSearchLibrary.Gui.SearchPerformer;
import PatientSearchLibrary.Preferences.PatientSearchPreferenceProvider;
import PatientSearchLibrary.Preferences.SiteConfiguration;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.Search.SearchSpecification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class SearchView
extends JPanel {
    private static final boolean CLEAR_ON_ERROR = true;
    protected JFrame mFrame;
    protected PatientSearchPane mPatientSearchPane;
    protected GridLayoutPlus mGridLayoutPlus;
    protected PatientSearchPreferenceProvider mUserPref;
    protected SearchClient mSearchClient;
    protected SiteConfiguration mSiteConfig;
    protected JPanel mFieldsPanel;
    protected JPanel mModalitiesPanel;
    protected JPanel mDateFilterPanel;
    protected JPanel mLogoPanel;
    protected JButton mSearchButton;
    protected JButton mResetButton;
    protected JLabel mDateFilterLabel;
    protected JComboBox mDateFilterComboBox;
    protected JLabel mSiteFilterLabel;
    protected JComboBox mSiteFilterComboBox;
    protected JCheckBox mSearchExternalPacs;
    protected CheckBoxGroupPanel mModalityPanel;
    protected Collection mUsedSearchFields = new ArrayList();
    private Map mAvailableSearchFieldsMap = new TreeMap();

    public SearchView(JFrame jFrame, PatientSearchPane patientSearchPane) {
        this.mFrame = jFrame;
        this.mPatientSearchPane = patientSearchPane;
        this.mGridLayoutPlus = new GridLayoutPlus(1, 3, 20, 0);
        this.mUserPref = this.mPatientSearchPane.getSession().getPreferenceProvider();
        this.mSiteConfig = this.mPatientSearchPane.getSession().getSiteConfiguration();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(Color.ORANGE, Color.BLACK), " Search ");
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.BLUE);
        this.setBorder(titledBorder);
        this.setLayout(this.mGridLayoutPlus);
        this.initAvailableSearchFields();
        this.initUsedSearchFields();
        this.createFieldsPanel();
        this.createModalitiesPanel();
        this.createDateFilterPanel();
        this.createSearchButton();
        this.addAncestorListener(new SearchResetHandler());
    }

    protected abstract void createDateFilterPanel();

    public abstract SearchSpecification getSearchSpecification();

    protected abstract boolean verifySearchOptions();

    protected abstract boolean isComparatorUsed();

    protected abstract void initUsedSearchFields();

    private void createFieldsPanel() {
        this.mFieldsPanel = new JPanel();
        this.mFieldsPanel.setLayout(new ParagraphLayout());
        this.createResetButton();
        Iterator iterator = this.mUsedSearchFields.iterator();
        while (iterator.hasNext()) {
            SearchFieldUi searchFieldUi = (SearchFieldUi)iterator.next();
            JComponent jComponent = searchFieldUi.getLabelUi();
            JComponent jComponent2 = searchFieldUi.getComparatorUi();
            JComponent jComponent3 = searchFieldUi.getTextFieldUi();
            this.mFieldsPanel.add((Component)jComponent, ParagraphLayout.NEW_PARAGRAPH);
            if (this.isComparatorUsed()) {
                this.mFieldsPanel.add(jComponent2);
            }
            this.mFieldsPanel.add(jComponent3);
            if (!SearchFieldUi.PATIENT_NAME_KEY.equals(searchFieldUi.getUserPreferenceKey()) || this.mPatientSearchPane.getSession().isSearchByPatientNameAllowed()) continue;
            jComponent.setEnabled(false);
            jComponent2.setEnabled(false);
            jComponent3.setEnabled(false);
        }
        this.add(this.mFieldsPanel);
    }

    private void search() {
        if (this.verifySearchOptions()) {
            SimpleSearchPerformer simpleSearchPerformer = new SimpleSearchPerformer(this.mPatientSearchPane.getSession().createSearchClient(), new SearchSpecification(this.getSearchSpecification()));
            this.mPatientSearchPane.search(simpleSearchPerformer, true);
        }
    }

    protected void createModalitiesPanel() {
        GridLayoutPlus gridLayoutPlus = null;
        gridLayoutPlus = this.mUserPref.isAdvancedSearchMode() ? new GridLayoutPlus(3, 3, 10, 10) : new GridLayoutPlus(3, 6, 10, 10);
        List list = this.mSiteConfig.getAvailableModalities();
        this.mModalityPanel = new CheckBoxGroupPanel(list.toArray(new String[0]));
        this.mModalityPanel.setGridLayout(gridLayoutPlus);
        this.mModalityPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.add(this.mModalityPanel);
    }

    protected void createSearchButton() {
        this.mSearchButton = new JButton("Search", GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/search_glass.png"));
        this.mSearchButton.setCursor(new Cursor(12));
        this.mSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchView.this.search();
            }
        });
        this.mDateFilterPanel.add((Component)new JLabel("       "), ParagraphLayout.NEW_PARAGRAPH);
        this.mDateFilterPanel.add(this.mSearchButton);
        this.mFrame.getRootPane().setDefaultButton(this.mSearchButton);
    }

    protected void createResetButton() {
        this.mResetButton = new JButton("Clear", GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/reset.png", 16, 16));
        this.mResetButton.setFocusable(false);
        this.mResetButton.setCursor(new Cursor(12));
        this.mResetButton.addActionListener(new SearchResetHandler());
        this.mFieldsPanel.add(this.mResetButton);
    }

    protected void reset() {
        Iterator iterator = this.mUsedSearchFields.iterator();
        while (iterator.hasNext()) {
            SearchFieldUi searchFieldUi = (SearchFieldUi)iterator.next();
            ((JTextField)searchFieldUi.getTextFieldUi()).setText("");
        }
        this.mDateFilterComboBox.setSelectedIndex(0);
        this.mPatientSearchPane.setSearchRefreshStatus(PatientSearchStatus.NULL_STATUS);
        this.mPatientSearchPane.clearSearchData();
        if (this.mSiteFilterComboBox != null) {
            this.mSiteFilterComboBox.setSelectedIndex(0);
        }
    }

    public JButton getDefaultButton() {
        return this.mSearchButton;
    }

    private void addSearchField(SearchFieldUi searchFieldUi) {
        this.mAvailableSearchFieldsMap.put(searchFieldUi.getUserPreferenceKey(), searchFieldUi);
    }

    SearchFieldUi getSearchField(String string) {
        return (SearchFieldUi)this.mAvailableSearchFieldsMap.get(string);
    }

    protected SearchFieldUi getDefaultSearchField1() {
        return (SearchFieldUi)this.mAvailableSearchFieldsMap.get(SearchFieldUi.PATIENT_ID_KEY);
    }

    protected SearchFieldUi getDefaultSearchField2() {
        return (SearchFieldUi)this.mAvailableSearchFieldsMap.get(SearchFieldUi.PATIENT_NAME_KEY);
    }

    private void initAvailableSearchFields() {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.addSearchField(new SearchFieldUi(this.mSiteConfig.getSearchField(i2), i2, this.isComparatorUsed()));
        }
    }

    protected Collection getAvailableSearchFields() {
        return Collections.unmodifiableCollection(this.mAvailableSearchFieldsMap.values());
    }

    protected SearchSpecification updateSearchSpecificationWithSearchFields(SearchSpecification searchSpecification) {
        Iterator iterator = this.mUsedSearchFields.iterator();
        while (iterator.hasNext()) {
            SearchFieldUi searchFieldUi = (SearchFieldUi)iterator.next();
            searchSpecification.addSearchTerm(searchFieldUi.getSearchTerm());
        }
        return searchSpecification;
    }

    private class SearchResetHandler
    implements AncestorListener,
    ActionListener {
        private SearchResetHandler() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.resetFocus();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchView.this.reset();
            this.resetFocus();
        }

        private void resetFocus() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SearchResetHandler this$1;
                {
                    this.this$1 = searchResetHandler;
                }

                public void run() {
                    ((SearchFieldUi)((ArrayList)SearchResetHandler.access$200((SearchResetHandler)this.this$1).mUsedSearchFields).get(0)).getTextFieldUi().requestFocusInWindow();
                }
            });
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        static /* synthetic */ SearchView access$200(SearchResetHandler searchResetHandler) {
            return searchResetHandler.SearchView.this;
        }
    }

    private static class SimpleSearchPerformer
    implements SearchPerformer {
        private boolean mNoExtendSession = false;
        private SearchSpecification mSearchSpecification;
        private SearchClient mSearchClient;

        public SimpleSearchPerformer(SearchClient searchClient, SearchSpecification searchSpecification) {
            this.mSearchClient = searchClient;
            this.mSearchSpecification = searchSpecification;
        }

        public SearchClient performSearch() {
            this.mSearchSpecification.setNoExtendSession(this.mNoExtendSession);
            this.mSearchClient.setSearchSpecification(this.mSearchSpecification);
            this.mSearchClient.performSearch();
            return this.mSearchClient;
        }

        public void cancelSearch() {
            try {
                this.mSearchClient.cancelSearch();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setNoExtendSession(boolean bl2) {
            this.mNoExtendSession = bl2;
        }
    }
}

