/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Gui;

import GuiUtilities.Worker.Worker;
import GuiUtilities.Worker.WorkerController;
import GuiUtilities.Worker.WorkerControllerUtilities;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.SearchListener;
import PatientSearchLibrary.Gui.SearchPerformer;
import PatientSearchLibrary.Search.SearchClient;
import java.awt.Dimension;
import java.awt.Window;

public class SearchWorker
implements Worker {
    private SearchPerformer mSearchRequester;
    private SearchListener mSearchListener;

    public static WorkerController createProgressSearcher(Window window, SearchPerformer searchPerformer, SearchListener searchListener) {
        return WorkerControllerUtilities.createCancellableController(new SearchWorker(searchPerformer, searchListener), window, GlobalState.getImageIcon("/PatientSearchLibrary/Gui/Icons/searching.gif"), "Searching..", new Dimension(275, 185));
    }

    public SearchWorker(SearchPerformer searchPerformer, SearchListener searchListener) {
        this.mSearchRequester = searchPerformer;
        this.mSearchListener = searchListener;
    }

    public Object call() throws Exception {
        return this.mSearchRequester.performSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCancel() {
        try {
            this.mSearchRequester.cancelSearch();
        }
        catch (Exception exception) {
            GlobalState.error("Caught Exception when trying to cancel search.", exception);
        }
        finally {
            this.mSearchListener.handleCancel();
        }
    }

    public void handleSuccess(Object object) {
        this.mSearchListener.handleSearchResults((SearchClient)object);
    }

    public void handleException(Exception exception) {
        GlobalState.error("Unexpected Exception", exception);
        this.mSearchListener.handleException(exception);
    }
}

