/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Search.RelatedSeriesSearchSpecification;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.Search.SearchRequest;
import RuntimeTool.Debug;
import java.util.List;

public abstract class BaseRelatedSeriesRequest
extends SearchRequest {
    protected final List mSeriesUidList;
    protected final boolean mIncludeTeachingCasePr;

    protected BaseRelatedSeriesRequest(SearchSession searchSession, List list, boolean bl2, Debug debug) {
        super(searchSession, debug);
        this.mSeriesUidList = list;
        this.mIncludeTeachingCasePr = bl2;
    }

    protected SearchClient doSearch() {
        this.getDebug().printTrace("In BaseRelatedSeriesRequest. Searching all related series for series UIDs " + this.mSeriesUidList);
        SearchClient searchClient = this.getSearchSession().createSearchClient();
        RelatedSeriesSearchSpecification relatedSeriesSearchSpecification = new RelatedSeriesSearchSpecification(this.mSeriesUidList, this.mIncludeTeachingCasePr);
        searchClient.setSearchSpecification(relatedSeriesSearchSpecification);
        searchClient.performSearch();
        return searchClient;
    }

    protected String handleNotStarted() {
        this.getDebug().printError("Search for related series " + this.mSeriesUidList + " never started (this should not be possible!!)");
        return "Search did not start.";
    }

    protected String handleError() {
        String string = this.getErrorDetails();
        this.getDebug().printError("Search for related series " + this.mSeriesUidList + " failed: " + string);
        return "Search failed: " + string;
    }

    protected String handleNoResults() {
        return this.handleError();
    }

    protected String handleTooManyResults() {
        this.getDebug().printError("Search for related series " + this.mSeriesUidList + " failed: too many results found");
        return "Too many related series found for series " + this.mSeriesUidList + ".";
    }

    protected String handleCancelled() {
        this.getDebug().printError("Search for related series " + this.mSeriesUidList + " cancelled (this should not be possible!!)");
        return "Search cancelled.";
    }

    protected String handleUnsupportedSearchAction() {
        this.getDebug().printError("Search for related series " + this.mSeriesUidList + " failed: search action is unsupported. (Is the PACS pre-2-5-2?)");
        return "Search failed: incompatible PACS.";
    }
}

