/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import DataModels.SearchFramework.SeriesLocation;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Status;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Search.DicomDirSearchConverter;
import PatientSearchLibrary.Search.SeriesMoverClient;
import com.intelerad.lib.dicomtools.DicomDir;
import java.io.File;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DicomDirSeriesMoverClient
extends SeriesMoverClient {
    private File mDicomFile;
    private Map mSeriesMap;

    public DicomDirSeriesMoverClient(File file) {
        this.mDicomFile = file;
    }

    public void retrieveOfflineStudies(List list) {
        if (list.isEmpty()) {
            return;
        }
        throw new IllegalStateException("DicomDirSeriesMoverClient does not have off-line studies.");
    }

    public List getLocationsForSeriesUids(List list) {
        Map map = this.getSeriesMap();
        ArrayList<SeriesLocation> arrayList = new ArrayList<SeriesLocation>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Series series = (Series)map.get(string);
            if (series == null) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(series.getSeriesLocation());
        }
        return arrayList;
    }

    private Map getSeriesMap() {
        if (this.mSeriesMap != null) {
            return this.mSeriesMap;
        }
        try {
            List list = DicomDirSearchConverter.convertStudies(DicomDir.readDicomDir(this.mDicomFile));
            this.mSeriesMap = Study.getSeriesMap(list);
        }
        catch (Exception exception) {
            this.setError("Error reading DICOMDIR", "Error getting series map", exception);
            this.mSeriesMap = Collections.EMPTY_MAP;
        }
        return this.mSeriesMap;
    }

    protected boolean updateLocationsInSeriesMap(Map map) throws IOException, ProtocolException {
        Map map2 = this.getSeriesMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.updateSeriesList((List)map.get(string), ((Series)map2.get(string)).getSeriesLocation());
        }
        return true;
    }

    private void updateSeriesList(List list, SeriesLocation seriesLocation) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            series.setSeriesLocation(seriesLocation);
            series.setStatus(Status.ONLINE);
            series.setOffline(false);
        }
    }
}

