/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import DataModels.UserModels.SessionException;
import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Gui.PacsSearchSession;
import PatientSearchLibrary.Search.BaseSearchSpecification;
import PatientSearchLibrary.Search.SearchClient;
import PatientSearchLibrary.Search.SearchSpecification;
import PatientSearchLibrary.Search.SearchTerm;
import StringUtilities.StringJoin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class PacsSearchClient
extends SearchClient {
    private static final String CONTENT_TYPE_SEARCH_RESULTS = "application/x-ims-search-results";
    private static final String CONNECT_TIMEOUT_KEY = "sun.net.client.defaultConnectTimeout";
    private static final String READ_TIMEOUT_KEY = "sun.net.client.defaultReadTimeout";
    private static final String NO_TIMEOUT = "-1";
    public static final String FURTHER_CONSTRAIN_QUERY = "Sorry, you must further constrain your query !";
    private static final String CONNECT_TIMEOUT = "300000";
    private static final String READ_TIMEOUT = "300000";
    private PacsSearchSession mSession;
    private BaseSearchSpecification mSearchSpecification;
    private HttpURLConnection mConnection;
    private InputStream mInputStream;
    private boolean mCancelled;
    private List mSearchResults;
    private boolean mSessionExpired = false;

    public PacsSearchClient(PacsSearchSession pacsSearchSession) {
        this.mSession = pacsSearchSession;
    }

    public boolean isSessionExpiredError() {
        return this.mSessionExpired;
    }

    public void cancelSearch() throws IOException {
        this.mCancelled = true;
        this.setResultCode(4);
        this.mSearchResults = null;
        this.setErrorDetails("Cancelled search");
        if (this.mInputStream != null) {
            this.mInputStream.close();
        }
    }

    private void verifyAndSetTimeoutProperties() {
        String string;
        String string2 = System.getProperty(CONNECT_TIMEOUT_KEY);
        if (string2 == null || string2.equals(NO_TIMEOUT)) {
            GlobalState.trace("Setting system property sun.net.client.defaultConnectTimeout to 300000 (was " + string2 + ")");
            System.setProperty(CONNECT_TIMEOUT_KEY, "300000");
        }
        if ((string = System.getProperty(READ_TIMEOUT_KEY)) == null || string.equals(NO_TIMEOUT)) {
            GlobalState.trace("Setting system property sun.net.client.defaultReadTimeout to 300000 (was " + string + ")");
            System.setProperty(READ_TIMEOUT_KEY, "300000");
        }
    }

    protected SearchSpecification createPatientSearchSpecification(Set set, boolean bl2) {
        String string = StringJoin.arrayJoin(set.toArray(), this.mSession.getPatientIdDelimiter());
        SearchSpecification searchSpecification = new SearchSpecification();
        SearchTerm searchTerm = new SearchTerm(string, "EQUALS", "sf0", "comparator0");
        searchSpecification.addSearchTerm(searchTerm);
        searchSpecification.setDateSelection(-1);
        searchSpecification.setNoExtendSession(bl2);
        return searchSpecification;
    }

    public void performSearch() {
        String string = "???";
        try {
            this.verifyAndSetTimeoutProperties();
            this.mCancelled = false;
            this.mSessionExpired = false;
            String string2 = this.getSearchParametersFromSpecification();
            URL uRL = this.mSession.getSearchServletUrl(string2);
            string = uRL.getHost();
            GlobalState.trace("Performing a search with the following URL: " + uRL);
            this.mConnection = (HttpURLConnection)uRL.openConnection();
            this.mConnection.setUseCaches(false);
            String string3 = this.getSearchAction();
            String string4 = this.mConnection.getContentType();
            if ("relatedSeriesSearch".equals(string3) && !CONTENT_TYPE_SEARCH_RESULTS.equals(string4)) {
                String string5 = "Server does not support the relatedSeriesSearch search action.";
                this.setResultCode(5);
                this.setErrorDetails(string5);
                this.mSearchResults = null;
                GlobalState.warning("Search action was [" + string3 + "], expected content type [" + CONTENT_TYPE_SEARCH_RESULTS + "] but got content type [" + string4 + "] instead. " + string5);
                return;
            }
            this.mInputStream = this.mConnection.getInputStream();
            if (this.mCancelled) {
                GlobalState.trace("Search client cancelled. Aborting search.");
                return;
            }
            GlobalState.trace("Obtained input stream. Parsing data...");
            InputStreamReader inputStreamReader = new InputStreamReader(this.mInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.mSearchResults = this.parseStudiesAndSeries(bufferedReader);
        }
        catch (Exception exception) {
            if (this.mCancelled) {
                GlobalState.trace("Search client cancelled. Aborting search.");
                return;
            }
            this.setResultCode(1);
            String string6 = exception.toString();
            if (string6.length() > 100) {
                this.setErrorDetails("Error connecting to server: " + string + "\n" + string6.substring(0, 97) + "...");
            } else {
                this.setErrorDetails("Error connecting to server: " + string + "\n" + string6);
            }
            GlobalState.error("Error in SearchClient: ", exception);
            this.mSearchResults = null;
        }
    }

    private List parseStudiesAndSeries(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl2 = true;
        ArrayList<Study> arrayList = new ArrayList<Study>();
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            if (bl2) {
                bl2 = false;
                if (string.startsWith(NO_TIMEOUT)) {
                    GlobalState.trace("First line starts with -1: Search returned [" + string.substring(3) + "]. Returning null.");
                    String string2 = string.substring(3);
                    this.setErrorDetails(string2);
                    if (this.isSessionExpired(string)) {
                        this.mSessionExpired = true;
                    }
                    int n3 = FURTHER_CONSTRAIN_QUERY.equals(string2) ? 3 : 2;
                    this.setResultCode(n3);
                    return null;
                }
                if (string.startsWith("-2")) {
                    GlobalState.trace("First line starts with -2: Search would have returned too many results. Returning null.");
                    this.setResultCode(3);
                    this.setErrorDetails(string.substring(3));
                    return null;
                }
            }
            if ((n2 = this.getStudySeriesNum(string)) <= 0) continue;
            Study study = new Study(string);
            arrayList.add(study);
            for (int i2 = 0; i2 < n2; ++i2) {
                string = bufferedReader.readLine();
                if (string == null) {
                    this.setResultCode(1);
                    this.setErrorDetails("Data consistency error");
                    GlobalState.error("Expected " + n2 + " series for study with UID [" + study.getValue("StuInsUID") + " but only obtained " + i2 + ".");
                    return null;
                }
                study.addSeries(new Series(string, study));
            }
        }
        if (bl2) {
            this.setResultCode(1);
            this.setErrorDetails("No data received from server");
            GlobalState.error(this.getErrorDetails() + " (returning null)");
            return null;
        }
        this.setResultCode(0);
        return arrayList;
    }

    private boolean isSessionExpired(String string) {
        return string.substring(3).equals(SessionException.SESSION_EXPIRED.getDescription());
    }

    private int getStudySeriesNum(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return n2;
        }
        return -1;
    }

    protected String getSearchParametersFromSpecification() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?UserName=" + this.mSession.getUsername());
        stringBuffer.append("&SID=" + this.mSession.getSessionId());
        stringBuffer.append("&Action=" + this.mSearchSpecification.getSearchAction());
        stringBuffer.append(this.mSearchSpecification.getSearchParametersString());
        return stringBuffer.toString();
    }

    public BaseSearchSpecification getSearchSpecification() {
        return this.mSearchSpecification;
    }

    public void setSearchSpecification(BaseSearchSpecification baseSearchSpecification) {
        this.mSearchSpecification = baseSearchSpecification;
    }

    public List getSearchResults() {
        return this.mSearchResults;
    }

    protected String getSearchAction() {
        return this.mSearchSpecification.getSearchAction();
    }
}

