/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Data.Series;
import PatientSearchLibrary.Data.Study;
import PatientSearchLibrary.Gui.SearchSession;
import PatientSearchLibrary.Search.BaseRelatedSeriesRequest;
import RuntimeTool.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelatedSeriesRequest
extends BaseRelatedSeriesRequest {
    private boolean mAllSeriesFound;

    public RelatedSeriesRequest(SearchSession searchSession, List list, Debug debug) {
        this(searchSession, list, false, debug);
    }

    public RelatedSeriesRequest(SearchSession searchSession, List list, boolean bl2, Debug debug) {
        super(searchSession, list, bl2, debug);
    }

    public boolean searchOk() {
        return this.searchResultCodeOK() && this.mAllSeriesFound;
    }

    protected List determineLoadSet(List list) {
        this.mAllSeriesFound = list != null;
        ArrayList<Series> arrayList = new ArrayList<Series>();
        Iterator iterator = this.mSeriesUidList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Series series = this.findInRelatedSeries(list, string);
            if (series != null) {
                arrayList.add(series);
                continue;
            }
            this.mAllSeriesFound = false;
            this.appendErrorMessage("Series " + string + " not found.");
        }
        return arrayList;
    }

    private Series findInRelatedSeries(List list, String string) {
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Study study = (Study)iterator.next();
            if (!study.getSeriesMap().containsKey(string)) continue;
            return (Series)study.getSeriesMap().get(string);
        }
        return null;
    }
}

