/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.Search;

import PatientSearchLibrary.Gui.GlobalState;
import PatientSearchLibrary.Search.BaseSearchSpecification;
import PatientSearchLibrary.Search.SearchTerm;
import StringUtilities.StringEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SearchSpecification
implements BaseSearchSpecification {
    public static SimpleDateFormat mDateFilterFormat = new SimpleDateFormat("yyyyMMdd");
    private List mSearchTermList = new ArrayList();
    private List mModalityList = new ArrayList();
    private int mDateSelection = 0;
    private Date mFromDate = new Date();
    private Date mToDate = new Date();
    private String mSiteCode = "";
    private boolean mSearchDicomSource = false;
    private boolean mNoExtendSession;

    public SearchSpecification(SearchSpecification searchSpecification) {
        this.mSearchTermList = new ArrayList(searchSpecification.mSearchTermList);
        this.mModalityList = new ArrayList(searchSpecification.mModalityList);
        this.mDateSelection = searchSpecification.mDateSelection;
        this.mFromDate = (Date)searchSpecification.mFromDate.clone();
        this.mToDate = (Date)searchSpecification.mToDate.clone();
        this.mSiteCode = searchSpecification.mSiteCode;
        this.mSearchDicomSource = searchSpecification.mSearchDicomSource;
        this.mNoExtendSession = searchSpecification.mNoExtendSession;
    }

    public SearchSpecification() {
    }

    public void addSearchTerm(SearchTerm searchTerm) {
        this.mSearchTermList.add(searchTerm);
    }

    public List getModalityList() {
        return this.mModalityList;
    }

    public void addModality(String string) {
        this.mModalityList.add(string);
    }

    public int getDateSelection() {
        return this.mDateSelection;
    }

    public void setDateSelection(int n2) {
        this.mDateSelection = n2;
    }

    public Date getFromDate() {
        return this.mFromDate;
    }

    public void setFromDate(Date date) {
        this.mFromDate = date;
    }

    public Date getToDate() {
        return this.mToDate;
    }

    public void setToDate(Date date) {
        this.mToDate = date;
    }

    public String getSiteCode() {
        return this.mSiteCode;
    }

    public void setSiteCode(String string) {
        this.mSiteCode = string;
    }

    public boolean isSearchDicomSource() {
        return this.mSearchDicomSource;
    }

    public void setSearchDicomSource(boolean bl2) {
        this.mSearchDicomSource = bl2;
    }

    public String getSearchParametersString() {
        String string;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.mSearchTermList.iterator();
        while (iterator.hasNext()) {
            object = (SearchTerm)iterator.next();
            string = ((SearchTerm)object).getServletFieldParameterName();
            String string2 = ((SearchTerm)object).getValue();
            String string3 = ((SearchTerm)object).getServletComparatorParameterName();
            String string4 = ((SearchTerm)object).getOperator();
            this.appendParameter(stringBuffer, string, string2);
            this.appendParameter(stringBuffer, string3, string4);
        }
        object = this.mModalityList.iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            this.appendParameter(stringBuffer, "Modality" + string, "1");
        }
        this.appendParameter(stringBuffer, "DateSelect", this.mDateSelection + "");
        if (this.mDateSelection == -2) {
            this.appendParameter(stringBuffer, "FromStr", mDateFilterFormat.format(this.mFromDate));
            this.appendParameter(stringBuffer, "ToStr", mDateFilterFormat.format(this.mToDate));
        }
        this.appendParameter(stringBuffer, "SiteFilter", this.mSiteCode);
        if (this.mSearchDicomSource) {
            this.appendParameter(stringBuffer, "searchDicomSource", "1");
        }
        if (this.mNoExtendSession) {
            this.appendParameter(stringBuffer, "noExtendSession", "1");
        }
        return stringBuffer.toString();
    }

    private void appendParameter(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("&" + string + "=" + StringEncoder.urlEncodeISO_8859_1(string2, GlobalState.getDebug()));
    }

    public String getSearchAction() {
        return "appletsearch";
    }

    public void setNoExtendSession(boolean bl2) {
        this.mNoExtendSession = bl2;
    }

    public boolean isNoExtendSession() {
        return this.mNoExtendSession;
    }

    public static class DateFilterValues {
        public static final int CUSTOM = -2;
        public static final int ALL_DATES = -1;
        public static final int TODAY = 0;
        public static final int YESTERDAY = 1;
        public static final int LAST_2_DAYS = 2;
        public static final int LAST_7_DAYS = 7;
        public static final int LAST_31_DAYS = 31;
    }

    public static class ServletSearchFields {
        public static final String DATE_SELECTION = "DateSelect";
        public static final String FROM_DATE = "FromStr";
        public static final String TO_DATE = "ToStr";
        public static final String MODALITY = "Modality";
        public static final String SITE_FILTER = "SiteFilter";
        public static final String SEARCH_DICOM_SOURCE = "searchDicomSource";
        public static final String NO_EXTEND_SESSION = "noExtendSession";
    }
}

