/*
 * Decompiled with CFR 0.152.
 */
package PatientSearchLibrary.View;

import PatientSearchLibrary.Gui.RetrievalHandler;
import PatientSearchLibrary.Retrieve.Retriever;
import PatientSearchLibrary.View.LoadRequestType;
import PatientSearchLibrary.View.SeriesViewer;
import PatientSearchLibrary.View.ViewSet;

public class ViewSetLoader
implements RetrievalHandler {
    private ViewSet mViewSet;
    private Retriever mRetriever;
    private SeriesViewer mSeriesViewer;
    private LoadRequestType mLoadRequestType;

    public ViewSetLoader(ViewSet viewSet, Retriever retriever, SeriesViewer seriesViewer, LoadRequestType loadRequestType) {
        this.mViewSet = viewSet;
        this.mRetriever = retriever;
        this.mSeriesViewer = seriesViewer;
        this.mLoadRequestType = loadRequestType;
    }

    public boolean isUserCancellable() {
        return false;
    }

    public void updateRetrievalStatus() {
        if (this.mViewSet.getOfflineElementsCount() == 0) {
            this.mRetriever.unregisterRetrievalHandler(this);
            this.mSeriesViewer.loadSeries(this.mViewSet.getSelectedSeries(), this.mLoadRequestType);
        }
    }
}

