/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import RuntimeTool.DebugManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.w3c.tidy.Tidy;

public class HtmlWorkerFixer {
    private static final String BR_TAG = "<br\\s*/?>";
    private static final String BR_AND_WHITESPACE = "\\s*(<br\\s*/?>\\s*)+";
    private static final String LEADING_HTML_WHITESPACE = "\\A\\s*(<br\\s*/?>\\s*)+";
    private static final String TRAILING_HTML_WHITESPACE = "\\s*(<br\\s*/?>\\s*)+\\Z";
    private static final Pattern HTML_WHITESPACE = Pattern.compile("\\A\\s*(<br\\s*/?>\\s*)+|\\s*(<br\\s*/?>\\s*)+\\Z", 2);

    static String fixHtml(String string) {
        String string2 = "<br />";
        String string3 = string.replaceAll("\\s*([\\n\\r]+|$)", "$1").replaceAll("<PRE>", "<FONT size=1><PRE>");
        try {
            string2 = string2 + HtmlWorkerFixer.htmlTrim(HtmlWorkerFixer.tidy(string3).replaceAll("(</h.>|</pre>)", "$1<br />").replaceAll("</?div(\\s+[^>]*)*>", "").replaceAll("<p(\\s+[^>]*)*>", "").replaceAll("</p\\s*>\\s*</td", "</td").replaceAll("</p>", "<br /><br />"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string4 = "Could not tidy up report body html. Returning text with escaped html tags. Input HTML follows JTidy errors: " + illegalArgumentException.getMessage() + "\n" + string3;
            DebugManager.getDefault().printWarning(string4);
            string2 = string2 + string3.replaceAll("<", "&lt;");
        }
        return string2;
    }

    static String htmlTrim(String string) {
        return HTML_WHITESPACE.matcher(string).replaceAll("");
    }

    static String tidy(String string) {
        Tidy tidy = new Tidy();
        tidy.setShowWarnings(false);
        tidy.setQuiet(true);
        tidy.setXHTML(true);
        tidy.setTidyMark(false);
        tidy.setXmlSpace(false);
        tidy.setDocType("omit");
        tidy.setEncloseBlockText(true);
        tidy.setBreakBeforeBR(false);
        tidy.setWord2000(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        tidy.setErrout(printWriter);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        tidy.parse((InputStream)new ByteArrayInputStream(string.getBytes()), (OutputStream)byteArrayOutputStream2);
        printWriter.flush();
        if (tidy.getParseErrors() > 0) {
            throw new IllegalArgumentException("jTidy could not process the HTML: " + byteArrayOutputStream.toString().trim());
        }
        String string2 = byteArrayOutputStream2.toString();
        string2 = string2.substring(string2.indexOf("<body>") + 6, string2.lastIndexOf("</body>"));
        return string2.trim();
    }
}

