/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import ReportViewerLibrary.Gui.InformationArea;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.Gui.SplitInformationArea;
import ReportViewerLibrary.Gui.TabbedInformationArea;
import ReportViewerXml.Order;
import ReportViewerXml.OrderHeader;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import com.intelerad.lib.process.UrlLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ReportsPane
extends JPanel {
    public static final String URL_FILE_PREFIX = "reportViewer";
    private ReportViewer mReportViewer;
    private static final int REPORTS_PANE = 0;
    private static final int IMPRESSIONS_PANE = 1;
    private static final int HISTORY_PANE = 2;
    private final ReportHyperlinkListener mReportHyperlinkListener = new ReportHyperlinkListener();
    private JEditorPane mReportsTextPane;
    private JEditorPane mImpressionsTextPane;
    private JEditorPane mHistoryTextPane;
    private InformationArea mInformationArea;
    private boolean mSplitView;
    private String mCurrentExamId;
    private String mCurrentAccessionNumber;

    public ReportsPane(ReportViewer reportViewer) {
        this.mReportViewer = reportViewer;
        this.mSplitView = this.mReportViewer.getUserPreferences().isSplitView();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), " Reports ");
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        this.setBorder(titledBorder);
        this.setLayout(new BorderLayout());
        this.guiInit();
        this.update(this.mReportViewer.getExamIdForUpdate());
    }

    private void guiInit() {
        this.mInformationArea = this.createInformationArea();
        this.addInformationPanes();
        this.removeAll();
        this.add("Center", (Component)((Object)this.mInformationArea));
    }

    private void addInformationPanes() {
        this.mInformationArea.addPane("Reports", this.getIcon("/ReportViewerLibrary/Gui/Icons/reports.png"), this.getReportPane());
        this.mInformationArea.addPane("Impressions", this.getIcon("/ReportViewerLibrary/Gui/Icons/impressions.png"), this.getImpressionsPane());
        this.mInformationArea.addPane("History", this.getIcon("/ReportViewerLibrary/Gui/Icons/history.png"), this.getHistoryPane());
    }

    private Icon getIcon(String string) {
        return this.mReportViewer.getIconCache().getImageIcon(string);
    }

    private InformationArea createInformationArea() {
        JComponent jComponent = null;
        jComponent = this.mSplitView ? new SplitInformationArea() : new TabbedInformationArea();
        return jComponent;
    }

    void changeInformationAreaView() {
        this.mSplitView = !this.mSplitView;
        this.mReportViewer.getUserPreferences().setSplitView(this.mSplitView);
        this.guiInit();
        this.update(this.mCurrentExamId);
        this.revalidate();
    }

    public void update(String string) {
        this.mCurrentExamId = string;
        Order order = (Order)this.mReportViewer.getOrderMap().get(this.mCurrentExamId);
        if (order != null) {
            this.mCurrentAccessionNumber = order.getAccession();
            this.update(this.mHistoryTextPane, order.getHistory(), 2);
            this.update(this.mImpressionsTextPane, order.getImpression(), 1);
            this.update(this.mReportsTextPane, order.getReport(), 0);
            this.mReportViewer.setExportButtonsEnabled(true);
            this.mReportViewer.enableImpression(true);
        } else {
            this.mReportViewer.setExportButtonsEnabled(false);
            this.mReportViewer.enableImpression(false);
            this.mInformationArea.enableInformationPane(0, false);
            this.mInformationArea.enableInformationPane(1, false);
            this.mInformationArea.enableInformationPane(2, false);
        }
    }

    private void update(JEditorPane jEditorPane, String string, int n2) {
        if (StringCheck.isStringBlank(string)) {
            if (n2 == 1) {
                string = "No Impressions have been submitted.";
                this.mInformationArea.enableInformationPane(n2, true);
                this.mInformationArea.setPaneIcon(n2, this.getIcon("/ReportViewerLibrary/Gui/Icons/noimpressions.png"));
            } else {
                this.mInformationArea.enableInformationPane(n2, false);
            }
            this.updateToolTipAndTab(n2, false);
        } else {
            if (n2 == 1) {
                this.mInformationArea.setPaneIcon(n2, this.getIcon("/ReportViewerLibrary/Gui/Icons/impressions.png"));
            }
            this.mInformationArea.enableInformationPane(n2, true);
            this.updateToolTipAndTab(n2, true);
        }
        jEditorPane.setText(string);
        jEditorPane.setCaretPosition(0);
    }

    private void updateToolTipAndTab(int n2, boolean bl2) {
        switch (n2) {
            case 2: {
                if (bl2) {
                    this.mInformationArea.setPaneToolTip(n2, "History");
                    this.mInformationArea.setSelectedPane(2);
                    break;
                }
                this.mInformationArea.setPaneToolTip(n2, "No history have been submitted");
                break;
            }
            case 1: {
                if (bl2) {
                    this.mInformationArea.setPaneToolTip(n2, "Impressions");
                    this.mInformationArea.setSelectedPane(1);
                    break;
                }
                this.mInformationArea.setPaneToolTip(n2, "No impressions have been submitted");
                break;
            }
            case 0: {
                if (bl2) {
                    this.mInformationArea.setPaneToolTip(n2, "Reports");
                    this.mInformationArea.setSelectedPane(0);
                    break;
                }
                this.mInformationArea.setPaneToolTip(n2, "No report have been submitted");
            }
        }
    }

    private JPanel getReportPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mReportsTextPane = new JEditorPane();
        this.mReportsTextPane.setBackground(Color.LIGHT_GRAY);
        this.mReportsTextPane.addHyperlinkListener(this.mReportHyperlinkListener);
        this.mReportsTextPane.setContentType("text/html");
        this.mReportsTextPane.setEditable(false);
        jPanel.add("Center", this.getTextAreaScrollPane(this.mReportsTextPane));
        return jPanel;
    }

    private JPanel getHistoryPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mHistoryTextPane = new JEditorPane();
        this.mHistoryTextPane.setBackground(Color.LIGHT_GRAY);
        this.mHistoryTextPane.addHyperlinkListener(this.mReportHyperlinkListener);
        this.mHistoryTextPane.setContentType("text/html");
        this.mHistoryTextPane.setEditable(false);
        jPanel.add("Center", this.getTextAreaScrollPane(this.mHistoryTextPane));
        return jPanel;
    }

    private JPanel getImpressionsPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mImpressionsTextPane = new JEditorPane();
        this.mImpressionsTextPane.setBackground(Color.LIGHT_GRAY);
        this.mImpressionsTextPane.addHyperlinkListener(this.mReportHyperlinkListener);
        this.mImpressionsTextPane.setContentType("text/html");
        this.mImpressionsTextPane.setEditable(false);
        jPanel.add("Center", this.getTextAreaScrollPane(this.mImpressionsTextPane));
        return jPanel;
    }

    private JScrollPane getTextAreaScrollPane(JEditorPane jEditorPane) {
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 30);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = Math.min(dimension.width, 500);
        dimension.height = Math.min(dimension.height, 300);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    public Order getCurrentOrder() {
        return (Order)this.mReportViewer.getOrderMap().get(this.mCurrentExamId);
    }

    public OrderHeader getCurrentOrderHeader() {
        return (OrderHeader)this.mReportViewer.getOrderHeaderMap().get(this.mCurrentExamId);
    }

    public String getCurrentExamId() {
        return this.mCurrentExamId;
    }

    public String getCurrentAccessionNumber() {
        return this.mCurrentAccessionNumber;
    }

    class ReportHyperlinkListener
    implements HyperlinkListener {
        ReportHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                UrlLauncher urlLauncher = new UrlLauncher(hyperlinkEvent.getURL(), ReportsPane.URL_FILE_PREFIX, true);
                try {
                    urlLauncher.launch();
                }
                catch (IOException iOException) {
                    DebugManager.getDefault().printException("Could not launch URL: " + hyperlinkEvent.getURL(), iOException);
                }
            }
        }
    }
}

