/*
 * Decompiled with CFR 0.152.
 */
package Viewer.DicomPrint.Composer;

import DataModels.CompositeDataModel;
import DataModels.DataModelBuilder;
import DataModels.MapDataModel;
import DataModels.ModelProperty;
import InteleViewer.GB;
import InteleViewer.LU;
import InteleViewer.fL;
import InteleViewer.qc;
import com.intelerad.datamodels.dicom.print.DicomPrintRepository;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.dicom.print.Printer;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrintComposerModel
extends MapDataModel {
    private static final String CUSTOM_PRINT_PROTOCOL_NAME = "<custom>";
    public static final ModelProperty CurrentPrinter;
    public static final ModelProperty AvailablePrinters;
    public static final ModelProperty CurrentProtocol;
    public static final ModelProperty CompatibleProtocols;
    public static final ModelProperty CurrentPrinterConfiguration;
    public static final ModelProperty OverwriteProtocolButtonEnabled;
    public static final ModelProperty RemoveProtocolButtonEnabled;
    public static final ModelProperty AllowTrueSizePrinting;
    public static final ModelProperty LastNonCustomProtocol;
    private static final List PROPERTIES;
    private final PrintProtocol mWorkingProtocol = new PrintProtocol();
    private final qc mPrinterConfigurationListener = new qc(this, null);
    private final LU mProtocolCustomizationListener = new LU(this, null);
    private final DicomPrintRepository mRepository = fL.a();
    private PrintProtocol mCustomProtocol = null;
    public static Class class$com$intelerad$datamodels$dicom$print$Printer;
    public static Class class$java$util$List;
    public static Class class$com$intelerad$datamodels$dicom$print$PrintProtocol;
    public static Class class$com$intelerad$datamodels$dicom$print$PrinterConfiguration;
    public static Class class$java$lang$Boolean;
    public static final boolean $assertionsDisabled;
    public static Class class$Viewer$DicomPrint$Composer$PrintComposerModel;

    public PrintComposerModel() {
        this.mRepository.addPropertyChangeListener(new GB(this, null));
        this.mWorkingProtocol.addPropertyChangeListener(this.mProtocolCustomizationListener);
        this.setupCurrentPrinter();
        this.setupCurrentProtocol();
        this.setProperty(AllowTrueSizePrinting, Boolean.FALSE);
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        if (modelProperty == AvailablePrinters) {
            return this.getAvailablePrinters();
        }
        if (modelProperty == CompatibleProtocols) {
            return this.getCompatibleProtocols();
        }
        if (modelProperty == CurrentPrinterConfiguration) {
            return this.getCurrentConfiguration();
        }
        if (modelProperty == OverwriteProtocolButtonEnabled) {
            return new Boolean(this.isOverwriteProtocolButtonEnabled());
        }
        if (modelProperty == RemoveProtocolButtonEnabled) {
            return new Boolean(this.isRemoveProtocolButtonEnabled());
        }
        return super.getProperty(modelProperty);
    }

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        if (modelProperty == AvailablePrinters || modelProperty == CompatibleProtocols || modelProperty == CurrentPrinterConfiguration || modelProperty == OverwriteProtocolButtonEnabled || modelProperty == RemoveProtocolButtonEnabled) {
            throw new IllegalArgumentException(modelProperty.getName() + " is a read-only property");
        }
        if (modelProperty == CurrentPrinter) {
            this.setCurrentPrinter((Printer)object);
        }
        if (modelProperty == CurrentProtocol) {
            this.setCurrentProtocol((PrintProtocol)object);
            return;
        }
        super.setProperty(modelProperty, object);
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public Printer getCurrentPrinter() {
        return (Printer)this.getProperty(CurrentPrinter);
    }

    public PrintProtocol getWorkingProtocol() {
        return this.mWorkingProtocol;
    }

    public PrintProtocol getLastNonCustomProtocol() {
        return (PrintProtocol)this.getProperty(LastNonCustomProtocol);
    }

    private PrinterConfiguration getCurrentConfiguration() {
        return this.getCurrentPrinter().getConfiguration();
    }

    private void setCurrentPrinter(Printer printer) {
        Printer printer2 = this.getCurrentPrinter();
        PrinterConfiguration printerConfiguration = null;
        if (printer2 != null) {
            printer2.removePropertyChangeListener(Printer.Configuration, this.mPrinterConfigurationListener);
            printerConfiguration = printer2.getConfiguration();
        }
        printer.addPropertyChangeListener(Printer.Configuration, this.mPrinterConfigurationListener);
        super.setProperty(CurrentPrinter, printer);
        this.firePropertyChange(CurrentPrinterConfiguration, printerConfiguration);
        this.updateCompatibleProtocols();
        this.removeCustomProtocol();
    }

    private void setCurrentProtocol(PrintProtocol printProtocol) {
        super.setProperty(CurrentProtocol, printProtocol);
        if (this.mCustomProtocol != printProtocol) {
            this.setProperty(LastNonCustomProtocol, printProtocol);
        }
        this.setupWorkingProtocol();
        this.checkProtocolButtonsEnabled();
    }

    private void setCustomProtocol(PrintProtocol printProtocol) {
        List list = this.getCompatibleProtocols();
        this.mCustomProtocol = printProtocol;
        this.firePropertyChange(CompatibleProtocols, list);
        this.checkProtocolButtonsEnabled();
    }

    private void setupCurrentPrinter() {
        List list = this.getAvailablePrinters();
        this.setProperty(CurrentPrinter, list.get(0));
    }

    private void setupCurrentProtocol() {
        this.setCurrentProtocol((PrintProtocol)this.getCompatibleProtocols().get(0));
    }

    private void setupWorkingProtocol() {
        PrintProtocol printProtocol = this.getCurrentProtocol();
        PrintProtocol printProtocol2 = this.getCurrentConfiguration().getDefaultProtocol();
        LU.a(this.mProtocolCustomizationListener);
        DataModelBuilder.copyValues(this.mWorkingProtocol, new CompositeDataModel(printProtocol, printProtocol2));
        LU.b(this.mProtocolCustomizationListener);
    }

    private void updateAvailablePrinters(PropertyChangeEvent propertyChangeEvent) {
        if (!this.getAvailablePrinters().contains(this.getCurrentPrinter())) {
            this.setupCurrentPrinter();
        }
        this.firePropertyChange(AvailablePrinters, propertyChangeEvent.getOldValue());
    }

    private void updateCompatibleProtocols() {
        if (this.hasCustomProtocol() && !this.getCurrentConfiguration().isValid(this.mCustomProtocol)) {
            this.removeCustomProtocol();
        }
        this.firePropertyChange(CompatibleProtocols, null);
        if (!this.getCompatibleProtocols().contains(this.getCurrentProtocol())) {
            this.setupCurrentProtocol();
        }
    }

    private void updateCustomProtocol() {
        if (!this.hasCustomProtocol()) {
            this.setCustomProtocol(new PrintProtocol());
        }
        PrintProtocol printProtocol = this.mCustomProtocol;
        DataModelBuilder.copyValues(printProtocol, this.getWorkingProtocol());
        printProtocol.setName(this.getLastNonCustomProtocol().getName() + " " + CUSTOM_PRINT_PROTOCOL_NAME);
        this.setCurrentProtocol(printProtocol);
    }

    private List getAvailablePrinters() {
        return this.mRepository.getPrinters();
    }

    public List getCompatibleProtocols() {
        List list = this.mRepository.getProtocols(this.getCurrentConfiguration());
        if (this.hasCustomProtocol()) {
            list.add(0, this.mCustomProtocol);
        }
        return list;
    }

    private PrintProtocol getCurrentProtocol() {
        return (PrintProtocol)this.getProperty(CurrentProtocol);
    }

    private PrintProtocol getCustomProtocol() {
        return this.mCustomProtocol;
    }

    public boolean isCustomProtocolSelected() {
        return this.getCurrentProtocol() == this.mCustomProtocol;
    }

    public boolean hasCustomProtocol() {
        return this.mCustomProtocol != null;
    }

    private boolean isOverwriteProtocolButtonEnabled() {
        return this.mCustomProtocol == this.getCurrentProtocol();
    }

    private boolean isRemoveProtocolButtonEnabled() {
        return this.getCurrentProtocol() != this.getCurrentConfiguration().getDefaultProtocol();
    }

    private void checkProtocolButtonsEnabled() {
        this.firePropertyChange(OverwriteProtocolButtonEnabled, null);
        this.firePropertyChange(RemoveProtocolButtonEnabled, null);
    }

    public void overwriteCustomizedProtocol() {
        if (this.getCurrentProtocol() != this.mCustomProtocol) {
            return;
        }
        PrintProtocol printProtocol = this.getLastNonCustomProtocol();
        if (printProtocol == this.getCurrentConfiguration().getDefaultProtocol()) {
            PrintProtocol printProtocol2 = this.getCurrentConfiguration().getDefaultProtocol();
            String string = printProtocol2.getName();
            DataModelBuilder.copyValues(printProtocol2, this.mWorkingProtocol);
            printProtocol2.setName(string);
            this.setCurrentProtocol(printProtocol2);
            this.removeCustomProtocol();
            fL.a();
            return;
        }
        this.mRepository.removePrintProtocol(printProtocol);
        this.saveCustomProtocol(printProtocol.getName());
    }

    public void saveCustomProtocol(String string) {
        PrintProtocol printProtocol = new PrintProtocol(this.getWorkingProtocol());
        printProtocol.setName(string);
        this.mRepository.addPrintProtocol(printProtocol);
        this.setCurrentProtocol(printProtocol);
        this.removeCustomProtocol();
    }

    private void removeCustomProtocol() {
        this.setCustomProtocol(null);
    }

    public void removeSelectedProtocol() {
        if (!$assertionsDisabled && this.getCurrentProtocol() == this.getCurrentConfiguration().getDefaultProtocol()) {
            throw new AssertionError();
        }
        if (this.isCustomProtocolSelected()) {
            this.removeCustomProtocol();
        } else {
            this.mRepository.removePrintProtocol(this.getCurrentProtocol());
        }
        this.setCurrentProtocol((PrintProtocol)this.getCompatibleProtocols().get(0));
    }

    public static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static void access$500(PrintComposerModel printComposerModel, PropertyChangeEvent propertyChangeEvent) {
        printComposerModel.updateAvailablePrinters(propertyChangeEvent);
    }

    public static void access$600(PrintComposerModel printComposerModel) {
        printComposerModel.updateCompatibleProtocols();
    }

    public static PrintProtocol access$700(PrintComposerModel printComposerModel) {
        return printComposerModel.getCurrentProtocol();
    }

    public static void access$800(PrintComposerModel printComposerModel) {
        printComposerModel.setupCurrentProtocol();
    }

    public static void access$900(PrintComposerModel printComposerModel) {
        printComposerModel.updateCustomProtocol();
    }

    static {
        $assertionsDisabled = !(class$Viewer$DicomPrint$Composer$PrintComposerModel == null ? (class$Viewer$DicomPrint$Composer$PrintComposerModel = PrintComposerModel.class$("Viewer.DicomPrint.Composer.PrintComposerModel")) : class$Viewer$DicomPrint$Composer$PrintComposerModel).desiredAssertionStatus();
        CurrentPrinter = new ModelProperty(class$com$intelerad$datamodels$dicom$print$Printer == null ? (class$com$intelerad$datamodels$dicom$print$Printer = PrintComposerModel.class$("com.intelerad.datamodels.dicom.print.Printer")) : class$com$intelerad$datamodels$dicom$print$Printer, "CurrentPrinter", "Printer");
        AvailablePrinters = new ModelProperty(class$java$util$List == null ? (class$java$util$List = PrintComposerModel.class$("java.util.List")) : class$java$util$List, "AvailablePrinters", "Available Printers");
        CurrentProtocol = new ModelProperty(class$com$intelerad$datamodels$dicom$print$PrintProtocol == null ? (class$com$intelerad$datamodels$dicom$print$PrintProtocol = PrintComposerModel.class$("com.intelerad.datamodels.dicom.print.PrintProtocol")) : class$com$intelerad$datamodels$dicom$print$PrintProtocol, "CurrentProtocol", "Protocol");
        CompatibleProtocols = new ModelProperty(class$java$util$List == null ? (class$java$util$List = PrintComposerModel.class$("java.util.List")) : class$java$util$List, "CompatibleProtocols", "Compatible Protocols");
        CurrentPrinterConfiguration = new ModelProperty(class$com$intelerad$datamodels$dicom$print$PrinterConfiguration == null ? (class$com$intelerad$datamodels$dicom$print$PrinterConfiguration = PrintComposerModel.class$("com.intelerad.datamodels.dicom.print.PrinterConfiguration")) : class$com$intelerad$datamodels$dicom$print$PrinterConfiguration, "CurrentPrinterConfiguration", "Configuration");
        OverwriteProtocolButtonEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrintComposerModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "OverwriteProtocolButtonEnabled", "overwrite protocol enabled");
        RemoveProtocolButtonEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrintComposerModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "RemoveProtocolButtonEnabled", "remove protocol enabled");
        AllowTrueSizePrinting = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrintComposerModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "AllowTrueSizePrinting", "for components enable state");
        LastNonCustomProtocol = new ModelProperty(class$com$intelerad$datamodels$dicom$print$PrintProtocol == null ? (class$com$intelerad$datamodels$dicom$print$PrintProtocol = PrintComposerModel.class$("com.intelerad.datamodels.dicom.print.PrintProtocol")) : class$com$intelerad$datamodels$dicom$print$PrintProtocol, "LastNonCustomProtocol", "last non custom protocol");
        PROPERTIES = Collections.unmodifiableList(Arrays.asList(CurrentPrinter, AvailablePrinters, CurrentProtocol, CompatibleProtocols, CurrentPrinterConfiguration, OverwriteProtocolButtonEnabled, RemoveProtocolButtonEnabled, LastNonCustomProtocol, AllowTrueSizePrinting));
    }
}

