/*
 * Decompiled with CFR 0.152.
 */
package Viewer.Imaging.Dataset;

import InteleViewer.Qd;

public class PixelArray
extends Qd {
    private static boolean mAlreadyInitialized = false;
    private static volatile int mFinalizeWithoutReleaseCount = 0;
    private long mNativePointer = 0L;

    public static synchronized void initialize() {
        if (mAlreadyInitialized) {
            return;
        }
        System.loadLibrary("InteleViewerJNI");
        PixelArray.nativeInitClass();
        mAlreadyInitialized = true;
    }

    public static int getFinalizeWithoutReleaseCount() {
        return mFinalizeWithoutReleaseCount;
    }

    private static native void nativeInitClass();

    public static native long getTotalAllocatedBytes();

    public static native int getTotalAllocatedBuffers();

    public PixelArray(int n2) {
        super(n2);
    }

    public PixelArray(short[] sArray) {
        this(sArray.length);
        this.allocate();
        this.setPixelValues(sArray, 0, 0, sArray.length);
    }

    public PixelArray(PixelArray pixelArray) {
        this(pixelArray.size());
        this.allocate();
        pixelArray.copyPixels(0, 1, this, 0, 1, pixelArray.size(), 1);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public synchronized void allocate() {
        if (this.mNativePointer != 0L) {
            return;
        }
        this.mNativePointer = this.nativeAllocate(this.mImageSize);
    }

    public synchronized void release() {
        long l2 = this.mNativePointer;
        this.mNativePointer = 0L;
        this.nativeRelease(l2);
    }

    private native long nativeAllocate(int var1);

    private native void nativeRelease(long var1);

    public void finalize() throws Throwable {
        if (this.isAllocated()) {
            this.release();
            ++mFinalizeWithoutReleaseCount;
        }
        super.finalize();
    }

    public synchronized boolean isAllocated() {
        return this.mNativePointer != 0L;
    }

    public synchronized native void setPixelValues(short[] var1, int var2, int var3, int var4);

    public synchronized short[] getPixelValues(int n2, short[] sArray, int n3, int n4) {
        this.nativeGetPixelValues(n2, sArray, n3, n4);
        return sArray;
    }

    private native void nativeGetPixelValues(int var1, short[] var2, int var3, int var4);

    public synchronized native void copyPixelsToShortArray(long var1);

    public synchronized native void copyPixelsFromShortArray(long var1);

    public synchronized native int getPixel(int var1);

    public synchronized native void setPixel(int var1, short var2);

    public synchronized native void fill(short var1);

    public synchronized native void setReplicatedPixelValues(short[] var1, int var2, int var3, int var4, int var5);

    public synchronized native void reverseColumns(int var1, int var2, int var3);

    public synchronized native void reverseRows(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(int n2, int n3, Qd qd2, int n4, int n5, int n6, int n7) {
        Qd qd3;
        Qd qd4;
        int n8;
        if (qd2 == null) {
            throw new NullPointerException("Destination cannot be null");
        }
        if (!(qd2 instanceof PixelArray)) {
            throw new UnsupportedOperationException("Can only copy into a PixelArray");
        }
        int n9 = this.hashCode();
        if (n9 < (n8 = qd2.hashCode())) {
            qd4 = this;
            qd3 = qd2;
        } else {
            if (n9 == n8 && this != qd2) {
                throw new IllegalStateException("Two distinct PixelArrays should not have the same hashCode.");
            }
            qd4 = qd2;
            qd3 = this;
        }
        Qd qd5 = qd3;
        Qd qd6 = qd4;
        synchronized (qd6) {
            Qd qd7 = qd5;
            synchronized (qd7) {
                this.nativeCopyPixels(n2, n3, (PixelArray)qd2, n4, n5, n6, n7);
            }
            return;
        }
    }

    private native void nativeCopyPixels(int var1, int var2, PixelArray var3, int var4, int var5, int var6, int var7);

    public synchronized native void copyPixelsToInt(int var1, int var2, int[] var3, int var4, int var5, int var6, int var7);

    public void copyPixelsToShort(int n2, int n3, short[] sArray, int n4, int n5, int n6, int n7) {
        this.copyPixelsToShort(n2, n3, sArray, n4, n5, n6, n7, new int[n7 * n6]);
    }

    public void copyPixelsToShort(int n2, int n3, short[] sArray, int n4, int n5, int n6, int n7, int[] nArray) {
        this.copyPixelsToInt(n2, n3, nArray, n4, n5, n6, n7);
        int n8 = n6 * n7;
        for (int i2 = 0; i2 < n8; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
    }

    static {
        PixelArray.initialize();
    }
}

