/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.Association;
import J2cProtocol.ConnectRequestMessage;
import J2cProtocol.Message;
import RuntimeTool.Debug;
import WaveletClientLibrary.ClientMessageFactory;
import WaveletClientLibrary.PrefixLog;
import WaveletClientLibrary.ProxyClient;

public abstract class AbstractWaveletClient
extends Association {
    private String mSeriesUid;
    private String mClientId;
    private String mClientAddress;
    private String mUsername;
    private String mSessionId;
    private PrefixLog mPrefixLog;

    public AbstractWaveletClient(ProxyClient proxyClient, String string) {
        super(proxyClient.getInputStream(), proxyClient.getOutputStream(), new ClientMessageFactory());
        this.mClientId = proxyClient.getConnectionParameters().getClientId();
        this.mClientAddress = proxyClient.getLocalAddress();
        this.mUsername = proxyClient.getConnectionParameters().getUsername();
        this.mSessionId = proxyClient.getConnectionParameters().getSessionId();
        this.mSeriesUid = string;
        this.mPrefixLog = new PrefixLog(new Debug("WaveletClient", "stdout", "TRACE"), string + ": ");
    }

    public void setDebug(Debug debug) {
        this.mPrefixLog = new PrefixLog(debug, this.mSeriesUid + ": ");
    }

    public void setDebug(PrefixLog prefixLog) {
        this.mPrefixLog = prefixLog;
    }

    public String getSeriesUid() {
        return this.mSeriesUid;
    }

    protected Message createConnectRequestMessage() {
        ConnectRequestMessage connectRequestMessage = new ConnectRequestMessage(this.mClientId, this.mUsername, this.mSessionId, this.mClientAddress);
        return connectRequestMessage;
    }

    public void debug(String string) {
        this.mPrefixLog.debug(string);
    }

    public void trace(String string) {
        this.mPrefixLog.trace(string);
    }

    public void error(String string, Throwable throwable) {
        this.mPrefixLog.error(string, throwable);
    }
}

