/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.Association;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.KduIncrementMessage;
import WaveletClientLibrary.DataCacheContainer;
import WaveletClientLibrary.DataCacheException;
import WaveletClientLibrary.WaveletClient;

public class ClientKduIncrementMessage
extends KduIncrementMessage {
    public ClientKduIncrementMessage(byte[] byArray) {
        super(byArray);
    }

    public void process(Association association) throws J2cProtocolException {
        WaveletClient waveletClient = (WaveletClient)association;
        int n2 = this.getImageIndex();
        byte[] byArray = this.getBufferReference();
        int n3 = this.getCurrentBufferLength();
        DataCacheContainer dataCacheContainer = waveletClient.getDataCache(n2);
        try {
            dataCacheContainer.transferIncrements(byArray, n3);
            if (dataCacheContainer.needImageUpdate()) {
                waveletClient.requestUpdateImage(n2);
                dataCacheContainer.updateThresholdForNextUpdate();
            }
        }
        catch (DataCacheException dataCacheException) {
            waveletClient.error("Caught exception - diconnecting: " + dataCacheException, dataCacheException);
            waveletClient.setDisconnectMessage(this.createDisconnectMessage(2, dataCacheException));
        }
    }
}

