/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.J2cProtocolException;
import J2cProtocol.RegionOfInterest;
import WaveletClientLibrary.DataCacheException;
import WaveletClientLibrary.RoiState;
import WaveletClientLibrary.WaveletClientManager;
import WaveletClientLibrary.WritableImageBuffer;
import java.util.ConcurrentModificationException;
import kdu_jni.KduException;
import kdu_jni.Kdu_cache;
import kdu_jni.Kdu_codestream;
import kdu_jni.Kdu_compressed_source;
import kdu_jni.Kdu_coords;
import kdu_jni.Kdu_decoder;
import kdu_jni.Kdu_dims;
import kdu_jni.Kdu_global;
import kdu_jni.Kdu_line_buf;
import kdu_jni.Kdu_pull_ifc;
import kdu_jni.Kdu_resolution;
import kdu_jni.Kdu_sample_allocator;
import kdu_jni.Kdu_synthesis;
import kdu_jni.Kdu_tile;
import kdu_jni.Kdu_tile_comp;

public class DataCacheContainer {
    private static final double QUALITY_STEP = 0.125;
    private static final double INITIAL_QUALITY = 0.125;
    private static final double MAXIMUM_QUALITY = 0.98;
    private static final double UPDATE_FRACTION_THRESHOLD_CLOSE_TO_ONE = 0.75;
    private static final int SIZE_OF_SHORT = 2;
    private static final int MAXIMUM_BIT_DEPTH = 16;
    private static final double DEFAULT_SCALE = 1.0;
    private static final double DEFAULT_OFFSET = 0.0;
    private int mImageIndex;
    private WaveletClientManager mWaveletClientManager;
    private Kdu_cache mCache = null;
    private Kdu_codestream mCodestream = null;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mNumberOfImageComponents = 0;
    private int mMaximumDiscardedResolutionLevels = 0;
    private RegionOfInterest mRoi = null;
    private RoiState mRoiState = RoiState.REQUESTED;
    private volatile boolean mImageComplete = false;
    private Object mLockForRoiRequests = new Object();
    private Object mLockForImageQuality = new Object();
    private long mTotalBytesTransferred = 0L;
    private long mIncrementBytesTransferred = 0L;
    private long mThresholdForNextUpdate = 0L;
    private boolean mFinishedHeaderPhase = false;
    private double mQualityScaling = 1.0;
    private double mUpdateFactor = 2.0;
    private long mFirstImageBytes = 0L;
    private long mJ2cFileSize = 1L;
    private long mUncompressedImageSize = Long.MAX_VALUE;
    private Thread mOwnerThread = null;

    protected DataCacheContainer(WaveletClientManager waveletClientManager, int n2, int n3) throws DataCacheException {
        if (n3 != 1) {
            throw new DataCacheException("Only 1 tile currently supported: number of tiles = " + n3);
        }
        this.mWaveletClientManager = waveletClientManager;
        this.mImageIndex = n2;
        this.mCache = new Kdu_cache();
        try {
            this.mCache.Open(n3);
        }
        catch (KduException kduException) {
            DataCacheException dataCacheException = new DataCacheException(kduException.toString());
            dataCacheException.setStackTrace(kduException.getStackTrace());
            throw dataCacheException;
        }
        this.checkThread();
    }

    private void checkThread() {
        if (this.mOwnerThread == null) {
            this.mOwnerThread = Thread.currentThread();
            return;
        }
        if (Thread.currentThread() != this.mOwnerThread && this.mOwnerThread.isAlive()) {
            throw new ConcurrentModificationException("Attempted to use DataCacheContainer from outside of constructing thread");
        }
    }

    public Kdu_cache getKduCache() {
        return this.mCache;
    }

    public Kdu_codestream getKduCodestream() {
        return this.mCodestream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJ2cFileSize(long l2) {
        if (l2 > 0L) {
            Object object = this.mLockForImageQuality;
            synchronized (object) {
                this.mJ2cFileSize = l2;
            }
        }
    }

    protected void transferHeaders(byte[] byArray, int n2) throws DataCacheException {
        this.checkThread();
        if (this.mFinishedHeaderPhase) {
            return;
        }
        try {
            if (!this.mCache.Transfer_headers(byArray, n2)) {
                throw new DataCacheException("KDU cache transfer headers failed");
            }
            this.mTotalBytesTransferred += (long)n2;
        }
        catch (KduException kduException) {
            DataCacheException dataCacheException = new DataCacheException(kduException.toString());
            dataCacheException.setStackTrace(kduException.getStackTrace());
            throw dataCacheException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishHeaderPhase() throws DataCacheException {
        this.checkThread();
        if (this.mFinishedHeaderPhase) {
            return;
        }
        this.mFinishedHeaderPhase = true;
        try {
            if (!this.mCache.Finish_header_phase()) {
                throw new DataCacheException("KDU cache finish_header_phase failed");
            }
            this.mCodestream = new Kdu_codestream();
            this.mCodestream.Create((Kdu_compressed_source)this.mCache);
            DataCacheContainer dataCacheContainer = null;
            if (this.mWaveletClientManager != null) {
                dataCacheContainer = this.mWaveletClientManager.getFirstDataCache();
            }
            if (dataCacheContainer != null && dataCacheContainer.isOpen()) {
                this.mCodestream.Share_buffering(dataCacheContainer.getKduCodestream());
            } else if (this.mWaveletClientManager != null) {
                this.mWaveletClientManager.setFirstDataCache(this);
            }
            this.mCodestream.Set_persistent();
            this.mCodestream.Apply_input_restrictions(0, 0, 0, 0, null);
            int n2 = this.mCodestream.Get_num_components();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.mCodestream.Get_bit_depth(i2) <= 16) continue;
                throw new DataCacheException("Only support bit depths <= 16");
            }
            this.saveDimensionInfo();
            this.mMaximumDiscardedResolutionLevels = this.mCodestream.Get_min_dwt_levels();
            this.mUncompressedImageSize = this.getWidth() * this.getHeight() * n2 * 2;
            if (this.mUncompressedImageSize <= 0L) {
                this.mUncompressedImageSize = 1L;
            }
            Object object = this.mLockForRoiRequests;
            synchronized (object) {
                if (this.mRoi != null) {
                    this.mRoi.setNumberOfImageComponents(this.mCodestream.Get_num_components());
                    if (this.mRoi.getWidth() == 0 && this.mRoi.getHeight() == 0) {
                        this.mRoi.setWidth(this.getWidth());
                        this.mRoi.setHeight(this.getHeight());
                    }
                }
            }
        }
        catch (KduException kduException) {
            DataCacheException dataCacheException = new DataCacheException(kduException.toString());
            dataCacheException.setStackTrace(kduException.getStackTrace());
            throw dataCacheException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferIncrements(byte[] byArray, int n2) throws DataCacheException {
        if (this.isImageComplete()) {
            return;
        }
        this.checkThread();
        if (!this.isOpen()) {
            throw new DataCacheException("DataCacheContainer is not in the correct state to transfer increments.");
        }
        try {
            if (!this.mCache.Transfer_increments(byArray, n2)) {
                throw new DataCacheException("KDU cache transfer increments failed");
            }
            Object object = this.mLockForImageQuality;
            synchronized (object) {
                this.mTotalBytesTransferred += (long)n2;
                this.mIncrementBytesTransferred += (long)(n2 - this.countPrefixBytes(byArray, n2) - 1);
            }
        }
        catch (KduException kduException) {
            DataCacheException dataCacheException = new DataCacheException(kduException.toString());
            dataCacheException.setStackTrace(kduException.getStackTrace());
            throw dataCacheException;
        }
    }

    private int countPrefixBytes(byte[] byArray, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2 && n4 < 3; ++n3) {
            if (byArray[n3] >= 0) continue;
            ++n4;
        }
        return n3;
    }

    public boolean isOpen() {
        this.checkThread();
        boolean bl2 = false;
        try {
            if (this.mCache != null && this.mCodestream != null) {
                bl2 = this.mCache.Is_open() && this.mCodestream.Exists();
            }
        }
        catch (KduException kduException) {
            // empty catch block
        }
        return bl2;
    }

    /*
     * Loose catch block
     */
    public void copyImage(WritableImageBuffer writableImageBuffer, int n2, double d2, double d3) throws DataCacheException {
        block39: {
            int n3;
            int n4;
            int n5;
            this.checkThread();
            if (!this.isOpen()) {
                throw new DataCacheException("Kdu codestream is not open");
            }
            int n6 = this.getWidth();
            int n7 = this.getHeight();
            int n8 = this.getNumberOfImageComponents();
            int n9 = 1;
            if (n8 != n2) {
                if (n8 != 1) {
                    throw new DataCacheException("Mismatch in number of components: Cache has " + n8 + ", image has " + n2);
                }
                n9 = n2;
            }
            if (writableImageBuffer.size() != n6 * n7 * n8 * n9) {
                throw new DataCacheException("Incorrect image buffer size = " + writableImageBuffer.size() + ", expected " + n6 + " x " + n7 + " x " + n2 + " x " + n9);
            }
            Kdu_tile kdu_tile = null;
            Kdu_pull_ifc[] kdu_pull_ifcArray = new Kdu_pull_ifc[n8];
            for (int i2 = 0; i2 < n8; ++i2) {
                kdu_pull_ifcArray[i2] = null;
            }
            Kdu_sample_allocator kdu_sample_allocator = null;
            int n10 = this.mCodestream.Get_bit_depth(0);
            if (n10 > 16) {
                throw new DataCacheException("Cannot handle bit depths > 16");
            }
            Kdu_coords kdu_coords = new Kdu_coords();
            kdu_coords.Set_x(0);
            kdu_coords.Set_y(0);
            kdu_tile = this.mCodestream.Open_tile(kdu_coords);
            boolean bl2 = n8 >= 3 && kdu_tile.Get_ycc();
            kdu_sample_allocator = new Kdu_sample_allocator();
            Kdu_tile_comp[] kdu_tile_compArray = new Kdu_tile_comp[n8];
            Kdu_line_buf[] kdu_line_bufArray = new Kdu_line_buf[n8];
            Kdu_dims kdu_dims = null;
            for (n5 = 0; n5 < n8; ++n5) {
                kdu_tile_compArray[n5] = kdu_tile.Access_component(n5);
                n4 = kdu_tile_compArray[n5].Get_reversible();
                Kdu_resolution kdu_resolution = kdu_tile_compArray[n5].Access_resolution();
                Kdu_dims kdu_dims2 = new Kdu_dims();
                kdu_resolution.Get_dims(kdu_dims2);
                if (n5 == 0) {
                    n3 = kdu_dims2.Access_size().Get_x();
                    int n11 = kdu_dims2.Access_size().Get_y();
                    if (n3 != n6 || n11 != n7) {
                        throw new DataCacheException("Tile dimensions must match the codestream dimensions: tile width = " + n3 + ", tile height = " + n11 + " codestream width = " + n6 + " codestream height = " + n7);
                    }
                    kdu_dims = kdu_dims2;
                } else if (!kdu_dims2.Equals(kdu_dims)) {
                    throw new DataCacheException("All image components must have the same dimensions");
                }
                kdu_line_bufArray[n5] = new Kdu_line_buf();
                n3 = 0;
                kdu_line_bufArray[n5].Pre_create(kdu_sample_allocator, n6, n4 != 0, n3 != 0);
                kdu_pull_ifcArray[n5] = kdu_resolution.Which() == 0 ? new Kdu_decoder(kdu_resolution.Access_subband(0), kdu_sample_allocator, n3 != 0) : new Kdu_synthesis(kdu_resolution, kdu_sample_allocator, n3 != 0);
            }
            kdu_sample_allocator.Finalize();
            for (n5 = 0; n5 < n8; ++n5) {
                kdu_line_bufArray[n5].Create();
            }
            int[] nArray = new int[n6];
            n4 = 1 << n10 - 1;
            int n12 = (1 << n10) - 1;
            int n13 = 0;
            n3 = d2 != 1.0 || d3 != 0.0 ? 1 : 0;
            short[] sArray = new short[n8 * n6];
            for (int i3 = 0; i3 < n7; ++i3) {
                int n14;
                for (n14 = 0; n14 < n8; ++n14) {
                    kdu_pull_ifcArray[n14].Pull(kdu_line_bufArray[n14], true);
                }
                if (bl2) {
                    Kdu_global.Kdu_convert_ycc_to_rgb((Kdu_line_buf)kdu_line_bufArray[0], (Kdu_line_buf)kdu_line_bufArray[1], (Kdu_line_buf)kdu_line_bufArray[2], (int)-1);
                }
                for (n14 = 0; n14 < n8; ++n14) {
                    int n15 = kdu_line_bufArray[n14].Get_width();
                    kdu_line_bufArray[n14].Get_ints(nArray, 0, n15);
                    for (int i4 = 0; i4 < n15; ++i4) {
                        int n16 = nArray[i4] + n4;
                        if (n3 != 0) {
                            n16 = (int)Math.round((double)n16 * d2 + d3);
                        }
                        if (n16 > n12) {
                            n16 = n12;
                        }
                        if (n16 < n13) {
                            n16 = n13;
                        }
                        sArray[i4 * n8 + n14] = (short)n16;
                    }
                }
                n14 = n6 * n8 * n9;
                writableImageBuffer.setImagePixels(sArray, i3 * n14, n14, n9);
            }
            Object var32_36 = null;
            KduException kduException = null;
            for (int i5 = 0; i5 < n8; ++i5) {
                try {
                    if (kdu_pull_ifcArray[i5] == null) continue;
                    kdu_pull_ifcArray[i5].Destroy();
                    continue;
                }
                catch (KduException kduException2) {
                    kduException = kduException2;
                }
            }
            try {
                if (kdu_tile != null) {
                    kdu_tile.Close();
                }
            }
            catch (KduException kduException3) {
                kduException = kduException3;
            }
            if (kdu_sample_allocator != null) {
                kdu_sample_allocator.finalize();
            }
            if (kduException != null) {
                throw new DataCacheException(kduException.toString());
            }
            break block39;
            {
                catch (KduException kduException4) {
                    DataCacheException dataCacheException = new DataCacheException(kduException4.toString());
                    dataCacheException.setStackTrace(kduException4.getStackTrace());
                    throw dataCacheException;
                }
            }
            catch (Throwable throwable) {
                Object var32_37 = null;
                KduException kduException5 = null;
                for (int i6 = 0; i6 < n8; ++i6) {
                    try {
                        if (kdu_pull_ifcArray[i6] == null) continue;
                        kdu_pull_ifcArray[i6].Destroy();
                        continue;
                    }
                    catch (KduException kduException6) {
                        kduException5 = kduException6;
                    }
                }
                try {
                    if (kdu_tile != null) {
                        kdu_tile.Close();
                    }
                }
                catch (KduException kduException7) {
                    kduException5 = kduException7;
                }
                if (kdu_sample_allocator != null) {
                    kdu_sample_allocator.finalize();
                }
                if (kduException5 != null) {
                    throw new DataCacheException(kduException5.toString());
                }
                throw throwable;
            }
        }
    }

    public void close() throws DataCacheException {
        this.checkThread();
        KduException kduException = null;
        this.mWaveletClientManager = null;
        try {
            if (this.mCodestream != null && this.mCodestream.Exists()) {
                this.mCodestream.Destroy();
                this.mCodestream = null;
            }
        }
        catch (KduException kduException2) {
            kduException = kduException2;
        }
        try {
            if (this.mCache != null) {
                this.mCache.Close();
                this.mCache = null;
            }
        }
        catch (KduException kduException3) {
            kduException = kduException3;
        }
        if (kduException != null) {
            throw new DataCacheException(kduException.toString());
        }
    }

    public int getImageIndex() {
        return this.mImageIndex;
    }

    private void saveDimensionInfo() throws DataCacheException {
        this.checkThread();
        try {
            Kdu_dims kdu_dims = new Kdu_dims();
            this.mCodestream.Get_dims(0, kdu_dims);
            this.mWidth = kdu_dims.Access_size().Get_x();
            this.mHeight = kdu_dims.Access_size().Get_y();
            this.mNumberOfImageComponents = this.mCodestream.Get_num_components();
        }
        catch (KduException kduException) {
            DataCacheException dataCacheException = new DataCacheException(kduException.toString());
            dataCacheException.setStackTrace(kduException.getStackTrace());
            throw dataCacheException;
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getNumberOfImageComponents() {
        return this.mNumberOfImageComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFirstImageComponent() {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            if (this.mRoi == null) {
                return 0;
            }
            return this.mRoi.getFirstImageComponent();
        }
    }

    int getMaximumDiscardedResolutionLevels() {
        return this.mMaximumDiscardedResolutionLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDiscardedResolutionLevels() {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            if (this.mRoi == null) {
                return this.mMaximumDiscardedResolutionLevels;
            }
            return this.mRoi.getDiscardedResolutionLevels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageComplete() {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            this.mImageComplete = true;
            if (this.mRoi != null) {
                this.mRoi.setDiscardedResolutionLevels(0);
            }
            this.mRoiState = RoiState.COMPLETE;
        }
    }

    public boolean isImageComplete() {
        return this.mImageComplete;
    }

    void defaultCompressionChanged(double d2) {
        if (this.mRoi == null || this.mRoi.getCompressionFraction() < d2) {
            this.mRoiState = RoiState.REQUESTED;
        }
    }

    void requestFullImage() throws DataCacheException {
        this.setRoi(0, 0, this.getWidth(), this.getHeight(), 0, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRoi(int n2, int n3, int n4, int n5, int n6, double d2) throws DataCacheException {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            boolean bl2;
            if (this.isImageComplete()) {
                return;
            }
            RegionOfInterest regionOfInterest = new RegionOfInterest(0, this.mNumberOfImageComponents, n6, n2, n3, n4, n5, d2);
            if (this.mRoi == null) {
                bl2 = false;
            } else {
                try {
                    bl2 = this.mRoiState == RoiState.COMPLETE && this.mRoi.contains(regionOfInterest);
                }
                catch (J2cProtocolException j2cProtocolException) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                this.mRoi = regionOfInterest;
                this.mRoiState = RoiState.PENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void roiComplete(RegionOfInterest regionOfInterest) throws DataCacheException {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            if (this.isImageComplete()) {
                return;
            }
            this.recordFirstImageBytes();
            try {
                if (this.mRoi == null) {
                    this.mRoiState = RoiState.REQUESTED;
                    this.mRoi = regionOfInterest;
                } else if (regionOfInterest.contains(this.mRoi)) {
                    this.mRoiState = RoiState.COMPLETE;
                    this.mRoi = regionOfInterest;
                }
            }
            catch (J2cProtocolException j2cProtocolException) {
                DataCacheException dataCacheException = new DataCacheException(j2cProtocolException.toString());
                dataCacheException.setStackTrace(j2cProtocolException.getStackTrace());
                throw dataCacheException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoiComplete() {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            return this.isImageComplete() || this.mRoiState == RoiState.COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean haveRoiRequest() {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            return this.mFinishedHeaderPhase && !this.isImageComplete() && this.mRoi != null && this.mRoiState == RoiState.PENDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordFirstImageBytes() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            if (this.mFirstImageBytes <= 0L) {
                this.mFirstImageBytes = this.mIncrementBytesTransferred;
                this.mQualityScaling = this.computeQualityScaling();
                this.mUpdateFactor = Math.exp(0.125 / this.mQualityScaling);
                this.updateThresholdForNextUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateThresholdForNextUpdate() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            this.mThresholdForNextUpdate = (long)((double)this.mIncrementBytesTransferred * this.mUpdateFactor);
            if ((double)this.mThresholdForNextUpdate > 0.75 * (double)this.mJ2cFileSize && this.mThresholdForNextUpdate < this.mJ2cFileSize) {
                this.mThresholdForNextUpdate = 2L * this.mJ2cFileSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needImageUpdate() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            return this.mFirstImageBytes > 0L && this.mIncrementBytesTransferred >= this.mThresholdForNextUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getImageQuality() {
        long l2;
        double d2;
        long l3;
        long l4;
        if (this.isImageComplete()) {
            return 1.0;
        }
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            l4 = this.mIncrementBytesTransferred;
            l3 = this.mFirstImageBytes;
            d2 = this.mQualityScaling;
            l2 = this.mJ2cFileSize;
        }
        double d3 = 0.0;
        if (l2 < 1L || l4 >= l2) {
            d3 = 1.0;
        } else if (l3 > 0L && l4 >= l3) {
            d3 = 1.0 + d2 * Math.log((double)l4 / (double)l2);
        }
        if (d3 >= 0.98) {
            d3 = 0.98;
        }
        return d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompressionFraction() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            return (double)this.mTotalBytesTransferred / (double)this.mUncompressedImageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesTransferred() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            return this.mTotalBytesTransferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBytesRequested() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            double d2;
            if (this.isImageComplete()) {
                return this.mJ2cFileSize;
            }
            if (this.mJ2cFileSize <= 1L || this.mCodestream == null) {
                return -1.0;
            }
            WaveletClientManager waveletClientManager = this.mWaveletClientManager;
            double d3 = 1.0;
            if (this.mRoi != null) {
                d3 = this.mRoi.getCompressionFraction();
                d2 = 0.0;
                if (waveletClientManager != null) {
                    d2 = waveletClientManager.getDefaultCompressionFraction();
                }
                if (d2 > d3) {
                    d3 = d2;
                }
            } else if (waveletClientManager != null) {
                d3 = waveletClientManager.getDefaultCompressionFraction();
            }
            if ((d2 = (double)this.mUncompressedImageSize * d3) > (double)this.mJ2cFileSize) {
                d2 = this.mJ2cFileSize;
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double computeQualityScaling() {
        Object object = this.mLockForImageQuality;
        synchronized (object) {
            double d2 = -0.875 / Math.log((double)this.mFirstImageBytes / (double)this.mJ2cFileSize);
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int serializeRoi(byte[] byArray, int n2) throws DataCacheException {
        Object object = this.mLockForRoiRequests;
        synchronized (object) {
            if (this.mRoiState != RoiState.PENDING) {
                throw new DataCacheException("DataCache ROI is not waiting to be sent");
            }
            if (this.mRoi == null) {
                throw new DataCacheException("DataCache has no ROI to serialize.");
            }
            this.mRoiState = this.mRoiState.getNextState();
            int n3 = 0;
            try {
                n3 = this.mRoi.serialize(byArray, n2);
            }
            catch (J2cProtocolException j2cProtocolException) {
                DataCacheException dataCacheException = new DataCacheException(j2cProtocolException.toString());
                dataCacheException.setStackTrace(j2cProtocolException.getStackTrace());
                throw dataCacheException;
            }
            return n3;
        }
    }
}

