/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

public class WaveletConnectionParameters {
    private static final int WAVELET_CONNECTION_TIMEOUT = 10000;
    private boolean mUseSsl;
    private String mProxyHost;
    private int mProxyPort;
    private String mUsername;
    private String mSessionId;
    private String mClientId;
    private int mTimeout;
    private String mDestinationHost;
    private int mDestinationPort;
    private boolean mUseProxy;
    private boolean mRevertedToProxy = false;

    public WaveletConnectionParameters() {
        this(null, false, "", 0, false, "", "");
    }

    public WaveletConnectionParameters(String string, boolean bl2, String string2, int n2, boolean bl3, String string3, String string4) {
        this.mClientId = string;
        this.mUseSsl = bl2;
        this.mProxyHost = string2;
        this.mProxyPort = n2;
        this.mUseProxy = bl3;
        this.mUsername = string3;
        this.mSessionId = string4;
        this.mDestinationHost = "";
        this.mDestinationPort = 0;
        this.mTimeout = 10000;
    }

    public WaveletConnectionParameters(WaveletConnectionParameters waveletConnectionParameters) {
        this.mClientId = waveletConnectionParameters.mClientId;
        this.mUseSsl = waveletConnectionParameters.mUseSsl;
        this.mProxyHost = waveletConnectionParameters.mProxyHost;
        this.mProxyPort = waveletConnectionParameters.mProxyPort;
        this.mUseProxy = waveletConnectionParameters.mUseProxy;
        this.mUsername = waveletConnectionParameters.mUsername;
        this.mSessionId = waveletConnectionParameters.mSessionId;
        this.mDestinationHost = waveletConnectionParameters.mDestinationHost;
        this.mDestinationPort = waveletConnectionParameters.mDestinationPort;
        this.mTimeout = waveletConnectionParameters.mTimeout;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mUseProxy) {
            stringBuffer.append("proxy via " + this.mProxyHost + ":" + this.mProxyPort);
        } else {
            stringBuffer.append("direct");
        }
        stringBuffer.append(" to " + this.mDestinationHost + ":" + this.mDestinationPort);
        stringBuffer.append(this.mUseSsl ? " (encrypted)" : " (unencrypted)");
        return stringBuffer.toString();
    }

    public void setUsername(String string) {
        this.mUsername = string;
    }

    public void setSessionId(String string) {
        this.mSessionId = string;
    }

    public void setUseProxy(boolean bl2) {
        this.mRevertedToProxy = bl2 && !this.mUseProxy;
        this.mUseProxy = bl2;
    }

    public void setUseSsl(boolean bl2) {
        this.mUseSsl = bl2;
    }

    public void setProxy(String string, int n2, boolean bl2) {
        this.mProxyHost = string;
        this.mProxyPort = n2;
        this.mUseProxy = bl2;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public boolean useSsl() {
        return this.mUseSsl;
    }

    public boolean useProxy() {
        return this.mUseProxy;
    }

    public boolean revertedToProxy() {
        return this.mRevertedToProxy;
    }

    public String getProxyHost() {
        return this.mProxyHost;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public String getDestinationHost() {
        return this.mDestinationHost;
    }

    public void setDestinationHost(String string) {
        this.mDestinationHost = string;
    }

    public int getDestinationPort() {
        return this.mDestinationPort;
    }

    public void setDestinationPort(int n2) {
        this.mDestinationPort = n2;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String string) {
        this.mClientId = string;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int n2) {
        this.mTimeout = n2;
    }
}

