/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AuditAction
implements Comparable {
    private static Map mActionMap = new HashMap();
    public static final AuditAction DELETE_ACTION = new AuditAction("Delete", "REMOVE");
    public static final AuditAction MODIFY_ACTION = new AuditAction("Modify", "MODIFY");
    public static final AuditAction MOVE_ACTION = new AuditAction("Move", "MOVE");
    public static final AuditAction OPEN_DICTATION_ACTION = new AuditAction("OpenDictation", "OPEN_DICTATION");
    public static final AuditAction OPEN_IMAGE_ACTION = new AuditAction("OpenImage", "OPEN_IMAGE");
    public static final AuditAction OPEN_REPORT_ACTION = new AuditAction("OpenReport", "OPEN_REPORT");
    public static final AuditAction OPEN_TRANSCRIPTION_ACTION = new AuditAction("OpenTranscription", "OPEN_TRANSCRIPTION");
    public static final AuditAction LOGIN_FAILED_ACTION = new AuditAction("LoginFailed", "LOGIN_FAILED");
    public static final AuditAction EXPORT_DICOM_ACTION = new AuditAction("ExportDicom", "EXPORT_DICOM");
    public static final String mDeleteAction = "REMOVE";
    public static final String mModifyAction = "MODIFY";
    public static final String mMoveAction = "MOVE";
    public static final String mOpenDictationAction = "OPEN_DICTATION";
    public static final String mOpenImageAction = "OPEN_IMAGE";
    public static final String mOpenReportAction = "OPEN_REPORT";
    public static final String mOpenTranscription = "OPEN_TRANSCRIPTION";
    public static final String mLoginFailed = "LOGIN_FAILED";
    public static final String mExportDicom = "EXPORT_DICOM";
    private static final String AUDITING_RESOURCE_BUNDLE = "com.intelerad.datamodels.audit.Auditing";
    private String mDatabaseName;
    private String mHttpName;

    private AuditAction(String string, String string2) {
        this.mDatabaseName = string;
        this.mHttpName = string2;
        mActionMap.put(this.mHttpName, this);
    }

    public String getAction() {
        return this.getName();
    }

    public String getName() {
        return this.mDatabaseName;
    }

    public String getHttpName() {
        return this.mHttpName;
    }

    public String getLabel() {
        return this.getLabel(Locale.getDefault());
    }

    public String getLabel(Locale locale) {
        return AuditAction.getLabel(this.mDatabaseName, locale);
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof AuditAction)) {
            return 1;
        }
        return this.mDatabaseName.compareTo(((AuditAction)object).mDatabaseName);
    }

    public static List getAllActions() {
        ArrayList arrayList = new ArrayList(mActionMap.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public static AuditAction getInstance(String string) {
        return (AuditAction)mActionMap.get(string);
    }

    public static String getLabel(String string) {
        return AuditAction.getLabel(string, Locale.getDefault());
    }

    public static String getLabel(String string, Locale locale) {
        try {
            return AuditAction.getAuditingResourceBundle(locale).getString("action." + string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private static ResourceBundle getAuditingResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(AUDITING_RESOURCE_BUNDLE, locale);
    }
}

