/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom;

import DataModels.ModelProperty;
import com.archimed.dicom.DDict;
import com.intelerad.datamodels.dicom.DicomAttributeHelpText;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DicomAttribute
extends ModelProperty {
    public static final String AS = "AS";
    public static final String PN = "PN";
    public static final String AE = "AE";
    public static final String DS = "DS";
    public static final String US = "US";
    public static final String ST = "ST";
    public static final String LO = "LO";
    public static final String TM = "TM";
    public static final String DA = "DA";
    public static final String SH = "SH";
    public static final String SQ = "SQ";
    public static final String UI = "UI";
    public static final String IS = "IS";
    public static final String CS = "CS";
    private final int mGroup;
    private final int mElement;
    private final String mVr;
    private final String mShortDescription;
    private static final Map mNamesToAttributes;
    private static final Map mGroupElementstoAttributes;
    private static final Map mInstanceMap;
    public static final DicomAttribute Modality;
    public static final DicomAttribute SeriesNumber;
    public static final DicomAttribute SeriesInstanceUID;
    public static final DicomAttribute SeriesDate;
    public static final DicomAttribute NumberOfSeriesRelatedImages;
    public static final DicomAttribute SeriesDescription;
    public static final DicomAttribute RequestAttributesSequence;
    public static final DicomAttribute RequestedProcedureID;
    public static final DicomAttribute ScheduledProcedureStepID;
    public static final DicomAttribute PerformedProcedureStepStartDate;
    public static final DicomAttribute PerformedProcedureStepStartTime;
    public static final DicomAttribute StudyDate;
    public static final DicomAttribute ModalitiesInStudy;
    public static final DicomAttribute NumberOfStudyRelatedSeries;
    public static final DicomAttribute ProtocolName;
    public static final DicomAttribute BodyPartExamined;
    public static final DicomAttribute ViewPosition;
    public static final DicomAttribute Laterality;
    public static final DicomAttribute SeriesTime;
    public static final DicomAttribute NumberOfCopies;
    public static final DicomAttribute PrintPriority;
    public static final DicomAttribute MediumType;
    public static final DicomAttribute FilmDestination;
    public static final DicomAttribute FilmSessionLabel;
    public static final DicomAttribute MemoryAllocation;
    public static final DicomAttribute OwnerID;
    public static final DicomAttribute ReferencedFilmBoxSequence;
    public static final DicomAttribute ProposedStudySequence;
    public static final DicomAttribute ImageDisplayFormat;
    public static final DicomAttribute AnnotationDisplayFormatID;
    public static final DicomAttribute FilmOrientation;
    public static final DicomAttribute FilmSizeID;
    public static final DicomAttribute MagnificationType;
    public static final DicomAttribute SmoothingType;
    public static final DicomAttribute BorderDensity;
    public static final DicomAttribute EmptyImageDensity;
    public static final DicomAttribute MinDensity;
    public static final DicomAttribute MaxDensity;
    public static final DicomAttribute Trim;
    public static final DicomAttribute ConfigurationInformation;
    public static final DicomAttribute Illumination;
    public static final DicomAttribute ReflectedAmbientLight;
    public static final DicomAttribute RequestedResolutionID;
    public static final DicomAttribute ReferencedFilmSessionSequence;
    public static final DicomAttribute ReferencedImageBoxSequence;
    public static final DicomAttribute ReferencedBasicAnnotationBox;
    public static final DicomAttribute ReferencedPresentationLUT;
    public static final DicomAttribute ImagePosition;
    public static final DicomAttribute Polarity;
    public static final DicomAttribute RequestedImageSize;
    public static final DicomAttribute RequestedDecimateCropBehavior;
    public static final DicomAttribute BasicGrayscaleImageSequence;
    public static final DicomAttribute BasicColorImageSequence;
    public static final DicomAttribute ReferencedImageOverlayBox;
    public static final DicomAttribute OriginalImageSequence;
    public static final DicomAttribute AnnotationPosition;
    public static final DicomAttribute TextString;
    public static final DicomAttribute ExecutionStatus;
    public static final DicomAttribute ExecutionStatusInfo;
    public static final DicomAttribute CreationDate;
    public static final DicomAttribute CreationTime;
    public static final DicomAttribute PrinterName;
    public static final DicomAttribute Originator;
    public static final DicomAttribute PrinterStatus;
    public static final DicomAttribute PrinterStatusInfo;
    public static final DicomAttribute Manufacturer;
    public static final DicomAttribute ManufacturerModelName;
    public static final DicomAttribute DeviceSerialNumber;
    public static final DicomAttribute SoftwareVersions;
    public static final DicomAttribute DateOfLastCalibration;
    public static final DicomAttribute TimeOfLastCalibration;
    public static final DicomAttribute ColorImagePrintingFlag;
    public static final DicomAttribute CollationFlag;
    public static final DicomAttribute AnnotationFlag;
    public static final DicomAttribute ImageOverlayFlag;
    public static final DicomAttribute PresentationLUTFlag;
    public static final DicomAttribute ImageBoxPresentationLUTFlag;
    public static final DicomAttribute ReferencedStoredPrintSequence;
    public static final DicomAttribute PrinterConfiguration;
    public static final DicomAttribute StudyInstanceUID;
    public static final DicomAttribute PatientName;
    public static final DicomAttribute PatientID;
    public static final DicomAttribute PatientBirthDate;
    public static final DicomAttribute PatientBirthTime;
    public static final DicomAttribute PatientSex;
    public static final DicomAttribute PatientAge;
    public static final DicomAttribute StudyTime;
    public static final DicomAttribute AccessionNumber;
    public static final DicomAttribute StudyID;
    public static final DicomAttribute ReferringPhysiciansName;
    public static final DicomAttribute StudyDescription;
    public static final DicomAttribute SOPInstanceUID;
    public static final DicomAttribute Rows;
    public static final DicomAttribute Columns;
    public static final DicomAttribute InstanceNumber;
    public static final DicomAttribute SmallestImagePixelValue;
    public static final DicomAttribute LargestImagePixelValue;
    public static final DicomAttribute NumberOfFrames;
    public static final DicomAttribute PhotometricInterpretation;
    public static final DicomAttribute PixelRepresentation;
    public static final DicomAttribute PlanarConfiguration;
    public static final DicomAttribute BitsStored;
    public static final DicomAttribute BitsAllocated;
    public static final DicomAttribute HighBit;
    public static final DicomAttribute EchoNumber;
    public static final DicomAttribute PixelAspectRatio;
    public static final DicomAttribute WindowCenter;
    public static final DicomAttribute WindowWidth;
    public static final DicomAttribute RescaleSlope;
    public static final DicomAttribute RescaleIntercept;
    public static final DicomAttribute ImagePositionPatient;
    public static final DicomAttribute ImageOrientationPatient;
    public static final DicomAttribute PixelSpacing;
    public static final DicomAttribute ImagerPixelSpacing;
    public static final DicomAttribute PatientOrientation;
    public static final DicomAttribute FrameOfReferenceUID;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DicomAttribute(Class clazz, int n2, int n3, String string, String string2, String string3) {
        this(clazz, n2, n3, string, string2, string3, string3);
    }

    private DicomAttribute(Class clazz, int n2, int n3, String string, String string2, String string3, String string4) {
        super(clazz, string2, string3);
        this.mGroup = n2;
        this.mElement = n3;
        this.mVr = string;
        this.mShortDescription = string4;
        mInstanceMap.put(DicomAttribute.getGroupElementKey(this.mGroup, this.mElement), this);
        if (!$assertionsDisabled && this.mVr != this.lookUpVR()) {
            throw new AssertionError((Object)"The VR should match JDT's");
        }
        mNamesToAttributes.put(string2, this);
        mGroupElementstoAttributes.put(DicomAttribute.getKey(n2, n3), this);
    }

    public static DicomAttribute getAttributeFromName(String string) {
        return (DicomAttribute)mNamesToAttributes.get(string);
    }

    public static DicomAttribute getAttributeFromGroupElement(int n2, int n3) {
        return (DicomAttribute)mGroupElementstoAttributes.get(DicomAttribute.getKey(n2, n3));
    }

    private static Integer getKey(int n2, int n3) {
        return new Integer(n2 << 16 | n3);
    }

    public static List getAllAttributes() {
        return new ArrayList(mNamesToAttributes.values());
    }

    public int getGroup() {
        return this.mGroup;
    }

    public int getElement() {
        return this.mElement;
    }

    public String getVR() {
        return this.mVr;
    }

    public String getShortDescription() {
        return this.mShortDescription;
    }

    public String getHelpString() {
        return DicomAttributeHelpText.getHelpString(this);
    }

    public String toString() {
        return "(" + Integer.toHexString(this.mGroup) + "," + Integer.toHexString(this.mElement) + ") " + this.mVr + "  " + this.getName();
    }

    private String lookUpVR() {
        return DDict.getTypeCodeName((int)this.getJdtDname());
    }

    public int getJdtDname() {
        return DDict.lookupDDict((int)this.mGroup, (int)this.mElement);
    }

    public static DicomAttribute getInstance(int n2, int n3) {
        Long l2 = DicomAttribute.getGroupElementKey(n2, n3);
        return (DicomAttribute)mInstanceMap.get(l2);
    }

    private static Long getGroupElementKey(int n2, int n3) {
        return new Long(((long)n2 << 32) + (long)n3);
    }

    static {
        $assertionsDisabled = !DicomAttribute.class.desiredAssertionStatus();
        mNamesToAttributes = new HashMap();
        mGroupElementstoAttributes = new HashMap();
        mInstanceMap = new HashMap();
        Modality = new DicomAttribute(String.class, 8, 96, CS, "Modality", "Modality");
        SeriesNumber = new DicomAttribute(Integer.class, 32, 17, IS, "SeriesNumber", "Series Number");
        SeriesInstanceUID = new DicomAttribute(String.class, 32, 14, UI, "SeriesInstanceUID", "Series Instance UID");
        SeriesDate = new DicomAttribute(Date.class, 8, 33, DA, "SeriesDate", "Series Date");
        NumberOfSeriesRelatedImages = new DicomAttribute(Integer.class, 32, 4617, IS, "NumberOfSeriesRelatedImages", "Number Of Series Related Images");
        SeriesDescription = new DicomAttribute(String.class, 8, 4158, LO, "SeriesDescription", "Series Description");
        RequestAttributesSequence = new DicomAttribute(List.class, 64, 629, SQ, "RequestAttributesSequence", "Request Attributes Sequence");
        RequestedProcedureID = new DicomAttribute(String.class, 64, 4097, SH, "RequestedProcedureID", "Requested Procedure ID");
        ScheduledProcedureStepID = new DicomAttribute(String.class, 64, 9, SH, "ScheduledProcedureStepID", "Scheduled Procedure Step ID");
        PerformedProcedureStepStartDate = new DicomAttribute(Date.class, 64, 580, DA, "PerformedProcedureStepStartDate", "Performed Procedure Step Start Date");
        PerformedProcedureStepStartTime = new DicomAttribute(String.class, 64, 581, TM, "PerformedProcedureStepStartTime", "Performed Procedure Step Start Time");
        StudyDate = new DicomAttribute(Date.class, 8, 32, DA, "StudyDate", "Study Date");
        ModalitiesInStudy = new DicomAttribute(String.class, 8, 97, CS, "ModalitiesInStudy", "Modalities In Study");
        NumberOfStudyRelatedSeries = new DicomAttribute(Integer.class, 32, 4614, IS, "NumberOfStudyRelatedSeries", "Number of Study Related Series");
        ProtocolName = new DicomAttribute(String.class, 24, 4144, LO, "ProtocolName", "Protocol Name");
        BodyPartExamined = new DicomAttribute(String.class, 24, 21, CS, "BodyPartExamined", "Body Part Examined");
        ViewPosition = new DicomAttribute(String.class, 24, 20737, CS, "ViewPosition", "View Position");
        Laterality = new DicomAttribute(String.class, 32, 96, CS, "Laterality", "Laterality");
        SeriesTime = new DicomAttribute(String.class, 8, 49, TM, "SeriesTime", "Series Time");
        NumberOfCopies = new DicomAttribute(Integer.class, 8192, 16, IS, "NumberOfCopies", "Number of Copies", "Copies");
        PrintPriority = new DicomAttribute(String.class, 8192, 32, CS, "PrintPriority", "Print Priority", "Priority");
        MediumType = new DicomAttribute(String.class, 8192, 48, CS, "MediumType", "Medium Type", "Film Type");
        FilmDestination = new DicomAttribute(String.class, 8192, 64, CS, "FilmDestination", "Film Destination", "Destination");
        FilmSessionLabel = new DicomAttribute(String.class, 8192, 80, LO, "FilmSessionLabel", "Film Session Label");
        MemoryAllocation = new DicomAttribute(Integer.class, 8192, 96, IS, "MemoryAllocation", "Memory Allocation");
        OwnerID = new DicomAttribute(String.class, 8448, 352, SH, "OwnerID", "Owner ID");
        ReferencedFilmBoxSequence = new DicomAttribute(Object.class, 8192, 1280, SQ, "ReferencedFilmBoxSequence", "Referenced Film Box Sequence");
        ProposedStudySequence = new DicomAttribute(Object.class, 8496, 160, SQ, "ProposedStudySequence", "Proposed Study Sequence");
        ImageDisplayFormat = new DicomAttribute(String.class, 8208, 16, ST, "ImageDisplayFormat", "Image Display Format", "Layout");
        AnnotationDisplayFormatID = new DicomAttribute(String.class, 8208, 48, CS, "AnnotationDisplayFormatID", "Annotation Display Format ID");
        FilmOrientation = new DicomAttribute(String.class, 8208, 64, CS, "FilmOrientation", "Film Orientation", "Orientation");
        FilmSizeID = new DicomAttribute(String.class, 8208, 80, CS, "FilmSizeID", "Film Size", "Film Size");
        MagnificationType = new DicomAttribute(String.class, 8208, 96, CS, "MagnificationType", "Magnification Type", "Magnification");
        SmoothingType = new DicomAttribute(String.class, 8208, 128, CS, "SmoothingType", "Smoothing Type", "Smoothing");
        BorderDensity = new DicomAttribute(String.class, 8208, 256, CS, "BorderDensity", "Border Density", "Border");
        EmptyImageDensity = new DicomAttribute(String.class, 8208, 272, CS, "EmptyImageDensity", "Empty Image Density", "Empty Image");
        MinDensity = new DicomAttribute(Integer.class, 8208, 288, US, "MinDensity", "Minimum Density", "Minimum");
        MaxDensity = new DicomAttribute(Integer.class, 8208, 304, US, "MaxDensity", "Maximum Density", "Maximum");
        Trim = new DicomAttribute(String.class, 8208, 320, CS, "Trim", "Trim", "Trim Box");
        ConfigurationInformation = new DicomAttribute(String.class, 8208, 336, ST, "ConfigurationInformation", "Configuration Information", "Configuration");
        Illumination = new DicomAttribute(Integer.class, 8208, 350, US, "Illumination", "Illumination");
        ReflectedAmbientLight = new DicomAttribute(Integer.class, 8208, 352, US, "ReflectedAmbientLight", "Reflected Ambient Light");
        RequestedResolutionID = new DicomAttribute(String.class, 8224, 80, CS, "RequestedResolutionID", "Requested Resolution ID", "Resolution");
        ReferencedFilmSessionSequence = new DicomAttribute(Object.class, 8208, 1280, SQ, "ReferencedFilmSessionSequence", "Referenced Film Session Sequence");
        ReferencedImageBoxSequence = new DicomAttribute(Object.class, 8208, 1296, SQ, "ReferencedImageBoxSequence", "Referenced Image Box Sequence");
        ReferencedBasicAnnotationBox = new DicomAttribute(Object.class, 8208, 1312, SQ, "ReferencedBasicAnnotationBox", "Referenced Basic Annotation Box");
        ReferencedPresentationLUT = new DicomAttribute(Object.class, 8272, 1280, SQ, "ReferencedPresentationLUT", "Referenced Presentation LUT");
        ImagePosition = new DicomAttribute(Integer.class, 8224, 16, US, "ImagePosition", "Image Position");
        Polarity = new DicomAttribute(String.class, 8224, 32, CS, "Polarity", "Polarity");
        RequestedImageSize = new DicomAttribute(String.class, 8224, 48, DS, "RequestedImageSize", "Requested Image Size");
        RequestedDecimateCropBehavior = new DicomAttribute(String.class, 8224, 64, CS, "RequestedDecimateCropBehavior", "Requested Decimate/Crop Behavior");
        BasicGrayscaleImageSequence = new DicomAttribute(Object.class, 8224, 272, SQ, "BasicGrayscaleImageSequence", "Basic Grayscale Image Sequence");
        BasicColorImageSequence = new DicomAttribute(Object.class, 8224, 273, SQ, "BasicColorImageSequence", "Basic Color Image Sequence");
        ReferencedImageOverlayBox = new DicomAttribute(Object.class, 8224, 304, SQ, "ReferencedImageOverlayBox", "Referenced Image Overlay Box");
        OriginalImageSequence = new DicomAttribute(Object.class, 8496, 192, SQ, "OriginalImageSequence", "Original Image Sequence");
        AnnotationPosition = new DicomAttribute(Integer.class, 8240, 16, US, "AnnotationPosition", "Annotation Position");
        TextString = new DicomAttribute(String.class, 8240, 32, LO, "TextString", "Text String");
        ExecutionStatus = new DicomAttribute(String.class, 8448, 32, CS, "ExecutionStatus", "Execution Status");
        ExecutionStatusInfo = new DicomAttribute(String.class, 8448, 48, CS, "ExecutionStatusInfo", "Execution Status Info");
        CreationDate = new DicomAttribute(Date.class, 8448, 64, DA, "CreationDate", "Creation Date");
        CreationTime = new DicomAttribute(String.class, 8448, 80, TM, "CreationTime", "Creation Time");
        PrinterName = new DicomAttribute(String.class, 8464, 48, LO, "PrinterName", "Printer Name");
        Originator = new DicomAttribute(String.class, 8448, 112, AE, "Originator", "Originator");
        PrinterStatus = new DicomAttribute(String.class, 8464, 16, CS, "PrinterStatus", "Printer Status");
        PrinterStatusInfo = new DicomAttribute(String.class, 8464, 32, CS, "PrinterStatusInfo", "Printer Status Info");
        Manufacturer = new DicomAttribute(String.class, 8, 112, LO, "Manufacturer", "Manufacturer");
        ManufacturerModelName = new DicomAttribute(String.class, 8, 4240, LO, "ManufacturerModelName", "Manufacturer Model Name");
        DeviceSerialNumber = new DicomAttribute(String.class, 24, 4096, LO, "DeviceSerialNumber", "Device Serial Number");
        SoftwareVersions = new DicomAttribute(String.class, 24, 4128, LO, "SoftwareVersions", "Software Versions");
        DateOfLastCalibration = new DicomAttribute(Date.class, 24, 4608, DA, "DateOfLastCalibration", "Date Of Last Calibration");
        TimeOfLastCalibration = new DicomAttribute(String.class, 24, 4609, TM, "TimeOfLastCalibration", "Time Of Last Calibration");
        ColorImagePrintingFlag = new DicomAttribute(String.class, 8192, 98, CS, "ColorImagePrintingFlag", "Color Image Printing Flag");
        CollationFlag = new DicomAttribute(String.class, 8192, 99, CS, "CollationFlag", "Collation Flag");
        AnnotationFlag = new DicomAttribute(String.class, 8192, 101, CS, "AnnotationFlag", "Annotation Flag");
        ImageOverlayFlag = new DicomAttribute(String.class, 8192, 103, CS, "ImageOverlayFlag", "Image Overlay Flag");
        PresentationLUTFlag = new DicomAttribute(String.class, 8192, 105, CS, "PresentationLUTFlag", "Presentation LUT Flag");
        ImageBoxPresentationLUTFlag = new DicomAttribute(String.class, 8192, 106, CS, "ImageBoxPresentationLUTFlag", "Image Box Presentation LUT Flag");
        ReferencedStoredPrintSequence = new DicomAttribute(Object.class, 8192, 1296, SQ, "ReferencedStoredPrintSequence", "Referenced Stored Print Sequence");
        PrinterConfiguration = new DicomAttribute(Object.class, 8192, 30, SQ, "PrinterConfiguration", "Printer Configuration");
        StudyInstanceUID = new DicomAttribute(String.class, 32, 13, UI, "StudyInstanceUID", "Study Instance UID");
        PatientName = new DicomAttribute(String.class, 16, 16, PN, "PatientName", "Patient Name");
        PatientID = new DicomAttribute(String.class, 16, 32, LO, "PatientID", "Patient ID");
        PatientBirthDate = new DicomAttribute(Date.class, 16, 48, DA, "PatientBirthDate", "Patient Birth Date");
        PatientBirthTime = new DicomAttribute(String.class, 16, 50, TM, "PatientBirthTime", "Patient Birth Time");
        PatientSex = new DicomAttribute(String.class, 16, 64, CS, "PatientSex", "Patient Sex");
        PatientAge = new DicomAttribute(String.class, 16, 4112, AS, "PatientAge", "Patient Age");
        StudyTime = new DicomAttribute(String.class, 8, 48, TM, "StudyTime", "Study Time");
        AccessionNumber = new DicomAttribute(String.class, 8, 80, SH, "AccessionNumber", "Accession Number");
        StudyID = new DicomAttribute(String.class, 32, 16, SH, "StudyID", "Study ID");
        ReferringPhysiciansName = new DicomAttribute(String.class, 8, 144, PN, "ReferringPhysiciansName", "Referring Physicians Name");
        StudyDescription = new DicomAttribute(String.class, 8, 4144, LO, "StudyDescription", "Study Description");
        SOPInstanceUID = new DicomAttribute(String.class, 8, 24, UI, "SOPInstanceUID", "SOP Instance UID");
        Rows = new DicomAttribute(Integer.class, 40, 16, US, "Rows", "Rows");
        Columns = new DicomAttribute(Integer.class, 40, 17, US, "Columns", "Columns");
        InstanceNumber = new DicomAttribute(Integer.class, 32, 19, IS, "InstanceNumber", "Instance Number");
        SmallestImagePixelValue = new DicomAttribute(Integer.class, 40, 262, "US_SS", "SmallestImagePixelValue", "Smallest Image Pixel Value");
        LargestImagePixelValue = new DicomAttribute(Integer.class, 40, 263, "US_SS", "LargestImagePixelValue", "Largest Image Pixel Value");
        NumberOfFrames = new DicomAttribute(Integer.class, 40, 8, IS, "NumberOfFrames", "Number Of Frames");
        PhotometricInterpretation = new DicomAttribute(String.class, 40, 4, CS, "PhotometricInterpretation", "PhotometricInterpretation");
        PixelRepresentation = new DicomAttribute(Integer.class, 40, 259, US, "PixelRepresentation", "PixelRepresentation");
        PlanarConfiguration = new DicomAttribute(Integer.class, 40, 6, US, "PlanarConfiguration", "PlanarConfiguration");
        BitsStored = new DicomAttribute(Integer.class, 40, 257, US, "BitsStored", "BitsStored");
        BitsAllocated = new DicomAttribute(Integer.class, 40, 256, US, "BitsAllocated", "BitsAllocated");
        HighBit = new DicomAttribute(Integer.class, 40, 258, US, "HighBit", "HighBit");
        EchoNumber = new DicomAttribute(Integer.class, 24, 134, IS, "EchoNumber", "Echo Number");
        PixelAspectRatio = new DicomAttribute(List.class, 40, 52, IS, "PixelAspectRatio", "Pixel Aspect Ratio");
        WindowCenter = new DicomAttribute(List.class, 40, 4176, DS, "WindowCenter", "Window Center");
        WindowWidth = new DicomAttribute(List.class, 40, 4177, DS, "WindowWidth", "Window Width");
        RescaleSlope = new DicomAttribute(Float.class, 40, 4179, DS, "RescaleSlope", "Rescale Slope");
        RescaleIntercept = new DicomAttribute(Float.class, 40, 4178, DS, "RescaleIntercept", "Rescale Intercept");
        ImagePositionPatient = new DicomAttribute(List.class, 32, 50, DS, "ImagePositionPatient", "Image Position Patient");
        ImageOrientationPatient = new DicomAttribute(List.class, 32, 55, DS, "ImageOrientationPatient", "Image Orientation Patient");
        PixelSpacing = new DicomAttribute(List.class, 40, 48, DS, "PixelSpacing", "Pixel Spacing");
        ImagerPixelSpacing = new DicomAttribute(List.class, 24, 4452, DS, "ImagerPixelSpacing", "Imager Pixel Spacing");
        PatientOrientation = new DicomAttribute(List.class, 32, 32, CS, "PatientOrientation", "Patient Orientation");
        FrameOfReferenceUID = new DicomAttribute(String.class, 32, 82, UI, "FrameOfReferenceUID", "Frame of Reference UID");
    }
}

