/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom;

import com.intelerad.datamodels.dicom.DicomAttribute;
import java.util.HashMap;
import java.util.Map;

class DicomAttributeHelpText {
    private static Map mHelpStrings = DicomAttributeHelpText.createHelpStringMap();

    private DicomAttributeHelpText() {
    }

    static String getHelpString(DicomAttribute dicomAttribute) {
        return (String)mHelpStrings.get(dicomAttribute);
    }

    private static Map createHelpStringMap() {
        HashMap<DicomAttribute, String> hashMap = new HashMap<DicomAttribute, String>();
        hashMap.put(DicomAttribute.NumberOfCopies, " Number of copies to be printed for each film of the\n  film session.\n");
        hashMap.put(DicomAttribute.PrintPriority, "   Specifies the priority of the print job.\n   Enumerated Values:\n            HIGH\n            MED\n            LOW\n");
        hashMap.put(DicomAttribute.MediumType, "   Type of medium on which the print job will be\n   printed. Defined Terms:\n            PAPER\n            CLEAR FILM\n            BLUE FILM\n            MAMMO CLEAR FILM\n            MAMMO BLUE FILM\n");
        hashMap.put(DicomAttribute.FilmDestination, "   Film destination. Defined Terms:\n          MAGAZINE = the exposed film is stored in\n              film magazine\n          PROCESSOR = the exposed film is\n              developed in film processor\n          BIN_i = the exposed film is deposited in a\n                sorter bin where \"I\" represents the bin\n                number. Film sorter BINs shall be\n                numbered sequentially starting from\n                one and no maxiumu is placed on the\n                number of BINs. The encoding of the\n                BIN number shall not contain leading\n                zeros.\n");
        hashMap.put(DicomAttribute.FilmSessionLabel, "   Human readable label that identifies the film session\n");
        hashMap.put(DicomAttribute.MemoryAllocation, "   Amount of memory allocated for the film session.\n   Value is expressed in KB\n");
        hashMap.put(DicomAttribute.OwnerID, "   Identification of the owner of the film session\n");
        hashMap.put(DicomAttribute.ReferencedFilmBoxSequence, " A Sequence which provides references to a set of\n Film Box SOP Class/Instance pairs. Zero or more\n Items may be included in this Sequence.\n");
        hashMap.put(DicomAttribute.ProposedStudySequence, "   Attributes that may be used to identify Stored Print\n   Storage and Hardcopy Image SOP Instances\n   created to store this Film Session.\n");
        hashMap.put(DicomAttribute.ImageDisplayFormat, "   Type of image display format. Enumerated Values:\n   STANDARD\\C,R : film contains equal size\n   rectangular image boxes with R rows of image\n   boxes and C columns of image boxes; C and R are\n   integers.\n   ROW\\R1,R2,R3, etc. : film contains rows with equal\n   size rectangular image boxes with R1 image boxes\n   in the first row, R2 image boxes in second row, R3\n   image boxes in third row, etc.; R1, R2, R3, etc. are\n   integers.\n   COL\\C1,C2,C3, etc.: film contains columns with\n   equal size rectangular image boxes with C1 image\n   boxes in the first column, C2 image boxes in second\n   column, C3 image boxes in third column, etc.; C1,\n   C2, C3, etc. are integers.\n   SLIDE : film contains 35mm slides; the number of\n   slides for a particular film size is configuration\n   dependent.\n   SUPERSLIDE : film contains 40mm slides; the\n   number of slides for a particular film size is\n   configuration dependent.\n   CUSTOM\\i : film contains a customized ordering of\n   rectangular image boxes; i identifies the image\n   display format; the definition of the image display\n   formats is defined in the Conformance Statement; i\n   is an integer\n");
        hashMap.put(DicomAttribute.AnnotationDisplayFormatID, "   Identification of annotation display format. The\n   definition of the annotation display formats and the\n   annotation box position sequence are defined in the\n   Conformance Statement\n");
        hashMap.put(DicomAttribute.FilmOrientation, "   Film orientation. Enumerated Values:\n         PORTRAIT = vertical film position\n         LANDSCAPE = horizontal film position\n");
        hashMap.put(DicomAttribute.FilmSizeID, "   Film size identification. Defined Terms:\n             8INX10IN\n             8_5INX11IN\n             10INX12IN\n             10INX14IN\n             11INX14IN\n             11INX17IN\n             14INX14IN\n             14INX17IN\n             24CMX24CM\n             24CMX30CM\n             A4\n             A3\n     Note:     10INX14IN corresponds with\n               25.7CMX36.4CM\n               A4 corresponds with 210 x 297 millimeters\n               A3 corresponds with 297 x 420 millimeters\n");
        hashMap.put(DicomAttribute.MagnificationType, "   Interpolation type by which the printer magnifies or\n   decimates the image in order to fit the image in the\n   image box on film. Defined Terms:\n             REPLICATE\n             BILINEAR\n             CUBIC\n             NONE\n");
        hashMap.put(DicomAttribute.SmoothingType, "   Further specifies the type of the interpolation\n   function. Values are defined in Conformance\n   Statement. Only valid for Magnification Type\n   (2010,0060) = CUBIC\n");
        hashMap.put(DicomAttribute.BorderDensity, "   Density of the film areas surrounding and between\n   images on the film. Defined Terms:\n         BLACK\n         WHITE\n         i     where i represents the desired density in\n               hundreds of OD (e.g. 150 corresponds\n               with 1.5 OD)\n");
        hashMap.put(DicomAttribute.EmptyImageDensity, "   Density of the image box area on the film that\n   contains no image. Defined Terms:\n         BLACK\n         WHITE\n         i     where i represents the desired density in\n               hundredths of OD (e.g. 150 corresponds\n               with 1.5 OD)\n");
        hashMap.put(DicomAttribute.MinDensity, "   Minimum density of the images on the film,\n   expressed in hundredths of OD. If Min Density is\n   lower than minimum printer density than Min Density\n   is set to minimum printer density.\n");
        hashMap.put(DicomAttribute.MaxDensity, "   Maximum density of the images on the film,\n   expressed in hundredths of OD. If Max Density is\n   higher than maximum printer density than Max\n   Density is set to maximum printer density.\n");
        hashMap.put(DicomAttribute.Trim, "   Specifies whether a trim box shall be printed\n   surrounding each image on the film. Enumerated\n   Values:\n         YES\n         NO\n");
        hashMap.put(DicomAttribute.ConfigurationInformation, "   Character string that contains either the ID of the\n   printer configuration table that contains a set of\n   values for implementation specific print parameters\n   (e.g. perception LUT related parameters) or one or\n   more configuration data values, encoded as\n   characters. If there are multiple configuration data\n   values encoded in the string, they shall be\n   separated by backslashes. The definition of values\n   shall be contained in the SCP''s Conformance\n   Statement.\n   Defined Terms:\n   CS000-CS999: Implementation specific curve type.\n     Note:    It is recommended that for SCPs, CS000\n              represent the lowest contrast and CS999 the\n              highest contrast levels available.\n");
        hashMap.put(DicomAttribute.Illumination, "   Luminance of lightbox illuminating a piece of\n   transmissive film, or for the case of reflective media,\n   luminance obtainable from diffuse reflection of the\n   illumination present. Expressed as L0, in candelas\n   per square meter (cd/m2).\n");
        hashMap.put(DicomAttribute.ReflectedAmbientLight, "   For transmissive film, luminance contribution due to\n   reflected ambient light. Expressed as La, in\n   candelas per square meter (cd/m2).\n");
        hashMap.put(DicomAttribute.RequestedResolutionID, "   Specifies the resolution at which images in this Film\n   Box are to be printed.\n   Defined Terms:\n         STANDARD = approximately 4k x 5k printable\n             pixels on a 14 x 17 inch film\n         HIGH = Approximately twice the resolution of\n             STANDARD.\n");
        hashMap.put(DicomAttribute.ReferencedFilmSessionSequence, "       A sequence which provides references to a Film\n       Session SOP Class/Instance pairs. Only a single\n       Item shall be permitted in this Sequence.\n");
        hashMap.put(DicomAttribute.ReferencedImageBoxSequence, "       A sequence which provides references to a set of\n       Image Box SOP Class/Instance pairs. One or more\n       Items may be included in this Sequence.\n");
        hashMap.put(DicomAttribute.ReferencedBasicAnnotationBox, "       A Sequence which provides references to a set of\n       Basic Annotation Box SOP Class/Instance pairs.\n       Zero or more Items may be included in this\n       Sequence.\n");
        hashMap.put(DicomAttribute.ReferencedPresentationLUT, "   A sequence which provides references to a\n   Presentation LUT related SOP Class/Instance pairs.\n   Only a single Item shall be included in this\n   sequence.\n");
        hashMap.put(DicomAttribute.ImagePosition, "   The position of the image on the film, based on\n   Image Display Format (2010,0010). See C.13.5.1\n   for specification.\n");
        hashMap.put(DicomAttribute.Polarity, "   Specifies whether minimum pixel values (after VOI\n   LUT transformation) are to printed black or white.\n   Enumerated Values:\n   NORMAL = pixels shall be printed as specified by\n   the Photometric Interpretation (0028,0004)\n   REVERSE = pixels shall be printed with the\n   opposite polarity as specified by the Photometric\n   Interpretation (0028,0004)\n   If Polarity (2020,0020) is not specified by the SCU,\n   the SCP shall print with NORMAL polarity.\n");
        hashMap.put(DicomAttribute.RequestedImageSize, "   Width (x-dimension) in mm of the image to be\n   printed. This value overrides the size that\n   corresponds with optimal filling of the Image Box.\n");
        hashMap.put(DicomAttribute.RequestedDecimateCropBehavior, "   Specifies whether image pixels are to be decimated\n   or cropped if the image rows or columns is greater\n   than the available printable pixels in an Image Box.\n   Decimation means that a magnification factor <1 is\n   applied to the image. The method of decimation\n   shall be that specified by Magnification Type\n   (2010,0060) or the SCP default if not specified\n   Cropping means that some image rows and/or\n   columns are deleted before printing\n   Enumerated Values:\n   DECIMATE = a magnification factor <1 to be\n   applied to the image.\n   CROP = some image rows and/or columns are to\n   be deleted before printing. The specific algorithm\n   for cropping shall be described in the SCP\n   Conformance Statement.\n   FAIL = the SCP shall not crop or decimate\n");
        hashMap.put(DicomAttribute.BasicGrayscaleImageSequence, "   A sequence which provides the content of the\n   grayscale image pixel data to be printed. This is a\n   specialization of the Image Pixel Module defined in\n   C.7.6.3 of this part. It is encoded as a sequence of\n   Attributes of the Image Pixel Module. Zero or one\n   Item may be included in this Sequence.\n   See PS 3.4 for further description.\n");
        hashMap.put(DicomAttribute.BasicColorImageSequence, "   A sequence which provides the content of the color\n   image pixel data to be printed. It is a specialization\n   of the Image Pixel Module defined in C.7.6.3 of this\n   part. It is encoded as a sequence of Attributes of the\n   Image Pixel Module. Zero or one Item may be\n   included in this Sequence.\n   See PS 3.4 for further description.\n");
        hashMap.put(DicomAttribute.ReferencedImageOverlayBox, "   A sequence which provides references to an Image\n   Overlay Box SOP Class/Instance pair and a specific\n   frame number in multi-frame instances. Zero or one\n   Item may be included in this Sequence.\n");
        hashMap.put(DicomAttribute.OriginalImageSequence, "   Attributes of the original modality images to be\n   printed in this Film Session.\n");
        hashMap.put(DicomAttribute.AnnotationPosition, "    The position of the annotation box in the parent film\n    box. Annotation position sequence depends on the\n    selected Annotation Display Format ID (2010,0030)\n");
        hashMap.put(DicomAttribute.TextString, "    Text string\n");
        hashMap.put(DicomAttribute.ExecutionStatus, "   Execution status of print job. Enumerated Values:\n        PENDING\n        PRINTING\n        DONE\n        FAILURE\n");
        hashMap.put(DicomAttribute.ExecutionStatusInfo, "   Additional information about Execution Status\n   (2100,0020).\n   Defined Terms when the Execution Status is DONE\n   or PRINTING:\n         NORMAL\n   Defined Terms when the Execution Status is\n   FAILURE:\n           INVALID PAGE DES = The specified page\n            layout cannot be printed or other page\n            description errors have been detected.\n           INSUFFIC MEMORY = There is not enough\n            memory available to complete this job.\n   See Section C.13.9.1 for additional Defined Terms\n   when the Execution Status is PENDING or\n   FAILURE.\n");
        hashMap.put(DicomAttribute.CreationDate, "   Date of print job creation.\n");
        hashMap.put(DicomAttribute.CreationTime, "   Time of print job creation.\n");
        hashMap.put(DicomAttribute.PrinterName, "   User defined name identifying the printer.\n");
        hashMap.put(DicomAttribute.Originator, "   DICOM Application Entity Title that issued the print\n   operation.\n");
        hashMap.put(DicomAttribute.PrinterStatus, "      Printer device status. Enumerated Values:\n            NORMAL\n            WARNING\n            FAILURE\n");
        hashMap.put(DicomAttribute.PrinterStatusInfo, "      Additional information about Printer Status\n      (2110,0010).\n      Defined Terms when the Printer Status is equal to\n      NORMAL:\n            NORMAL\n      See Section C.13.9.1 for Defined Terms when the\n      Printer Status is equal to WARNING or FAILURE.\n");
        hashMap.put(DicomAttribute.PrinterName, "      User defined name identifying the printer.\n");
        hashMap.put(DicomAttribute.Manufacturer, "      Manufacturer of the printer.\n");
        hashMap.put(DicomAttribute.ManufacturerModelName, "      Manufacturer''s model number of the printer.\n");
        hashMap.put(DicomAttribute.DeviceSerialNumber, "      Manufacturer''s serial number of the printer.\n");
        hashMap.put(DicomAttribute.SoftwareVersions, "      Manufacturer''s designation of software version of\n      the printer.\n");
        hashMap.put(DicomAttribute.DateOfLastCalibration, "      Date when the printer was last calibrated.\n");
        hashMap.put(DicomAttribute.TimeOfLastCalibration, "      Time when the printer was last calibrated.\n");
        hashMap.put(DicomAttribute.ColorImagePrintingFlag, "     Flag describing how grayscale printers shall print\n     color images. Enumerated Values:\n     BESTFIT = attempt to print color image pixel data\n     on a grayscale printer\n     REJECT = do not attempt to print color image pixel\n     data on a grayscale printer\n     Meaningful only for grayscale printers\n");
        hashMap.put(DicomAttribute.CollationFlag, "     Flag indicating that the films of the print request\n     shall be collated. Enumerated Values:\n     YES\n     NO\n");
        hashMap.put(DicomAttribute.AnnotationFlag, "     Flag describing how printers that do not support\n     Annotation Content Sequence (2130,0050) shall\n     react if it is contained in the Stored Print IOD.\n     Enumerated Values:\n     BESTFIT = print images without Annotation\n     REJECT = do not attempt to print images\n");
        hashMap.put(DicomAttribute.ImageOverlayFlag, "     Flag describing how printers that do not support\n     Image Overlay Box Content Sequence (2130,0060)\n      shall react if it is contained in the Stored Print IOD.\n     Enumerated Values:\n     BESTFIT = print images without the Overlay(s)\n     REJECT = do not attempt to print images\n");
        hashMap.put(DicomAttribute.PresentationLUTFlag, "     Flag describing how printers that do not support\n     Presentation LUT Content Sequence (2130,0080)\n     shall react if it is contained in the Stored Print IOD.\n     Enumerated Values:\n     BESTFIT = print images without a Presentation LUT\n     REJECT = do not attempt to print images\n");
        hashMap.put(DicomAttribute.ImageBoxPresentationLUTFlag, "     Flag describing how printers that do not support\n     Presentation LUT Content Sequence (2130,0080) at\n     the Image Box level shall react if a Presentation\n     LUT is contained in Image Box Content Sequence\n     (2130,0040). Enumerated Values:\n     BESTFIT = print image with the Presentation LUT\n     specified in Film Box Content Sequence\n     (2130,0030).\n     REJECT = do not attempt to print images\n");
        hashMap.put(DicomAttribute.ReferencedStoredPrintSequence, "     Reference to Stored Print Storage SOP Instance.\n     Sequence contains one or more items.\n");
        hashMap.put(DicomAttribute.PrinterConfiguration, "    Contains printer configuration information for a\n    single Application Entity title. See Print\n    Management Service Class Structure in PS 3.4.\n    The sequence shall contain one item for each\n    physical printer/Meta SOP Class combination\n    supported by the Application Entity title.\n");
        return hashMap;
    }
}

