/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom;

import StringUtilities.StringStrip;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;

public class ImageDisplayParameters {
    private static final Command[] commands = new Command[]{new Command("STANDARD", 2)};
    private String mCommand;
    private int[] mArguments;

    public ImageDisplayParameters(String string, int[] nArray) {
        this.init(string, nArray);
    }

    public ImageDisplayParameters(String string) throws ParseException {
        if (!string.endsWith(",")) {
            string = string + ",";
        }
        String string2 = null;
        String[] stringArray = string.split("[\\\\,]");
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if (string2 == null) {
            throw new ParseException("Could not find a command in " + string, 0);
        }
        if (!ImageDisplayParameters.isAValidCommand(string2)) {
            throw new ParseException("Invalid command: " + string2, 0);
        }
        int[] nArray = new int[stringArray.length - 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            try {
                nArray[i2] = Integer.parseInt(StringStrip.stripNonNumericChars(stringArray[i2 + 1]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(stringArray[i2 + 1] + " is not a number.", 0);
            }
        }
        if (!ImageDisplayParameters.getCommand(string2).isCorrectNumberOfArgs(nArray.length)) {
            throw new ParseException("Wrong number of parameters for command \"" + ImageDisplayParameters.getCommand(string2) + "\". Should not have " + nArray.length + " arguments.", 0);
        }
        this.init(string2, nArray);
    }

    private void init(String string, int[] nArray) {
        if (!ImageDisplayParameters.isAValidCommand(string)) {
            throw new IllegalArgumentException(string + " is not a valid command.");
        }
        this.mCommand = string.toUpperCase();
        this.mArguments = (int[])nArray.clone();
    }

    private String getCommand() {
        return this.mCommand;
    }

    public int[] getArguments() {
        return (int[])this.mArguments.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(this.getCommand() + "\\");
        for (int i2 = 0; i2 < this.mArguments.length; ++i2) {
            stringBuffer.append("" + this.mArguments[i2]);
            if (i2 == this.mArguments.length - 1) continue;
            stringBuffer.append(",");
        }
        return new String(stringBuffer);
    }

    public static boolean isAValidCommand(String string) {
        return ImageDisplayParameters.getCommand(string) != null;
    }

    private static Command getCommand(String string) {
        string = string.toUpperCase();
        Iterator<Command> iterator = Arrays.asList(commands).iterator();
        while (iterator.hasNext()) {
            Command command = iterator.next();
            if (!command.getCommandName().equals(string)) continue;
            return command;
        }
        return null;
    }

    private static class Command {
        private final String mCommandName;
        private int mNumberOfArgs;

        public Command(String string, int n2) {
            this.mCommandName = string;
            this.mNumberOfArgs = n2;
        }

        public boolean isCorrectNumberOfArgs(int n2) {
            if (this.mNumberOfArgs < 0) {
                return n2 >= -this.mNumberOfArgs;
            }
            return n2 == this.mNumberOfArgs;
        }

        public String getCommandName() {
            return this.mCommandName;
        }

        public String toString() {
            return this.mCommandName;
        }
    }
}

