/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;

public class AgfaDrystar3000 {
    private static final String IMAGE_DISPLAY_FORMATS = "1,1 1,2 1,3 2,1 2,2 2,3 2,4 3,3 3,4 3,5 3,6 4,4 4,5 4,6 4,7 4,8 5,5 5,6 5,7 5,8 6,6 6,7 6,8 6,9 6,10 7,7 7,8 7,9 7,10 8,8 8,9 8,10";

    public static PrinterConfiguration getConfiguration() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocolName("AGFA Drystar 3000 Defaults");
        printerConfiguration.setValidRange(DicomAttribute.NumberOfCopies, 1, 99, 1);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.PrintPriority, new String[]{"LOW", "HIGH"}, (Object)"LOW");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MediumType, new String[]{"CLEAR FILM", "BLUE FILM", "PAPER"}, (Object)"CLEAR FILM");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmDestination, new String[]{"PROCESSOR", "MAGAZINE"}, (Object)"PROCESSOR");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ImageDisplayFormat, DicomPrintConstants.createEntries("STANDARD\\", IMAGE_DISPLAY_FORMATS), (Object)"STANDARD\\1,1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmOrientation, new String[]{"PORTRAIT", "LANDSCAPE"}, (Object)"PORTRAIT");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmSizeID, new String[]{"8INX10IN", "11INX14IN", "14INX14IN", "14INX17IN"}, (Object)"14INX17IN");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MagnificationType, new String[]{"BILINEAR", "REPLICATE", "CUBIC"}, (Object)"CUBIC");
        printerConfiguration.acceptAnyValue(DicomAttribute.SmoothingType);
        printerConfiguration.acceptAnyValue(DicomAttribute.RequestedResolutionID);
        printerConfiguration.setValidValuesAndRange(DicomAttribute.BorderDensity, new String[]{"BLACK", "WHITE"}, 0, 255, "BLACK");
        printerConfiguration.setValidValuesAndRange(DicomAttribute.EmptyImageDensity, new String[]{"BLACK", "WHITE"}, 0, 255, "BLACK");
        printerConfiguration.acceptAnyValue(DicomAttribute.MinDensity);
        printerConfiguration.acceptAnyValue(DicomAttribute.MaxDensity);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.Trim, new String[]{"YES", "NO"}, (Object)"YES");
        printerConfiguration.acceptAnyValue(DicomAttribute.ConfigurationInformation);
        printerConfiguration.verifyConfiguration();
        return printerConfiguration;
    }
}

