/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;

public class AycanXrayPrint {
    public static PrinterConfiguration getPrinterConfiguration() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocolName("Aycan Xray-Print Defaults");
        printerConfiguration.setValidValue(PrintProtocol.Collate, Boolean.TRUE);
        printerConfiguration.setValidRange(DicomAttribute.NumberOfCopies, 1, 10, 1);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.PrintPriority, new String[]{"LOW", "MED", "HIGH"}, (Object)"MED");
        printerConfiguration.setValidValue(DicomAttribute.MediumType, "PAPER");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmDestination, new String[]{"MAGAZINE", "PROCESSOR"}, (Object)"PROCESSOR");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ImageDisplayFormat, DicomPrintConstants.createEntries("STANDARD\\", PrinterConfiguration.createMasterImageDisplayFormat()), (Object)"STANDARD\\1,1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmOrientation, new String[]{"PORTRAIT", "LANDSCAPE"}, (Object)"PORTRAIT");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmSizeID, new String[]{"8INX10IN", "8_5INX11IN", "10INX12IN", "10INX14IN", "11INX14IN", "11INX17IN", "14INX14IN", "14INX17IN", "24CMX24CM", "24CMX30CM", "A4", "A3"}, (Object)"8INX10IN");
        printerConfiguration.acceptAnyValue(DicomAttribute.MagnificationType);
        printerConfiguration.acceptAnyValue(DicomAttribute.SmoothingType);
        printerConfiguration.acceptAnyValue(DicomAttribute.RequestedResolutionID);
        printerConfiguration.setValidValuesAndRange(DicomAttribute.BorderDensity, new String[]{"WHITE", "BLACK"}, 0, 350, "WHITE");
        printerConfiguration.setValidValuesAndRange(DicomAttribute.EmptyImageDensity, new String[]{"WHITE", "BLACK"}, 0, 350, "WHITE");
        printerConfiguration.setValidRange(DicomAttribute.MinDensity, 0, 350, 0);
        printerConfiguration.setValidRange(DicomAttribute.MaxDensity, 0, 350, 350);
        printerConfiguration.acceptAnyValue(DicomAttribute.Trim);
        printerConfiguration.acceptAnyValue(DicomAttribute.ConfigurationInformation);
        printerConfiguration.verifyConfiguration();
        return printerConfiguration;
    }
}

