/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.MapDataModel;
import DataModels.ModelProperty;
import InteleDicomLibrary.Print.DicomPrintImageProvider;
import InteleDicomLibrary.Services.DicomConnectionParameters;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.dicom.print.Printer;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrintJob
extends MapDataModel {
    public static final ModelProperty Printer = new ModelProperty(Printer.class, "Printer", "Printer");
    public static final ModelProperty Protocol = new ModelProperty(PrintProtocol.class, "Protocol", "Print Protocol");
    public static final ModelProperty ImageProvider = new ModelProperty(DicomPrintImageProvider.class, "ImageProvider", "Image Provider");
    public static final ModelProperty AeTitle = new ModelProperty(String.class, "AeTitle", "AE Title");
    public static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(Printer, Protocol, ImageProvider, AeTitle));

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        return super.getProperty(modelProperty);
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public void setImageProvider(DicomPrintImageProvider dicomPrintImageProvider) {
        this.setProperty(ImageProvider, dicomPrintImageProvider);
    }

    public void setProtocol(PrintProtocol printProtocol) {
        this.setProperty(Protocol, printProtocol);
    }

    public void setPrinter(Printer printer) {
        this.setProperty(Printer, printer);
    }

    public Printer getPrinter() {
        return (Printer)this.getProperty(Printer);
    }

    public PrintProtocol getProtocol() {
        return (PrintProtocol)this.getProperty(Protocol);
    }

    public PrinterConfiguration getConfiguration() {
        return this.getPrinter().getConfiguration();
    }

    public void setCallingAeTitle(String string) {
        this.setProperty(AeTitle, string);
    }

    public String getCallingAeTitle() {
        return (String)this.getProperty(AeTitle);
    }

    public DicomPrintImageProvider getImageProvider() {
        return (DicomPrintImageProvider)this.getProperty(ImageProvider);
    }

    public DicomConnectionParameters getConnectionParameters() {
        Printer printer = this.getPrinter();
        return new DicomConnectionParameters(printer.getHost(), printer.getPort(), printer.getAeTitle(), this.getCallingAeTitle());
    }

    public boolean collate() {
        return this.getProtocol().collate();
    }
}

