/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.validation.DataModelValidator;
import com.intelerad.datamodels.validation.Validator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrinterConfiguration
extends DataModelValidator {
    private PrintProtocol mDefaultValues = new PrintProtocol();

    public PrinterConfiguration() {
        this.setValidValues(PrintProtocol.Collate, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
        this.setValidValues(PrintProtocol.TrueSize, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    }

    public PrinterConfiguration(PrinterConfiguration printerConfiguration) {
        super(printerConfiguration);
        this.mDefaultValues = new PrintProtocol(printerConfiguration.mDefaultValues);
    }

    public Object getDefaultValue(ModelProperty modelProperty) {
        return this.mDefaultValues.getProperty(modelProperty);
    }

    public void setDefaultProtocol(PrintProtocol printProtocol) {
        this.mDefaultValues = new PrintProtocol(printProtocol);
    }

    public PrintProtocol getDefaultProtocol() {
        return this.mDefaultValues;
    }

    public void setValidRange(ModelProperty modelProperty, int n2, int n3, int n4) {
        this.setValidRange(modelProperty, n2, n3);
        this.mDefaultValues.setProperty(modelProperty, new Integer(n4));
    }

    public void setValidValue(ModelProperty modelProperty, Object object) {
        this.setValidValues(modelProperty, new Object[]{object}, object);
    }

    public void setValidValues(ModelProperty modelProperty, List list, Object object) {
        this.setValidValues(modelProperty, list);
        this.mDefaultValues.setProperty(modelProperty, object);
    }

    public void setValidValues(ModelProperty modelProperty, Object[] objectArray, Object object) {
        this.setValidValues(modelProperty, objectArray);
        this.mDefaultValues.setProperty(modelProperty, object);
    }

    public void setValidValuesAndRange(ModelProperty modelProperty, Object[] objectArray, int n2, int n3, Object object) {
        this.setValidValuesAndRange(modelProperty, objectArray, n2, n3);
        this.mDefaultValues.setProperty(modelProperty, object);
    }

    public List getImageDisplayFormats() {
        return this.getValidator(DicomAttribute.ImageDisplayFormat).getValidValues();
    }

    public void acceptAnyValue(ModelProperty modelProperty) {
        super.acceptAnyValue(modelProperty);
        if (modelProperty.getValueClass() == String.class) {
            this.mDefaultValues.setProperty(modelProperty, "");
        } else if (modelProperty.getValueClass() == Integer.class) {
            this.mDefaultValues.setProperty(modelProperty, new Integer(0));
        } else {
            throw new IllegalArgumentException("Add a special case for property " + modelProperty.getName());
        }
    }

    public boolean hasImageLayoutSettings() {
        return this.hasSettings(DicomAttribute.ImageDisplayFormat);
    }

    public boolean hasFilmOrientationSettings() {
        return this.hasSettings(DicomAttribute.FilmOrientation);
    }

    public boolean hasFilmImageSizeSettings() {
        return this.hasSettings(DicomAttribute.FilmSizeID);
    }

    public void setDefaultProtocolName(String string) {
        this.mDefaultValues.setProperty(PrintProtocol.Name, string);
    }

    protected boolean isValidProperty(Validator validator, ModelProperty modelProperty, Object object) {
        return super.isValidProperty(validator, modelProperty, object != null ? object : this.getDefaultValue(modelProperty));
    }

    private boolean hasSettings(ModelProperty modelProperty) {
        Validator validator = this.getValidator(modelProperty);
        return validator != null && !validator.getValidValues().isEmpty();
    }

    public Map getModule(List list, PrintProtocol printProtocol) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DicomAttribute dicomAttribute = (DicomAttribute)iterator.next();
            if (!this.hasSettings(dicomAttribute)) continue;
            hashMap.put(new Integer(dicomAttribute.getJdtDname()), printProtocol.getProperty(dicomAttribute));
        }
        return hashMap;
    }

    public void verifyConfiguration() {
        Iterator iterator = PrintProtocol.PROPERTIES.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            if (this.getDefaultValue(modelProperty) != null) continue;
            throw new IllegalStateException("Printer " + this.mDefaultValues.getName() + " is missing a default value for property " + modelProperty.getName());
        }
    }

    public int hashCode() {
        return this.mDefaultValues.hashCode() ^ super.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrinterConfiguration)) {
            return false;
        }
        if (!this.mDefaultValues.equals(((PrinterConfiguration)object).mDefaultValues)) {
            return false;
        }
        return super.equals(object);
    }

    public static PrinterConfiguration getMasterPrinterConfiguration() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocolName("Master Configuration Defaults");
        printerConfiguration.setValidRange(DicomAttribute.NumberOfCopies, 1, 99, 1);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.PrintPriority, new String[]{"LOW", "MED", "HIGH"}, (Object)"MED");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MediumType, new String[]{"PAPER", "CLEAR FILM", "BLUE FILM", "MAMMO CLEAR FILM", "MAMMO BLUE FILM"}, (Object)"CLEAR FILM");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmDestination, new String[]{"MAGAZINE", "PROCESSOR", "BIN1", "BIN2", "BIN3", "BIN4", "BIN5", "BIN6", "BIN7", "BIN8", "BIN9", "BIN10"}, (Object)"PROCESSOR");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ImageDisplayFormat, DicomPrintConstants.createEntries("STANDARD\\", PrinterConfiguration.createMasterImageDisplayFormat()), (Object)"STANDARD\\1,1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmOrientation, new String[]{"PORTRAIT", "LANDSCAPE"}, (Object)"PORTRAIT");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmSizeID, new String[]{"8INX10IN", "8_5INX11IN", "10INX12IN", "10INX14IN", "11INX14IN", "11INX17IN", "14INX14IN", "14INX17IN", "24CMX24CM", "24CMX30CM", "A4", "A3"}, (Object)"8INX10IN");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MagnificationType, new String[]{"NONE", "BILINEAR", "REPLICATE", "CUBIC"}, (Object)"NONE");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.SmoothingType, new String[]{"1", "2", "3", "4", "5", "6", "7", "9", "10", "11", "12", "13", "14", "15", "NORMAL", "ENHANCED"}, (Object)"NORMAL");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.RequestedResolutionID, new String[]{"STANDARD", "HIGH"}, (Object)"STANDARD");
        printerConfiguration.setValidValuesAndRange(DicomAttribute.BorderDensity, new String[]{"BLACK", "WHITE"}, 0, 350, "BLACK");
        printerConfiguration.setValidValuesAndRange(DicomAttribute.EmptyImageDensity, new String[]{"BLACK", "WHITE"}, 0, 350, "BLACK");
        printerConfiguration.setValidRange(DicomAttribute.MinDensity, 0, 399, 0);
        printerConfiguration.setValidRange(DicomAttribute.MaxDensity, 0, 399, 399);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.Trim, new String[]{"YES", "NO"}, (Object)"NO");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ConfigurationInformation, new String[]{"Value 1", "Value 2", "Value 3", "Value 4", "Value 5"}, (Object)"Value 1");
        printerConfiguration.verifyConfiguration();
        return printerConfiguration;
    }

    public static String createMasterImageDisplayFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 1; i2 <= 10; ++i2) {
            for (int i3 = 1; i3 <= 10; ++i3) {
                stringBuffer.append("" + i3 + "," + i2 + " ");
            }
        }
        return stringBuffer.toString();
    }

    public static PrinterConfiguration getEmptyConfiguration() {
        return new EmptyConfiguration();
    }

    private static class EmptyConfiguration
    extends PrinterConfiguration {
        private EmptyConfiguration() {
            this.setDefaultProtocolName("");
            this.setValidValue(DicomAttribute.ImageDisplayFormat, "STANDARD\\1,1");
            this.setValidValue(DicomAttribute.FilmOrientation, "PORTRAIT");
            this.setValidValue(DicomAttribute.FilmSizeID, "8INX10IN");
            this.acceptAnyValue(DicomAttribute.NumberOfCopies);
            this.acceptAnyValue(DicomAttribute.PrintPriority);
            this.acceptAnyValue(DicomAttribute.MediumType);
            this.acceptAnyValue(DicomAttribute.FilmDestination);
            this.acceptAnyValue(DicomAttribute.MagnificationType);
            this.acceptAnyValue(DicomAttribute.SmoothingType);
            this.acceptAnyValue(DicomAttribute.BorderDensity);
            this.acceptAnyValue(DicomAttribute.EmptyImageDensity);
            this.acceptAnyValue(DicomAttribute.MinDensity);
            this.acceptAnyValue(DicomAttribute.MaxDensity);
            this.acceptAnyValue(DicomAttribute.Trim);
            this.acceptAnyValue(DicomAttribute.ConfigurationInformation);
            this.acceptAnyValue(DicomAttribute.RequestedResolutionID);
            this.setDefaultProtocolName("No Configuration");
        }

        public boolean isValid(Object object) {
            return false;
        }
    }
}

