/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print.transferobject;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;
import com.intelerad.datamodels.validation.Validator;

public class PrinterConfigurationTransferObject1 {
    private PrintProtocol mDefaultProtocol = null;
    private Validator mCollateValidator;
    private Validator mTrueSizeValidator;
    private Validator mNumberOfCopiesValidator;
    private Validator mPrintPriorityValidator;
    private Validator mMediumTypeValidator;
    private Validator mFilmDestinationValidator;
    private Validator mImageDisplayFormatValidator;
    private Validator mFilmOrientationValidator;
    private Validator mFilmSizeIDValidator;
    private Validator mMagnificationTypeValidator;
    private Validator mSmoothingTypeValidator;
    private Validator mBorderDensityValidator;
    private Validator mEmptyImageDensityValidator;
    private Validator mMaxDensityValidator;
    private Validator mMinDensityValidator;
    private Validator mTrimValidator;
    private Validator mConfigurationInformationValidator;
    private Validator mRequestedResolutionIDValidator;

    public PrinterConfigurationTransferObject1() {
    }

    public PrinterConfigurationTransferObject1(PrinterConfiguration printerConfiguration) {
        this.mDefaultProtocol = printerConfiguration.getDefaultProtocol();
        this.mCollateValidator = printerConfiguration.getValidator(PrintProtocol.Collate);
        this.mTrueSizeValidator = printerConfiguration.getValidator(PrintProtocol.TrueSize);
        this.mNumberOfCopiesValidator = printerConfiguration.getValidator(DicomAttribute.NumberOfCopies);
        this.mPrintPriorityValidator = printerConfiguration.getValidator(DicomAttribute.PrintPriority);
        this.mMediumTypeValidator = printerConfiguration.getValidator(DicomAttribute.MediumType);
        this.mFilmDestinationValidator = printerConfiguration.getValidator(DicomAttribute.FilmDestination);
        this.mImageDisplayFormatValidator = printerConfiguration.getValidator(DicomAttribute.ImageDisplayFormat);
        this.mFilmOrientationValidator = printerConfiguration.getValidator(DicomAttribute.FilmOrientation);
        this.mFilmSizeIDValidator = printerConfiguration.getValidator(DicomAttribute.FilmSizeID);
        this.mMagnificationTypeValidator = printerConfiguration.getValidator(DicomAttribute.MagnificationType);
        this.mSmoothingTypeValidator = printerConfiguration.getValidator(DicomAttribute.SmoothingType);
        this.mBorderDensityValidator = printerConfiguration.getValidator(DicomAttribute.BorderDensity);
        this.mEmptyImageDensityValidator = printerConfiguration.getValidator(DicomAttribute.EmptyImageDensity);
        this.mMaxDensityValidator = printerConfiguration.getValidator(DicomAttribute.MaxDensity);
        this.mMinDensityValidator = printerConfiguration.getValidator(DicomAttribute.MinDensity);
        this.mTrimValidator = printerConfiguration.getValidator(DicomAttribute.Trim);
        this.mConfigurationInformationValidator = printerConfiguration.getValidator(DicomAttribute.ConfigurationInformation);
        this.mRequestedResolutionIDValidator = printerConfiguration.getValidator(DicomAttribute.RequestedResolutionID);
    }

    public PrinterConfiguration readResolve() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocol(this.mDefaultProtocol);
        this.setValidator(printerConfiguration, PrintProtocol.Collate, this.mCollateValidator);
        this.setValidator(printerConfiguration, PrintProtocol.TrueSize, this.mTrueSizeValidator);
        this.setValidator(printerConfiguration, DicomAttribute.NumberOfCopies, this.mNumberOfCopiesValidator);
        this.setValidator(printerConfiguration, DicomAttribute.PrintPriority, this.mPrintPriorityValidator);
        this.setValidator(printerConfiguration, DicomAttribute.MediumType, this.mMediumTypeValidator);
        this.setValidator(printerConfiguration, DicomAttribute.FilmDestination, this.mFilmDestinationValidator);
        this.setValidator(printerConfiguration, DicomAttribute.ImageDisplayFormat, this.mImageDisplayFormatValidator);
        this.setValidator(printerConfiguration, DicomAttribute.FilmOrientation, this.mFilmOrientationValidator);
        this.setValidator(printerConfiguration, DicomAttribute.FilmSizeID, this.mFilmSizeIDValidator);
        this.setValidator(printerConfiguration, DicomAttribute.MagnificationType, this.mMagnificationTypeValidator);
        this.setValidator(printerConfiguration, DicomAttribute.SmoothingType, this.mSmoothingTypeValidator);
        this.setValidator(printerConfiguration, DicomAttribute.BorderDensity, this.mBorderDensityValidator);
        this.setValidator(printerConfiguration, DicomAttribute.EmptyImageDensity, this.mEmptyImageDensityValidator);
        this.setValidator(printerConfiguration, DicomAttribute.MaxDensity, this.mMaxDensityValidator);
        this.setValidator(printerConfiguration, DicomAttribute.MinDensity, this.mMinDensityValidator);
        this.setValidator(printerConfiguration, DicomAttribute.Trim, this.mTrimValidator);
        this.setValidator(printerConfiguration, DicomAttribute.ConfigurationInformation, this.mConfigurationInformationValidator);
        this.setValidator(printerConfiguration, DicomAttribute.RequestedResolutionID, this.mRequestedResolutionIDValidator);
        return printerConfiguration;
    }

    private void setValidator(PrinterConfiguration printerConfiguration, ModelProperty modelProperty, Validator validator) {
        if (validator != null) {
            printerConfiguration.setValidator(modelProperty, validator);
        }
    }
}

