/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.teachingfile.transferobject;

import com.intelerad.datamodels.teachingfile.AccessLevel;
import com.intelerad.datamodels.teachingfile.TeachingCase;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TeachingCaseTransferObject1 {
    private String mCaseId = "";
    private String mDescription = "";
    private List mAcrCodes = Collections.EMPTY_LIST;
    private String mBodyPart = "";
    private String mPathology = "";
    private String mClinicalHistory = "";
    private String mTeachingClinicalHistory = "";
    private String mClinicalImpression = "";
    private String mReasonForStudy = "";
    private List mKeywords = Collections.EMPTY_LIST;
    private String mNotes = "";
    private String mAccessLevel = AccessLevel.PUBLIC.getName();
    private String mLastModifiedBy = "";
    private Date mLastModifiedOn = new Date(0L);
    private String mCreatedBy = "";
    private Date mCreatedOn = new Date(0L);
    private List mSeriesUids = Collections.EMPTY_LIST;
    private String mPatientId = null;
    private Date mStudyDate = null;
    private String mDiagnosis = "";

    public TeachingCaseTransferObject1() {
    }

    public TeachingCaseTransferObject1(TeachingCase teachingCase) {
        this.mCaseId = teachingCase.getCaseId();
        this.mDescription = teachingCase.getDescription();
        this.mAcrCodes = teachingCase.getAcrCodes();
        this.mBodyPart = teachingCase.getAnatomy();
        this.mPathology = teachingCase.getPathology();
        this.mClinicalHistory = teachingCase.getClinicalHistory();
        this.mTeachingClinicalHistory = teachingCase.getTeachingClinicalHistory();
        this.mClinicalImpression = teachingCase.getClinicalImpression();
        this.mReasonForStudy = teachingCase.getReasonForStudy();
        this.mKeywords = teachingCase.getKeywords();
        this.mNotes = teachingCase.getNotes();
        this.mAccessLevel = teachingCase.getAccessLevel().getName();
        this.mLastModifiedBy = teachingCase.getLastModifiedBy();
        this.mLastModifiedOn = teachingCase.getLastModifiedOn();
        this.mCreatedBy = teachingCase.getCreatedBy();
        this.mCreatedOn = teachingCase.getCreatedOn();
        this.mSeriesUids = teachingCase.getSeriesUids();
        this.mPatientId = teachingCase.getPatientId();
        this.mStudyDate = teachingCase.getStudyDate();
        this.mDiagnosis = teachingCase.getDiagnosis();
    }

    public TeachingCase readResolve() {
        TeachingCase teachingCase = new TeachingCase();
        teachingCase.setCaseId(this.mCaseId);
        teachingCase.setDescription(this.mDescription);
        teachingCase.setAcrCodes(this.mAcrCodes);
        teachingCase.setAnatomy(this.mBodyPart);
        teachingCase.setPathology(this.mPathology);
        teachingCase.setClinicalHistory(this.mClinicalHistory);
        teachingCase.setTeachingClinicalHistory(this.mTeachingClinicalHistory);
        teachingCase.setClinicalImpression(this.mClinicalImpression);
        teachingCase.setReasonForStudy(this.mReasonForStudy);
        teachingCase.setKeywords(this.mKeywords);
        teachingCase.setNotes(this.mNotes);
        teachingCase.setAccessLevel(AccessLevel.fromName(this.mAccessLevel));
        teachingCase.setLastModifiedBy(this.mLastModifiedBy);
        teachingCase.setLastModifiedOn(this.mLastModifiedOn);
        teachingCase.setCreatedBy(this.mCreatedBy);
        teachingCase.setCreatedOn(this.mCreatedOn);
        teachingCase.setSeriesUids(this.mSeriesUids);
        teachingCase.setPatientId(this.mPatientId);
        teachingCase.setStudyDate(this.mStudyDate);
        teachingCase.setDiagnosis(this.mDiagnosis);
        return teachingCase;
    }
}

