/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.userprofile;

import com.intelerad.datamodels.userprofile.GenericIdentifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractProfileModel {
    protected final GenericIdentifier mGenericIdentifier;
    private final Map mPreferenceMap;
    private long mProfileRevisionId;

    AbstractProfileModel(GenericIdentifier genericIdentifier) {
        this(genericIdentifier, null);
    }

    AbstractProfileModel(GenericIdentifier genericIdentifier, Map map) {
        this(genericIdentifier, map, 0L);
    }

    AbstractProfileModel(GenericIdentifier genericIdentifier, Map map, long l2) {
        this.mPreferenceMap = map != null ? new HashMap(map) : new HashMap();
        this.mGenericIdentifier = genericIdentifier;
        this.mProfileRevisionId = l2;
    }

    AbstractProfileModel(AbstractProfileModel abstractProfileModel) {
        this.mPreferenceMap = new HashMap(abstractProfileModel.mPreferenceMap);
        this.mGenericIdentifier = abstractProfileModel.mGenericIdentifier;
        this.mProfileRevisionId = abstractProfileModel.mProfileRevisionId;
    }

    public void put(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("User Preference path and value must not be null");
        }
        this.mPreferenceMap.put(string, string2);
    }

    public String get(String string) {
        return (String)this.mPreferenceMap.get(string);
    }

    public String removeKey(String string) {
        return (String)this.mPreferenceMap.remove(string);
    }

    public Map getPreferenceMap() {
        return new HashMap(this.mPreferenceMap);
    }

    public int size() {
        return this.mPreferenceMap.size();
    }

    public Set keySet() {
        return new HashSet(this.mPreferenceMap.keySet());
    }

    public long getProfileRevisionId() {
        return this.mProfileRevisionId;
    }

    public void setProfileRevisionId(long l2) {
        this.mProfileRevisionId = l2;
    }
}

