/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.userprofile;

import com.intelerad.datamodels.userprofile.ApplicationContext;
import com.intelerad.datamodels.userprofile.Category;
import com.intelerad.datamodels.userprofile.RoamingTemplateIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RoamingTemplateAttributes {
    private final Map mTemplateIdentifierToAttributeMap;
    private final Category mCategory;
    private final ApplicationContext mApplicationContext;

    public RoamingTemplateAttributes(Category category, ApplicationContext applicationContext) {
        this.mCategory = category;
        this.mApplicationContext = applicationContext;
        this.mTemplateIdentifierToAttributeMap = new HashMap();
    }

    public RoamingTemplateAttributes(RoamingTemplateAttributes roamingTemplateAttributes) {
        this.mCategory = roamingTemplateAttributes.mCategory;
        this.mApplicationContext = roamingTemplateAttributes.mApplicationContext;
        this.mTemplateIdentifierToAttributeMap = new HashMap();
        Iterator iterator = roamingTemplateAttributes.mTemplateIdentifierToAttributeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RoamingTemplateIdentifier roamingTemplateIdentifier = (RoamingTemplateIdentifier)entry.getKey();
            Map map = (Map)entry.getValue();
            this.putAttributeMap(roamingTemplateIdentifier, map);
        }
    }

    public Set getTemplateIdentifiers() {
        return new HashSet(this.mTemplateIdentifierToAttributeMap.keySet());
    }

    public Category getCategory() {
        return this.mCategory;
    }

    public ApplicationContext getApplicationContext() {
        return this.mApplicationContext;
    }

    public void ensureTemplateIdentifierPresent(RoamingTemplateIdentifier roamingTemplateIdentifier) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        if (this.mTemplateIdentifierToAttributeMap.containsKey(roamingTemplateIdentifier)) {
            return;
        }
        this.mTemplateIdentifierToAttributeMap.put(roamingTemplateIdentifier, new HashMap());
    }

    public void removeTemplateIdentifier(RoamingTemplateIdentifier roamingTemplateIdentifier) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        this.mTemplateIdentifierToAttributeMap.remove(roamingTemplateIdentifier);
    }

    public void putAttribute(RoamingTemplateIdentifier roamingTemplateIdentifier, String string, String string2) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        if (string2 == null || string == null) {
            throw new IllegalArgumentException("Attribute name or value cannot be null");
        }
        HashMap<String, String> hashMap = (HashMap<String, String>)this.mTemplateIdentifierToAttributeMap.get(roamingTemplateIdentifier);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            this.mTemplateIdentifierToAttributeMap.put(roamingTemplateIdentifier, hashMap);
        }
        hashMap.put(string, string2);
    }

    public String getAttribute(RoamingTemplateIdentifier roamingTemplateIdentifier, String string) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        Map map = (Map)this.mTemplateIdentifierToAttributeMap.get(roamingTemplateIdentifier);
        if (map == null) {
            return null;
        }
        return (String)map.get(string);
    }

    public void removeAttribute(RoamingTemplateIdentifier roamingTemplateIdentifier, String string) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        Map map = (Map)this.mTemplateIdentifierToAttributeMap.get(roamingTemplateIdentifier);
        if (map != null) {
            map.remove(string);
        }
    }

    public Map getAttributeMap(RoamingTemplateIdentifier roamingTemplateIdentifier) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        Map map = (Map)this.mTemplateIdentifierToAttributeMap.get(roamingTemplateIdentifier);
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public void putAttributeMap(RoamingTemplateIdentifier roamingTemplateIdentifier, Map map) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        this.mTemplateIdentifierToAttributeMap.put(roamingTemplateIdentifier, new HashMap(map));
    }

    public boolean hasAttributes(RoamingTemplateIdentifier roamingTemplateIdentifier) {
        this.validateCategoryContext(roamingTemplateIdentifier);
        Map map = (Map)this.mTemplateIdentifierToAttributeMap.get(roamingTemplateIdentifier);
        return map != null && !map.isEmpty();
    }

    private void validateCategoryContext(RoamingTemplateIdentifier roamingTemplateIdentifier) {
        if (!roamingTemplateIdentifier.getCategory().equals((Object)this.mCategory) || !roamingTemplateIdentifier.getApplicationContext().equals((Object)this.mApplicationContext)) {
            throw new IllegalArgumentException(roamingTemplateIdentifier.toString() + " is not of category/context " + (Object)((Object)this.mCategory) + "/" + (Object)((Object)this.mApplicationContext));
        }
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.mApplicationContext == null ? 0 : this.mApplicationContext.hashCode());
        n2 = 31 * n2 + (this.mCategory == null ? 0 : this.mCategory.hashCode());
        n2 = 31 * n2 + (this.mTemplateIdentifierToAttributeMap == null ? 0 : ((Object)this.mTemplateIdentifierToAttributeMap).hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RoamingTemplateAttributes roamingTemplateAttributes = (RoamingTemplateAttributes)object;
        if (this.mApplicationContext == null ? roamingTemplateAttributes.mApplicationContext != null : !this.mApplicationContext.equals((Object)roamingTemplateAttributes.mApplicationContext)) {
            return false;
        }
        if (this.mCategory == null ? roamingTemplateAttributes.mCategory != null : !this.mCategory.equals((Object)roamingTemplateAttributes.mCategory)) {
            return false;
        }
        return !(this.mTemplateIdentifierToAttributeMap == null ? roamingTemplateAttributes.mTemplateIdentifierToAttributeMap != null : !((Object)this.mTemplateIdentifierToAttributeMap).equals(roamingTemplateAttributes.mTemplateIdentifierToAttributeMap));
    }
}

