/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.validation;

import com.intelerad.datamodels.validation.Validator;
import com.intelerad.datamodels.validation.ValueInListValidator;
import com.intelerad.datamodels.validation.ValueInRangeValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompositeValidator
implements Validator {
    private final List mValidators;

    public CompositeValidator(List list) {
        this.mValidators = new ArrayList(list);
    }

    public boolean isValid(Object object) {
        Iterator iterator = this.mValidators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            if (!validator.isValid(object)) continue;
            return true;
        }
        return false;
    }

    public List getValidValues() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.mValidators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            arrayList.addAll(validator.getValidValues());
        }
        return arrayList;
    }

    public List getValidators() {
        return Collections.unmodifiableList(this.mValidators);
    }

    public ValueInListValidator getValueInListValidator() {
        return (ValueInListValidator)this.getValidator(ValueInListValidator.class);
    }

    public ValueInRangeValidator getValueInRangeValidator() {
        return (ValueInRangeValidator)this.getValidator(ValueInRangeValidator.class);
    }

    public Validator getValidator(Class clazz) {
        Iterator iterator = this.mValidators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            if (validator.getClass() != clazz) continue;
            return validator;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.mValidators.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return ((Object)this.mValidators).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeValidator)) {
            return false;
        }
        CompositeValidator compositeValidator = (CompositeValidator)object;
        return ((Object)this.mValidators).equals(compositeValidator.mValidators);
    }

    public static ValueInListValidator getValueInListValidator(Validator validator) {
        if (validator instanceof ValueInListValidator) {
            return (ValueInListValidator)validator;
        }
        if (validator instanceof CompositeValidator) {
            return ((CompositeValidator)validator).getValueInListValidator();
        }
        return null;
    }

    public static ValueInRangeValidator getValueInRangeValidator(Validator validator) {
        if (validator instanceof ValueInRangeValidator) {
            return (ValueInRangeValidator)validator;
        }
        if (validator instanceof CompositeValidator) {
            return ((CompositeValidator)validator).getValueInRangeValidator();
        }
        return null;
    }
}

