/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.integration.voxar;

import com.intelerad.integration.voxar.VoxarEvents;
import com.intelerad.integration.voxar.VoxarImporter;
import com.intelerad.integration.voxar.VoxarProxyException;

public class VoxarProxy {
    private static final int DEFAULT_TIMEOUT = 10;
    private static final String DEFAULT_APP_PATH = new String("Voxar3D.exe");
    private static final String DEFAULT_ARGS = new String(" /var=  /inboxonstartup=no");

    public VoxarProxy() {
        System.loadLibrary("VoxarLib");
        this.VoxarConstruct();
    }

    protected void finalize() {
        this.VoxarDestroy();
    }

    public void destroy() {
        this.finalize();
    }

    native void VoxarConstruct();

    native void VoxarStart(String var1, String var2) throws VoxarProxyException;

    native void VoxarConnect(int var1) throws VoxarProxyException;

    native void VoxarDisconnect() throws VoxarProxyException;

    native void VoxarAdvise(VoxarImporter var1, VoxarEvents var2) throws VoxarProxyException;

    native void VoxarUnAdvise();

    native void VoxarLoadImages(String[] var1, boolean var2) throws VoxarProxyException;

    native void VoxarClearContent(boolean var1) throws VoxarProxyException;

    native void VoxarStop() throws VoxarProxyException;

    native void VoxarKill() throws VoxarProxyException;

    native boolean VoxarIsConnected();

    native String VoxarDLLVersion();

    native void VoxarDestroy();

    public void start(String string, String string2) throws VoxarProxyException {
        this.VoxarStart(string, string2);
    }

    public void start(String string) throws VoxarProxyException {
        this.start(string, DEFAULT_ARGS);
    }

    public void start() throws VoxarProxyException {
        this.start(DEFAULT_APP_PATH, DEFAULT_ARGS);
    }

    public void connect(VoxarImporter voxarImporter, VoxarEvents voxarEvents, int n2) throws VoxarProxyException {
        if (!this.VoxarIsConnected()) {
            this.VoxarConnect(n2);
            this.VoxarAdvise(voxarImporter, voxarEvents);
        }
    }

    public void connect(VoxarImporter voxarImporter, VoxarEvents voxarEvents) throws VoxarProxyException {
        this.connect(voxarImporter, voxarEvents, 10);
    }

    public void loadImages(String[] stringArray, boolean bl2) throws VoxarProxyException {
        this.VoxarLoadImages(stringArray, bl2);
    }

    public void loadImages(String[] stringArray) throws VoxarProxyException {
        this.loadImages(stringArray, false);
    }

    public void clearContent(boolean bl2) throws VoxarProxyException {
        this.VoxarClearContent(bl2);
    }

    public void clearContent() throws VoxarProxyException {
        this.clearContent(false);
    }

    public void stop() throws VoxarProxyException {
        this.VoxarStop();
    }

    public void kill() throws VoxarProxyException {
        this.VoxarKill();
    }

    public boolean isConnected() {
        return this.VoxarIsConnected();
    }

    public String getVersion() {
        return this.VoxarDLLVersion();
    }
}

