/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.lib.dicomtools.DicomDir;
import com.intelerad.lib.dicomtools.FileMetaInformation;
import com.intelerad.lib.dicomtools.JdtUtil;
import com.intelerad.lib.dicomtools.Uid;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

class DicomDirBuilder {
    private static int TRANSFER_SYNTAX = 8194;
    private static final boolean SEQUENCE_UNDEFINED = true;
    private static final boolean GROUP_LENGTHS = true;
    private DicomDir.DirectoryRecord mRoot;
    private final File mDicomDirFile;
    private final String mFileSetId;

    public DicomDirBuilder(File file, String string, DicomDir.DirectoryRecord directoryRecord) {
        this.mDicomDirFile = file;
        this.mFileSetId = string;
        this.mRoot = directoryRecord;
    }

    public void write() throws DicomException, IOException {
        DicomObject dicomObject = this.createDicomDir();
        FileOutputStream fileOutputStream = new FileOutputStream(this.mDicomDirFile);
        dicomObject.write((OutputStream)fileOutputStream, true, TRANSFER_SYNTAX, true, true);
        fileOutputStream.close();
    }

    DicomObject createDicomDir() throws DicomException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(38, (Object)this.mFileSetId);
        dicomObject.set(41, (Object)new Long(0L));
        dicomObject.set(42, (Object)new Long(0L));
        dicomObject.set(43, (Object)new Integer(0));
        FileMetaInformation.setFileMetaInformation(dicomObject, JdtUtil.getUid(4098), Uid.getRandomUid(), JdtUtil.getUid(TRANSFER_SYNTAX), "1.2.840.114202.5.1");
        this.createDirectoryRecordSequence(dicomObject);
        this.computeOffsets(dicomObject);
        return dicomObject;
    }

    private void computeOffsets(DicomObject dicomObject) throws DicomException {
        this.populateChildOffsets(dicomObject, this.mRoot, 0);
    }

    private int populateChildOffsets(DicomObject dicomObject, DicomDir.DirectoryRecord directoryRecord, int n2) throws DicomException {
        long l2 = 0L;
        DicomObject dicomObject2 = null;
        long l3 = 0L;
        Iterator iterator = directoryRecord.getChildren().iterator();
        while (iterator.hasNext()) {
            DicomDir.DirectoryRecord directoryRecord2 = (DicomDir.DirectoryRecord)iterator.next();
            l3 = this.calculateOffset(dicomObject, n2);
            if (l2 == 0L) {
                l2 = l3;
            }
            if (dicomObject2 != null) {
                dicomObject2.set(45, (Object)new Long(l3));
            }
            dicomObject2 = directoryRecord2.getDicomObject();
            ++n2;
            n2 = this.populateChildOffsets(dicomObject, directoryRecord2, n2);
        }
        if (directoryRecord == this.mRoot) {
            dicomObject.set(41, (Object)new Long(l2));
            dicomObject.set(42, (Object)new Long(l3));
        } else {
            directoryRecord.getDicomObject().set(47, (Object)new Long(l2));
        }
        return n2;
    }

    private long calculateOffset(DicomObject dicomObject, int n2) {
        return dicomObject.calculateOffset(44, n2, TRANSFER_SYNTAX, true, true);
    }

    private void createDirectoryRecordSequence(DicomObject dicomObject) throws DicomException {
        this.addToDirectory(dicomObject, this.mRoot, 0);
    }

    private int addToDirectory(DicomObject dicomObject, DicomDir.DirectoryRecord directoryRecord, int n2) throws DicomException {
        if (directoryRecord != this.mRoot) {
            dicomObject.set(44, (Object)directoryRecord.getDicomObject(), n2);
            ++n2;
        }
        Iterator iterator = directoryRecord.getChildren().iterator();
        while (iterator.hasNext()) {
            DicomDir.DirectoryRecord directoryRecord2 = (DicomDir.DirectoryRecord)iterator.next();
            n2 = this.addToDirectory(dicomObject, directoryRecord2, n2);
        }
        return n2;
    }
}

