/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.intelerad.lib.dicomtools.DicomDirDirectoryType;
import com.intelerad.lib.dicomtools.DicomDirFilenameProvider;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DicomDirDirectoryMap {
    private static final NumberFormat DIRECTORY_NUMBER_FORMAT = new DecimalFormat("000000");
    private Map mDirectoryMap;
    private int mNextIndex;
    private File mDirectory;
    private DicomDirDirectoryType mType;

    public DicomDirDirectoryMap(File file, DicomDirDirectoryType dicomDirDirectoryType) {
        this.mDirectory = file;
        this.mType = dicomDirDirectoryType;
        this.mDirectoryMap = new LinkedHashMap();
        this.mNextIndex = 1;
    }

    public Object get(String string) {
        if (this.mDirectoryMap.containsKey(string)) {
            return this.mDirectoryMap.get(string);
        }
        return this.addNewEntry(string);
    }

    File getDirectory() {
        return this.mDirectory;
    }

    private String getDirectoryName(String string, int n2) {
        return string + DIRECTORY_NUMBER_FORMAT.format(n2);
    }

    private Object addNewEntry(String string) {
        Object object;
        File file;
        DicomDirDirectoryType dicomDirDirectoryType = this.mType.getNextType();
        while ((file = new File(this.mDirectory, (String)(object = this.getDirectoryName(dicomDirDirectoryType.getDirectoryNamePrefix(), this.mNextIndex++)))).exists()) {
        }
        object = dicomDirDirectoryType == DicomDirDirectoryType.SERIES ? new DicomDirFilenameProvider(file) : new DicomDirDirectoryMap(file, dicomDirDirectoryType);
        this.mDirectoryMap.put(string, object);
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mDirectory + "\n");
        Iterator iterator = this.mDirectoryMap.values().iterator();
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            stringBuffer.append(v2.toString());
        }
        return stringBuffer.toString();
    }
}

